/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type object3, int n) {
        boolean bl = jSONSerializer.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n, SerializerFeature.WriteClassName);
        SerializeWriter serializeWriter = jSONSerializer.out;
        Type type = null;
        if (bl) {
            type = TypeUtils.getCollectionItemType((Type)object3);
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        object3 = (List)object;
        if (object3.size() == 0) {
            serializeWriter.append("[]");
            return;
        }
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        try {
            if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                serializeWriter.append('[');
                jSONSerializer.incrementIndent();
                int n2 = 0;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (n2 != 0) {
                        serializeWriter.append(',');
                    }
                    jSONSerializer.println();
                    if (e != null) {
                        if (jSONSerializer.containsReference(e)) {
                            jSONSerializer.writeReference(e);
                        } else {
                            SerialContext serialContext2;
                            ObjectSerializer objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                            jSONSerializer.context = serialContext2 = new SerialContext(serialContext, object, object2, 0, 0);
                            objectSerializer.write(jSONSerializer, e, n2, type, n);
                        }
                    } else {
                        jSONSerializer.out.writeNull();
                    }
                    ++n2;
                }
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
                serializeWriter.append(']');
                return;
            }
            serializeWriter.append('[');
            int n3 = object3.size();
            for (int i = 0; i < n3; ++i) {
                ObjectSerializer objectSerializer;
                Object e = object3.get(i);
                if (i != 0) {
                    serializeWriter.append(',');
                }
                if (e == null) {
                    serializeWriter.append("null");
                    continue;
                }
                Class<?> clazz = e.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)e);
                    continue;
                }
                if (clazz == Long.class) {
                    long l = (Long)e;
                    if (bl) {
                        serializeWriter.writeLong(l);
                        serializeWriter.write(76);
                        continue;
                    }
                    serializeWriter.writeLong(l);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & n) != 0) {
                    objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                } else {
                    if (!serializeWriter.disableCircularReferenceDetect) {
                        SerialContext serialContext3;
                        jSONSerializer.context = serialContext3 = new SerialContext(serialContext, object, object2, 0, 0);
                    }
                    if (jSONSerializer.containsReference(e)) {
                        jSONSerializer.writeReference(e);
                        continue;
                    }
                    objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                    if ((SerializerFeature.WriteClassName.mask & n) != 0 && objectSerializer instanceof JavaBeanSerializer) {
                        ((JavaBeanSerializer)objectSerializer).writeNoneASM(jSONSerializer, e, i, type, n);
                        continue;
                    }
                }
                objectSerializer.write(jSONSerializer, e, i, type, n);
            }
            serializeWriter.append(']');
            return;
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }
}

