/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.serializer.AfterFilter;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.BeforeFilter;
import com.tradplus.ads.common.serialization.serializer.ContextValueFilter;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.LabelFilter;
import com.tradplus.ads.common.serialization.serializer.NameFilter;
import com.tradplus.ads.common.serialization.serializer.PropertyFilter;
import com.tradplus.ads.common.serialization.serializer.PropertyPreFilter;
import com.tradplus.ads.common.serialization.serializer.SerializeFilter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.serializer.ValueFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SerializeFilterable {
    protected List<BeforeFilter> beforeFilters = null;
    protected List<AfterFilter> afterFilters = null;
    protected List<PropertyFilter> propertyFilters = null;
    protected List<ValueFilter> valueFilters = null;
    protected List<NameFilter> nameFilters = null;
    protected List<PropertyPreFilter> propertyPreFilters = null;
    protected List<LabelFilter> labelFilters = null;
    protected List<ContextValueFilter> contextValueFilters = null;
    protected boolean writeDirect = true;

    public List<BeforeFilter> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<BeforeFilter>();
            this.writeDirect = false;
        }
        return this.beforeFilters;
    }

    public List<AfterFilter> getAfterFilters() {
        if (this.afterFilters == null) {
            this.afterFilters = new ArrayList<AfterFilter>();
            this.writeDirect = false;
        }
        return this.afterFilters;
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = new ArrayList<NameFilter>();
            this.writeDirect = false;
        }
        return this.nameFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFilters() {
        if (this.propertyPreFilters == null) {
            this.propertyPreFilters = new ArrayList<PropertyPreFilter>();
            this.writeDirect = false;
        }
        return this.propertyPreFilters;
    }

    public List<LabelFilter> getLabelFilters() {
        if (this.labelFilters == null) {
            this.labelFilters = new ArrayList<LabelFilter>();
            this.writeDirect = false;
        }
        return this.labelFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            this.propertyFilters = new ArrayList<PropertyFilter>();
            this.writeDirect = false;
        }
        return this.propertyFilters;
    }

    public List<ContextValueFilter> getContextValueFilters() {
        if (this.contextValueFilters == null) {
            this.contextValueFilters = new ArrayList<ContextValueFilter>();
            this.writeDirect = false;
        }
        return this.contextValueFilters;
    }

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            this.valueFilters = new ArrayList<ValueFilter>();
            this.writeDirect = false;
        }
        return this.valueFilters;
    }

    public void addFilter(SerializeFilter serializeFilter) {
        if (serializeFilter == null) {
            return;
        }
        if (serializeFilter instanceof PropertyPreFilter) {
            this.getPropertyPreFilters().add((PropertyPreFilter)serializeFilter);
        }
        if (serializeFilter instanceof NameFilter) {
            this.getNameFilters().add((NameFilter)serializeFilter);
        }
        if (serializeFilter instanceof ValueFilter) {
            this.getValueFilters().add((ValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof ContextValueFilter) {
            this.getContextValueFilters().add((ContextValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof PropertyFilter) {
            this.getPropertyFilters().add((PropertyFilter)serializeFilter);
        }
        if (serializeFilter instanceof BeforeFilter) {
            this.getBeforeFilters().add((BeforeFilter)serializeFilter);
        }
        if (serializeFilter instanceof AfterFilter) {
            this.getAfterFilters().add((AfterFilter)serializeFilter);
        }
        if (serializeFilter instanceof LabelFilter) {
            this.getLabelFilters().add((LabelFilter)serializeFilter);
        }
    }

    public boolean applyName(JSONSerializer jSONSerializer, Object object, String string) {
        Iterator<Object> iterator;
        if (jSONSerializer.propertyPreFilters != null) {
            iterator = jSONSerializer.propertyPreFilters.iterator();
            while (iterator.hasNext()) {
                if (((PropertyPreFilter)iterator.next()).apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        if (this.propertyPreFilters != null) {
            iterator = this.propertyPreFilters.iterator();
            while (iterator.hasNext()) {
                if (((PropertyPreFilter)iterator.next()).apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean apply(JSONSerializer iterator, Object object, String string, Object object2) {
        if (((JSONSerializer)((Object)iterator)).propertyFilters != null) {
            iterator = ((JSONSerializer)((Object)iterator)).propertyFilters.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().apply(object, string, object2)) continue;
                return false;
            }
        }
        if (this.propertyFilters != null) {
            iterator = this.propertyFilters.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().apply(object, string, object2)) continue;
                return false;
            }
        }
        return true;
    }

    protected String processKey(JSONSerializer iterator, Object object, String string, Object object2) {
        if (((JSONSerializer)((Object)iterator)).nameFilters != null) {
            iterator = ((JSONSerializer)((Object)iterator)).nameFilters.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().process(object, string, object2);
            }
        }
        if (this.nameFilters != null) {
            iterator = this.nameFilters.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().process(object, string, object2);
            }
        }
        return string;
    }

    protected Object processValue(JSONSerializer jSONSerializer, BeanContext beanContext, Object object, String string, Object object2) {
        return this.processValue(jSONSerializer, beanContext, object, string, object2, 0);
    }

    protected Object processValue(JSONSerializer jSONSerializer, BeanContext beanContext, Object object, String string, Object object2, int n) {
        Iterator<Object> iterator;
        if (object2 != null) {
            if ((SerializerFeature.isEnabled(jSONSerializer.out.features, n, SerializerFeature.WriteNonStringValueAsString) || beanContext != null && (beanContext.getFeatures() & SerializerFeature.WriteNonStringValueAsString.mask) != 0) && (object2 instanceof Number || object2 instanceof Boolean)) {
                String string2 = null;
                if (object2 instanceof Number && beanContext != null) {
                    string2 = beanContext.getFormat();
                }
                object2 = string2 != null ? new DecimalFormat(string2).format(object2) : object2.toString();
            } else if (beanContext != null && beanContext.isJsonDirect()) {
                object2 = JSON.parse((String)object2);
            }
        }
        if (jSONSerializer.valueFilters != null) {
            Iterator iterator2 = jSONSerializer.valueFilters.iterator();
            while (iterator2.hasNext()) {
                object2 = ((ValueFilter)iterator2.next()).process(object, string, object2);
            }
        }
        if ((iterator = this.valueFilters) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object2 = ((ValueFilter)iterator.next()).process(object, string, object2);
            }
        }
        if (jSONSerializer.contextValueFilters != null) {
            iterator = jSONSerializer.contextValueFilters.iterator();
            while (iterator.hasNext()) {
                object2 = ((ContextValueFilter)iterator.next()).process(beanContext, object, string, object2);
            }
        }
        if (this.contextValueFilters != null) {
            iterator = this.contextValueFilters.iterator();
            while (iterator.hasNext()) {
                object2 = ((ContextValueFilter)iterator.next()).process(beanContext, object, string, object2);
            }
        }
        return object2;
    }

    protected boolean writeDirect(JSONSerializer jSONSerializer) {
        return jSONSerializer.out.writeDirect && this.writeDirect && jSONSerializer.writeDirect;
    }
}

