/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.RyuDouble;
import com.tradplus.ads.common.serialization.util.RyuFloat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;

public final class SerializeWriter
extends Writer {
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private static final ThreadLocal<byte[]> bytesBufLocal = new ThreadLocal();
    private static final char[] VALUE_TRUE = ":true".toCharArray();
    private static final char[] VALUE_FALSE = ":false".toCharArray();
    private static int BUFFER_THRESHOLD = 131072;
    protected char[] buf;
    protected int count;
    protected int features;
    private final Writer writer;
    protected boolean useSingleQuotes;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeEnumUsingName;
    protected boolean writeEnumUsingToString;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize = -1;
    protected boolean browserSecure;
    protected long sepcialBits;
    static final int nonDirectFeatures;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this(writer, JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
    }

    public SerializeWriter(SerializerFeature ... serializerFeatureArray) {
        this((Writer)null, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... serializerFeatureArray) {
        this(writer, 0, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, int n, SerializerFeature ... serializerFeatureArray) {
        this.writer = writer;
        this.buf = bufLocal.get();
        if (this.buf != null) {
            bufLocal.set(null);
        } else {
            this.buf = new char[2048];
        }
        int n2 = n;
        SerializerFeature[] serializerFeatureArray2 = serializerFeatureArray;
        int n3 = serializerFeatureArray.length;
        for (int i = 0; i < n3; ++i) {
            SerializerFeature serializerFeature = serializerFeatureArray2[i];
            n2 |= serializerFeature.getMask();
        }
        this.features = n2;
        this.computeFeatures();
    }

    public final int getMaxBufSize() {
        return this.maxBufSize;
    }

    public final void setMaxBufSize(int n) {
        if (n < this.buf.length) {
            throw new JSONException("must > " + this.buf.length);
        }
        this.maxBufSize = n;
    }

    public final int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int n) {
        this(null, n);
    }

    public SerializeWriter(Writer writer, int n) {
        this.writer = writer;
        if (n <= 0) {
            throw new IllegalArgumentException("Negative initial size: ".concat(String.valueOf(n)));
        }
        this.buf = new char[n];
        this.computeFeatures();
    }

    public final void jsonCfg(SerializerFeature serializerFeature, boolean bl) {
        if (bl) {
            this.features |= serializerFeature.getMask();
            if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                this.features &= ~SerializerFeature.WriteEnumUsingName.getMask();
            } else if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                this.features &= ~SerializerFeature.WriteEnumUsingToString.getMask();
            }
        } else {
            this.features &= ~serializerFeature.getMask();
        }
        this.computeFeatures();
    }

    protected final void computeFeatures() {
        this.quoteFieldNames = (this.features & SerializerFeature.QuoteFieldNames.mask) != 0;
        this.useSingleQuotes = (this.features & SerializerFeature.UseSingleQuotes.mask) != 0;
        this.sortField = (this.features & SerializerFeature.SortField.mask) != 0;
        this.disableCircularReferenceDetect = (this.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.beanToArray = (this.features & SerializerFeature.BeanToArray.mask) != 0;
        this.writeNonStringValueAsString = (this.features & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.notWriteDefaultValue = (this.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.writeEnumUsingName = (this.features & SerializerFeature.WriteEnumUsingName.mask) != 0;
        this.writeEnumUsingToString = (this.features & SerializerFeature.WriteEnumUsingToString.mask) != 0;
        this.writeDirect = this.quoteFieldNames && (this.features & nonDirectFeatures) == 0 && (this.beanToArray || this.writeEnumUsingName);
        this.keySeperator = (char)(this.useSingleQuotes ? 39 : 34);
        boolean bl = this.browserSecure = (this.features & SerializerFeature.BrowserSecure.mask) != 0;
        this.sepcialBits = this.browserSecure ? 5764610843043954687L : ((this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? 140758963191807L : 0x4FFFFFFFFL);
    }

    public final boolean isSortField() {
        return this.sortField;
    }

    public final boolean isNotWriteDefaultValue() {
        return this.notWriteDefaultValue;
    }

    public final boolean isEnabled(SerializerFeature serializerFeature) {
        return (this.features & serializerFeature.mask) != 0;
    }

    public final boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    @Override
    public final void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                this.flush();
                n2 = 1;
            }
        }
        this.buf[this.count] = (char)n;
        this.count = n2;
    }

    @Override
    public final void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                do {
                    n3 = this.buf.length - this.count;
                    System.arraycopy(cArray, n, this.buf, this.count, n3);
                    this.count = this.buf.length;
                    this.flush();
                    n += n3;
                } while ((n2 -= n3) > this.buf.length);
                n3 = n2;
            }
        }
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public final void expandCapacity(int n) {
        char[] cArray;
        if (this.maxBufSize != -1 && n >= this.maxBufSize) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + n);
        }
        int n2 = this.buf.length + (this.buf.length >> 1) + 1;
        if (n2 < n) {
            n2 = n;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(this.buf, 0, cArray2, 0, this.count);
        if (this.buf.length < BUFFER_THRESHOLD && ((cArray = bufLocal.get()) == null || cArray.length < this.buf.length)) {
            bufLocal.set(this.buf);
        }
        this.buf = cArray2;
    }

    @Override
    public final SerializeWriter append(CharSequence charSequence) {
        charSequence = charSequence == null ? "null" : charSequence.toString();
        this.write((String)charSequence, 0, ((String)charSequence).length());
        return this;
    }

    @Override
    public final SerializeWriter append(CharSequence charSequence, int n, int n2) {
        charSequence = (charSequence == null ? "null" : charSequence).subSequence(n, n2).toString();
        this.write((String)charSequence, 0, ((String)charSequence).length());
        return this;
    }

    @Override
    public final SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public final void write(String string, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                do {
                    n3 = this.buf.length - this.count;
                    int n4 = n;
                    string.getChars(n4, n4 + n3, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    n += n3;
                } while ((n2 -= n3) > this.buf.length);
                n3 = n2;
            }
        }
        int n5 = n;
        string.getChars(n5, n5 + n2, this.buf, this.count);
        this.count = n3;
    }

    public final void writeTo(Writer writer) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        writer.write(this.buf, 0, this.count);
    }

    public final void writeTo(OutputStream outputStream, String string) {
        this.writeTo(outputStream, Charset.forName(string));
    }

    public final void writeTo(OutputStream outputStream, Charset charset) {
        this.writeToEx(outputStream, charset);
    }

    public final int writeToEx(OutputStream outputStream, Charset object) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (object == IOUtils.UTF8) {
            return this.encodeToUTF8(outputStream);
        }
        object = new String(this.buf, 0, this.count).getBytes((Charset)object);
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    public final char[] toCharArray() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        return cArray;
    }

    public final char[] toCharArrayForSpringWebSocket() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count - 2];
        System.arraycopy(this.buf, 1, cArray, 0, this.count - 2);
        return cArray;
    }

    public final byte[] toBytes(String string) {
        return this.toBytes(string == null || "UTF-8".equals(string) ? IOUtils.UTF8 : Charset.forName(string));
    }

    public final byte[] toBytes(Charset charset) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8Bytes();
        }
        return new String(this.buf, 0, this.count).getBytes(charset);
    }

    private int encodeToUTF8(OutputStream outputStream) {
        int n = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n) {
            byArray = new byte[n];
        }
        int n2 = IOUtils.edu(this.buf, 0, this.count, byArray);
        outputStream.write(byArray, 0, n2);
        if (byArray != byArray2 && n <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return n2;
    }

    private byte[] encodeToUTF8Bytes() {
        int n = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n) {
            byArray = new byte[n];
        }
        int n2 = IOUtils.edu(this.buf, 0, this.count, byArray);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        if (byArray != byArray2 && n <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return byArray3;
    }

    public final int size() {
        return this.count;
    }

    public final String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public final void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= BUFFER_THRESHOLD) {
            bufLocal.set(this.buf);
        }
        this.buf = null;
    }

    @Override
    public final void write(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.write(string, 0, string.length());
    }

    public final void writeInt(int n) {
        if (n == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                char[] cArray = new char[n2];
                IOUtils.getChars(n, n2, cArray);
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        IOUtils.getChars(n, n3, this.buf);
        this.count = n3;
    }

    public final void writeByteArray(byte[] byArray) {
        int n;
        if (this.isEnabled(SerializerFeature.WriteClassName.mask)) {
            this.writeHex(byArray);
            return;
        }
        int n2 = byArray.length;
        int n3 = n = this.useSingleQuotes ? 39 : 34;
        if (n2 == 0) {
            String string = this.useSingleQuotes ? "''" : "\"\"";
            this.write(string);
            return;
        }
        char[] cArray = IOUtils.CA;
        int n4 = n2 / 3 * 3;
        int n5 = (n2 - 1) / 3 + 1 << 2;
        int n6 = this.count;
        if ((n5 = this.count + n5 + 2) > this.buf.length) {
            if (this.writer != null) {
                this.write(n);
                int n7 = 0;
                while (n7 < n4) {
                    n6 = (byArray[n7++] & 0xFF) << 16 | (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
                    this.write(cArray[n6 >>> 18 & 0x3F]);
                    this.write(cArray[n6 >>> 12 & 0x3F]);
                    this.write(cArray[n6 >>> 6 & 0x3F]);
                    this.write(cArray[n6 & 0x3F]);
                }
                n7 = n2 - n4;
                if (n7 > 0) {
                    n6 = (byArray[n4] & 0xFF) << 10 | (n7 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
                    this.write(cArray[n6 >> 12]);
                    this.write(cArray[n6 >>> 6 & 0x3F]);
                    this.write(n7 == 2 ? cArray[n6 & 0x3F] : 61);
                    this.write(61);
                }
                this.write(n);
                return;
            }
            this.expandCapacity(n5);
        }
        this.count = n5;
        this.buf[n6++] = n;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
            this.buf[n6++] = cArray[n9 >>> 18 & 0x3F];
            this.buf[n6++] = cArray[n9 >>> 12 & 0x3F];
            this.buf[n6++] = cArray[n9 >>> 6 & 0x3F];
            this.buf[n6++] = cArray[n9 & 0x3F];
        }
        n8 = n2 - n4;
        if (n8 > 0) {
            n6 = (byArray[n4] & 0xFF) << 10 | (n8 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
            this.buf[n5 - 5] = cArray[n6 >> 12];
            this.buf[n5 - 4] = cArray[n6 >>> 6 & 0x3F];
            this.buf[n5 - 3] = n8 == 2 ? cArray[n6 & 0x3F] : 61;
            this.buf[n5 - 2] = 61;
        }
        this.buf[n5 - 1] = n;
    }

    public final void writeHex(byte[] byArray) {
        int n = this.count + byArray.length * 2 + 3;
        if (n > this.buf.length) {
            this.expandCapacity(n);
        }
        this.buf[this.count++] = 120;
        this.buf[this.count++] = 39;
        for (n = 0; n < byArray.length; ++n) {
            int n2 = byArray[n] & 0xFF;
            int n3 = n2 >> 4;
            int n4 = n3;
            this.buf[this.count++] = (char)(n4 + (n4 < 10 ? 48 : 55));
            int n5 = n2 &= 0xF;
            this.buf[this.count++] = (char)(n5 + (n5 < 10 ? 48 : 55));
        }
        this.buf[this.count++] = 39;
    }

    public final void writeFloat(float f, boolean bl) {
        float f2 = f;
        if (f2 != f2 || f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            this.writeNull();
            return;
        }
        int n = this.count + 15;
        if (n > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n);
            } else {
                String string = RyuFloat.toString(f);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(70);
                }
                return;
            }
        }
        int n2 = RyuFloat.toString(f, this.buf, this.count);
        this.count += n2;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(70);
        }
    }

    public final void writeDouble(double d, boolean bl) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.writeNull();
            return;
        }
        int n = this.count + 24;
        if (n > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n);
            } else {
                String string = RyuDouble.toString(d);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(68);
                }
                return;
            }
        }
        int n2 = RyuDouble.toString(d, this.buf, this.count);
        this.count += n2;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(68);
        }
    }

    public final void writeEnum(Enum<?> enum_) {
        if (enum_ == null) {
            this.writeNull();
            return;
        }
        String string = null;
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            string = enum_.name();
        } else if (this.writeEnumUsingToString) {
            string = enum_.toString();
        }
        if (string != null) {
            int n = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            this.write(n);
            this.write(string);
            this.write(n);
            return;
        }
        this.writeInt(enum_.ordinal());
    }

    public final void writeLongAndChar(long l, char c) {
        this.writeLong(l);
        this.write(c);
    }

    public final void writeLong(long l) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled(SerializerFeature.BrowserCompatible) && !this.isEnabled(SerializerFeature.WriteClassName) && (l > 0x1FFFFFFFFFFFFFL || l < -9007199254740991L);
        if (l == Long.MIN_VALUE) {
            if (bl) {
                this.write("\"-9223372036854775808\"");
                return;
            }
            this.write("-9223372036854775808");
            return;
        }
        int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
        int n2 = this.count + n;
        if (bl) {
            n2 += 2;
        }
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                char[] cArray = new char[n];
                IOUtils.getChars(l, n, cArray);
                if (bl) {
                    this.write(34);
                    this.write(cArray, 0, cArray.length);
                    this.write(34);
                    return;
                }
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        if (bl) {
            this.buf[this.count] = 34;
            IOUtils.getChars(l, n2 - 1, this.buf);
            this.buf[n2 - 1] = 34;
        } else {
            IOUtils.getChars(l, n2, this.buf);
        }
        this.count = n2;
    }

    public final void writeNull() {
        this.write("null");
    }

    public final void writeNull(SerializerFeature serializerFeature) {
        this.writeNull(0, serializerFeature.mask);
    }

    public final void writeNull(int n, int n2) {
        if ((n & n2) == 0 && (this.features & n2) == 0) {
            this.writeNull();
            return;
        }
        if ((n & SerializerFeature.WriteMapNullValue.mask) != 0 && (n & ~SerializerFeature.WriteMapNullValue.mask & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) {
            this.writeNull();
            return;
        }
        if (n2 == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
            return;
        }
        if (n2 == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
            return;
        }
        if (n2 == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
            return;
        }
        if (n2 == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
            return;
        }
        this.writeNull();
    }

    public final void writeStringWithDoubleQuote(String string, char c) {
        int n;
        int n2;
        if (string == null) {
            this.writeNull();
            if (c != '\u0000') {
                this.write(c);
            }
            return;
        }
        int n3 = string.length();
        int n4 = this.count + n3 + 2;
        if (c != '\u0000') {
            ++n4;
        }
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i = 0; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c2 == '(' || c2 == ')' || c2 == '<' || c2 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c2 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c2 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c2 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c2 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c2 == '\b' || c2 == '\f' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\"' || c2 == '/' || c2 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c2]);
                            continue;
                        }
                        if (c2 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c2 * 2]);
                            this.write(IOUtils.ASCII_CHARS[c2 * 2 + 1]);
                            continue;
                        }
                        if (c2 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c2 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 & 0xF]);
                            continue;
                        }
                    } else if (c2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c2] != 0 || c2 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c2] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c2 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c2 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c2]);
                        continue;
                    }
                    this.write(c2);
                }
                this.write(34);
                if (c != '\u0000') {
                    this.write(c);
                }
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        int n6 = n5 + n3;
        this.buf[this.count] = 34;
        string.getChars(0, n3, this.buf, n5);
        this.count = n4;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c3;
            int n7;
            n3 = -1;
            for (n7 = n5; n7 < n6; ++n7) {
                c3 = this.buf[n7];
                if (c3 == '\"' || c3 == '/' || c3 == '\\') {
                    n3 = n7;
                    ++n4;
                    continue;
                }
                if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t') {
                    n3 = n7;
                    ++n4;
                    continue;
                }
                if (c3 < ' ') {
                    n3 = n7;
                    n4 += 5;
                    continue;
                }
                if (c3 < '\u007f') continue;
                n3 = n7;
                n4 += 5;
            }
            if (n4 > this.buf.length) {
                this.expandCapacity(n4);
            }
            this.count = n4;
            for (n7 = n3; n7 >= n5; --n7) {
                c3 = this.buf[n7];
                if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t') {
                    System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 2, n6 - n7 - 1);
                    this.buf[n7] = 92;
                    this.buf[n7 + 1] = IOUtils.replaceChars[c3];
                    ++n6;
                    continue;
                }
                if (c3 == '\"' || c3 == '/' || c3 == '\\') {
                    System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 2, n6 - n7 - 1);
                    this.buf[n7] = 92;
                    this.buf[n7 + 1] = c3;
                    ++n6;
                    continue;
                }
                if (c3 < ' ') {
                    System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 6, n6 - n7 - 1);
                    this.buf[n7] = 92;
                    this.buf[n7 + 1] = 117;
                    this.buf[n7 + 2] = 48;
                    this.buf[n7 + 3] = 48;
                    this.buf[n7 + 4] = IOUtils.ASCII_CHARS[c3 * 2];
                    this.buf[n7 + 5] = IOUtils.ASCII_CHARS[c3 * 2 + 1];
                    n6 += 5;
                    continue;
                }
                if (c3 < '\u007f') continue;
                System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 6, n6 - n7 - 1);
                this.buf[n7] = 92;
                this.buf[n7 + 1] = 117;
                this.buf[n7 + 2] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                this.buf[n7 + 3] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                this.buf[n7 + 4] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                this.buf[n7 + 5] = IOUtils.DIGITS[c3 & 0xF];
                n6 += 5;
            }
            if (c != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c;
                return;
            }
            this.buf[this.count - 1] = 34;
            return;
        }
        n3 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = 0;
        for (n2 = n5; n2 < n6; ++n2) {
            n = this.buf[n2];
            if (n >= 93) {
                if (n < 127 || n != 8232 && n != 8233 && n >= 160) continue;
                if (n9 == -1) {
                    n9 = n2;
                }
                ++n3;
                n8 = n2;
                n10 = n;
                n4 += 4;
                continue;
            }
            if (!(n < 64 && (this.sepcialBits & 1L << n) != 0L || n == 92)) continue;
            ++n3;
            n8 = n2;
            n10 = n;
            if (n == 40 || n == 41 || n == 60 || n == 62 || n < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n] == 4) {
                n4 += 4;
            }
            if (n9 != -1) continue;
            n9 = n2;
        }
        if (n3 > 0) {
            if ((n4 += n3) > this.buf.length) {
                this.expandCapacity(n4);
            }
            this.count = n4;
            if (n3 == 1) {
                if (n10 == 8232) {
                    n2 = n8 + 1;
                    n = n8 + 6;
                    n4 = n6 - n8 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n8] = 92;
                    this.buf[++n8] = 117;
                    this.buf[++n8] = 50;
                    this.buf[++n8] = 48;
                    this.buf[++n8] = 50;
                    this.buf[++n8] = 56;
                } else if (n10 == 8233) {
                    n2 = n8 + 1;
                    n = n8 + 6;
                    n4 = n6 - n8 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n8] = 92;
                    this.buf[++n8] = 117;
                    this.buf[++n8] = 50;
                    this.buf[++n8] = 48;
                    this.buf[++n8] = 50;
                    this.buf[++n8] = 57;
                } else if (n10 == 40 || n10 == 41 || n10 == 60 || n10 == 62) {
                    n2 = n8 + 1;
                    n = n8 + 6;
                    n4 = n6 - n8 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n8] = 92;
                    this.buf[++n8] = 117;
                    n3 = n10;
                    this.buf[++n8] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                    this.buf[++n8] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                    this.buf[++n8] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                    this.buf[++n8] = IOUtils.DIGITS[n3 & 0xF];
                } else {
                    n2 = n10;
                    if (n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                        n = n8 + 1;
                        n4 = n8 + 6;
                        n3 = n6 - n8 - 1;
                        System.arraycopy(this.buf, n, this.buf, n4, n3);
                        int n11 = n8;
                        this.buf[n11++] = 92;
                        this.buf[n11++] = 117;
                        this.buf[n11++] = IOUtils.DIGITS[n2 >>> 12 & 0xF];
                        this.buf[n11++] = IOUtils.DIGITS[n2 >>> 8 & 0xF];
                        this.buf[n11++] = IOUtils.DIGITS[n2 >>> 4 & 0xF];
                        this.buf[n11] = IOUtils.DIGITS[n2 & 0xF];
                    } else {
                        n = n8 + 1;
                        n4 = n8 + 2;
                        n3 = n6 - n8 - 1;
                        System.arraycopy(this.buf, n, this.buf, n4, n3);
                        this.buf[n8] = 92;
                        this.buf[++n8] = IOUtils.replaceChars[n2];
                    }
                }
            } else if (n3 > 1) {
                n2 = n9 - n5;
                n = n9;
                for (n4 = n2; n4 < string.length(); ++n4) {
                    n3 = string.charAt(n4);
                    if (this.browserSecure && (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62)) {
                        this.buf[n++] = 92;
                        this.buf[n++] = 117;
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                        continue;
                    }
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] != 0 || n3 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                            this.buf[n++] = 117;
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                            continue;
                        }
                        this.buf[n++] = IOUtils.replaceChars[n3];
                        continue;
                    }
                    if (n3 == 8232 || n3 == 8233) {
                        this.buf[n++] = 92;
                        this.buf[n++] = 117;
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                        continue;
                    }
                    this.buf[n++] = n3;
                }
            }
        }
        if (c != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c;
            return;
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeStringWithDoubleQuote(char[] cArray, char c) {
        int n;
        int n2;
        if (cArray == null) {
            this.writeNull();
            if (c != '\u0000') {
                this.write(c);
            }
            return;
        }
        int n3 = cArray.length;
        int n4 = this.count + n3 + 2;
        if (c != '\u0000') {
            ++n4;
        }
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i = 0; i < cArray.length; ++i) {
                    n3 = cArray[i];
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62)) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[n3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[n3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[n3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[n3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (n3 == 8 || n3 == 12 || n3 == 10 || n3 == 13 || n3 == 9 || n3 == 34 || n3 == 47 || n3 == 92) {
                            this.write(92);
                            this.write(IOUtils.replaceChars[n3]);
                            continue;
                        }
                        if (n3 < 32) {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[n3 * 2]);
                            this.write(IOUtils.ASCII_CHARS[n3 * 2 + 1]);
                            continue;
                        }
                        if (n3 >= 127) {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[n3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 & 0xF]);
                            continue;
                        }
                    } else if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] != 0 || n3 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[n3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[n3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[n3]);
                        continue;
                    }
                    this.write(n3);
                }
                this.write(34);
                if (c != '\u0000') {
                    this.write(c);
                }
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        n3 = n5 + n3;
        this.buf[this.count] = 34;
        System.arraycopy(cArray, 0, this.buf, n5, cArray.length);
        this.count = n4;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c2;
            int n6;
            int n7 = -1;
            for (n6 = n5; n6 < n3; ++n6) {
                c2 = this.buf[n6];
                if (c2 == '\"' || c2 == '/' || c2 == '\\') {
                    n7 = n6;
                    ++n4;
                    continue;
                }
                if (c2 == '\b' || c2 == '\f' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                    n7 = n6;
                    ++n4;
                    continue;
                }
                if (c2 < ' ') {
                    n7 = n6;
                    n4 += 5;
                    continue;
                }
                if (c2 < '\u007f') continue;
                n7 = n6;
                n4 += 5;
            }
            if (n4 > this.buf.length) {
                this.expandCapacity(n4);
            }
            this.count = n4;
            for (n6 = n7; n6 >= n5; --n6) {
                c2 = this.buf[n6];
                if (c2 == '\b' || c2 == '\f' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                    System.arraycopy(this.buf, n6 + 1, this.buf, n6 + 2, n3 - n6 - 1);
                    this.buf[n6] = 92;
                    this.buf[n6 + 1] = IOUtils.replaceChars[c2];
                    ++n3;
                    continue;
                }
                if (c2 == '\"' || c2 == '/' || c2 == '\\') {
                    System.arraycopy(this.buf, n6 + 1, this.buf, n6 + 2, n3 - n6 - 1);
                    this.buf[n6] = 92;
                    this.buf[n6 + 1] = c2;
                    ++n3;
                    continue;
                }
                if (c2 < ' ') {
                    System.arraycopy(this.buf, n6 + 1, this.buf, n6 + 6, n3 - n6 - 1);
                    this.buf[n6] = 92;
                    this.buf[n6 + 1] = 117;
                    this.buf[n6 + 2] = 48;
                    this.buf[n6 + 3] = 48;
                    this.buf[n6 + 4] = IOUtils.ASCII_CHARS[c2 * 2];
                    this.buf[n6 + 5] = IOUtils.ASCII_CHARS[c2 * 2 + 1];
                    n3 += 5;
                    continue;
                }
                if (c2 < '\u007f') continue;
                System.arraycopy(this.buf, n6 + 1, this.buf, n6 + 6, n3 - n6 - 1);
                this.buf[n6] = 92;
                this.buf[n6 + 1] = 117;
                this.buf[n6 + 2] = IOUtils.DIGITS[c2 >>> 12 & 0xF];
                this.buf[n6 + 3] = IOUtils.DIGITS[c2 >>> 8 & 0xF];
                this.buf[n6 + 4] = IOUtils.DIGITS[c2 >>> 4 & 0xF];
                this.buf[n6 + 5] = IOUtils.DIGITS[c2 & 0xF];
                n3 += 5;
            }
            if (c != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c;
                return;
            }
            this.buf[this.count - 1] = 34;
            return;
        }
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        for (n2 = n5; n2 < n3; ++n2) {
            n = this.buf[n2];
            if (n >= 93) {
                if (n < 127 || n != 8232 && n != 8233 && n >= 160) continue;
                if (n10 == -1) {
                    n10 = n2;
                }
                ++n8;
                n9 = n2;
                n11 = n;
                n4 += 4;
                continue;
            }
            if (!(n < 64 && (this.sepcialBits & 1L << n) != 0L || n == 92)) continue;
            ++n8;
            n9 = n2;
            n11 = n;
            if (n == 40 || n == 41 || n == 60 || n == 62 || n < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n] == 4) {
                n4 += 4;
            }
            if (n10 != -1) continue;
            n10 = n2;
        }
        if (n8 > 0) {
            if ((n4 += n8) > this.buf.length) {
                this.expandCapacity(n4);
            }
            this.count = n4;
            if (n8 == 1) {
                if (n11 == 8232) {
                    n2 = n9 + 1;
                    n = n9 + 6;
                    n4 = n3 - n9 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n9] = 92;
                    this.buf[++n9] = 117;
                    this.buf[++n9] = 50;
                    this.buf[++n9] = 48;
                    this.buf[++n9] = 50;
                    this.buf[++n9] = 56;
                } else if (n11 == 8233) {
                    n2 = n9 + 1;
                    n = n9 + 6;
                    n4 = n3 - n9 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n9] = 92;
                    this.buf[++n9] = 117;
                    this.buf[++n9] = 50;
                    this.buf[++n9] = 48;
                    this.buf[++n9] = 50;
                    this.buf[++n9] = 57;
                } else if (n11 == 40 || n11 == 41 || n11 == 60 || n11 == 62) {
                    n2 = n9 + 1;
                    n = n9 + 6;
                    n4 = n3 - n9 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n4);
                    this.buf[n9] = 92;
                    this.buf[++n9] = 117;
                    n3 = n11;
                    this.buf[++n9] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                    this.buf[++n9] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                    this.buf[++n9] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                    this.buf[++n9] = IOUtils.DIGITS[n3 & 0xF];
                } else {
                    n2 = n11;
                    if (n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                        n = n9 + 1;
                        n4 = n9 + 6;
                        n3 = n3 - n9 - 1;
                        System.arraycopy(this.buf, n, this.buf, n4, n3);
                        int n12 = n9;
                        this.buf[n12++] = 92;
                        this.buf[n12++] = 117;
                        this.buf[n12++] = IOUtils.DIGITS[n2 >>> 12 & 0xF];
                        this.buf[n12++] = IOUtils.DIGITS[n2 >>> 8 & 0xF];
                        this.buf[n12++] = IOUtils.DIGITS[n2 >>> 4 & 0xF];
                        this.buf[n12] = IOUtils.DIGITS[n2 & 0xF];
                    } else {
                        n = n9 + 1;
                        n4 = n9 + 2;
                        n3 = n3 - n9 - 1;
                        System.arraycopy(this.buf, n, this.buf, n4, n3);
                        this.buf[n9] = 92;
                        this.buf[++n9] = IOUtils.replaceChars[n2];
                    }
                }
            } else if (n8 > 1) {
                n2 = n10 - n5;
                n = n10;
                for (n4 = n2; n4 < cArray.length; ++n4) {
                    n3 = cArray[n4];
                    if (this.browserSecure && (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62)) {
                        this.buf[n++] = 92;
                        this.buf[n++] = 117;
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                        continue;
                    }
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] != 0 || n3 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                            this.buf[n++] = 117;
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                            this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                            continue;
                        }
                        this.buf[n++] = IOUtils.replaceChars[n3];
                        continue;
                    }
                    if (n3 == 8232 || n3 == 8233) {
                        this.buf[n++] = 92;
                        this.buf[n++] = 117;
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 & 0xF];
                        continue;
                    }
                    this.buf[n++] = n3;
                }
            }
        }
        if (c != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c;
            return;
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldNameDirect(String string) {
        int n = string.length();
        int n2 = this.count + n + 3;
        if (n2 > this.buf.length) {
            this.expandCapacity(n2);
        }
        int n3 = this.count + 1;
        this.buf[this.count] = 34;
        string.getChars(0, n, this.buf, n3);
        this.count = n2;
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public final void write(List<String> list) {
        int n;
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int n2 = n = this.count;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string = list.get(i);
            char c = '\u0000';
            if (string == null) {
                c = '\u0001';
            } else {
                int n5 = string.length();
                for (n4 = 0; n4 < n5 && (c = (c = string.charAt(n4)) < ' ' || c > '~' || c == '\"' || c == '\\' ? (char)'\u0001' : '\u0000') == '\u0000'; ++n4) {
                }
            }
            if (c != '\u0000') {
                this.count = n2;
                this.write(91);
                for (n4 = 0; n4 < list.size(); ++n4) {
                    string = list.get(n4);
                    if (n4 != 0) {
                        this.write(44);
                    }
                    if (string == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(string, '\u0000');
                }
                this.write(93);
                return;
            }
            n4 = n + string.length() + 3;
            if (i == list.size() - 1) {
                ++n4;
            }
            if (n4 > this.buf.length) {
                this.count = n;
                this.expandCapacity(n4);
            }
            this.buf[n++] = i == 0 ? 91 : 44;
            this.buf[n++] = 34;
            string.getChars(0, string.length(), this.buf, n);
            n += string.length();
            this.buf[n++] = 34;
        }
        this.buf[n++] = 93;
        this.count = n;
    }

    public final void writeFieldValue(char c, String string, char c2) {
        this.write(c);
        this.writeFieldName(string);
        if (c2 == '\u0000') {
            this.writeString("\u0000");
            return;
        }
        this.writeString(Character.toString(c2));
    }

    public final void writeFieldValue(char c, String string, boolean bl) {
        if (!this.quoteFieldNames) {
            this.write(c);
            this.writeFieldName(string);
            this.write(bl);
            return;
        }
        int n = bl ? 4 : 5;
        int n2 = string.length();
        n = this.count + n2 + 4 + n;
        if (n > this.buf.length) {
            if (this.writer != null) {
                this.write(c);
                this.writeString(string);
                this.write(58);
                this.write(bl);
                return;
            }
            this.expandCapacity(n);
        }
        int n3 = this.count;
        this.count = n;
        this.buf[n3] = c;
        c = (char)(n3 + n2 + 1);
        this.buf[n3 + 1] = this.keySeperator;
        string.getChars(0, n2, this.buf, n3 + 2);
        this.buf[c + '\u0001'] = this.keySeperator;
        if (bl) {
            System.arraycopy(VALUE_TRUE, 0, this.buf, c + 2, 5);
            return;
        }
        System.arraycopy(VALUE_FALSE, 0, this.buf, c + 2, 6);
    }

    public final void write(boolean bl) {
        if (bl) {
            this.write("true");
            return;
        }
        this.write("false");
    }

    public final void writeFieldValue(char c, String string, int n) {
        if (n == Integer.MIN_VALUE || !this.quoteFieldNames) {
            this.write(c);
            this.writeFieldName(string);
            this.writeInt(n);
            return;
        }
        int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
        int n3 = string.length();
        n2 = this.count + n3 + 4 + n2;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                this.write(c);
                this.writeFieldName(string);
                this.writeInt(n);
                return;
            }
            this.expandCapacity(n2);
        }
        int n4 = this.count;
        this.count = n2;
        this.buf[n4] = c;
        c = (char)(n4 + n3 + 1);
        this.buf[n4 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n4 + 2);
        this.buf[c + '\u0001'] = this.keySeperator;
        this.buf[c + 2] = 58;
        IOUtils.getChars(n, this.count, this.buf);
    }

    public final void writeFieldValue(char c, String string, long l) {
        if (l == Long.MIN_VALUE || !this.quoteFieldNames || this.isEnabled(SerializerFeature.BrowserCompatible.mask)) {
            this.write(c);
            this.writeFieldName(string);
            this.writeLong(l);
            return;
        }
        int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
        int n2 = string.length();
        n = this.count + n2 + 4 + n;
        if (n > this.buf.length) {
            if (this.writer != null) {
                this.write(c);
                this.writeFieldName(string);
                this.writeLong(l);
                return;
            }
            this.expandCapacity(n);
        }
        int n3 = this.count;
        this.count = n;
        this.buf[n3] = c;
        c = (char)(n3 + n2 + 1);
        this.buf[n3 + 1] = this.keySeperator;
        string.getChars(0, n2, this.buf, n3 + 2);
        this.buf[c + '\u0001'] = this.keySeperator;
        this.buf[c + 2] = 58;
        IOUtils.getChars(l, this.count, this.buf);
    }

    public final void writeFieldValue(char c, String string, float f) {
        this.write(c);
        this.writeFieldName(string);
        this.writeFloat(f, false);
    }

    public final void writeFieldValue(char c, String string, double d) {
        this.write(c);
        this.writeFieldName(string);
        this.writeDouble(d, false);
    }

    public final void writeFieldValue(char c, String string, String string2) {
        if (this.quoteFieldNames) {
            if (this.useSingleQuotes) {
                this.write(c);
                this.writeFieldName(string);
                if (string2 == null) {
                    this.writeNull();
                    return;
                }
                this.writeString(string2);
                return;
            }
            if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(c);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.writeFieldValueStringWithDoubleQuoteCheck(c, string, string2);
            return;
        }
        this.write(c);
        this.writeFieldName(string);
        if (string2 == null) {
            this.writeNull();
            return;
        }
        this.writeString(string2);
    }

    public final void writeFieldValueStringWithDoubleQuoteCheck(char n, String string, String string2) {
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        int n6 = this.count;
        if (string2 == null) {
            n4 = 4;
            n6 += n5 + 8;
        } else {
            n4 = string2.length();
            n6 += n5 + n4 + 6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(n);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n6);
        }
        this.buf[this.count] = n;
        int n7 = this.count + 2;
        n = n7;
        int n8 = n7 + n5;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n5, this.buf, n);
        this.count = n6;
        this.buf[n8] = 34;
        int n9 = n = (int)(n8 + 1);
        n = n + 1;
        this.buf[n9] = 58;
        if (string2 == null) {
            int n10 = n;
            n = n + 1;
            this.buf[n10] = 110;
            int n11 = n;
            n = n + 1;
            this.buf[n11] = 117;
            int n12 = n;
            n = n + 1;
            this.buf[n12] = 108;
            this.buf[n] = 108;
            return;
        }
        int n13 = n;
        n = n + 1;
        this.buf[n13] = 34;
        int n14 = n + n4;
        string2.getChars(0, n4, this.buf, n);
        n5 = 0;
        n4 = -1;
        n8 = -1;
        int n15 = 0;
        for (n3 = n; n3 < n14; ++n3) {
            n2 = this.buf[n3];
            if (n2 >= 93) {
                if (n2 < 127 || n2 != 8232 && n2 != 8233 && n2 >= 160) continue;
                if (n8 == -1) {
                    n8 = n3;
                }
                ++n5;
                n4 = n3;
                n15 = n2;
                n6 += 4;
                continue;
            }
            if (!(n2 < 64 && (this.sepcialBits & 1L << n2) != 0L || n2 == 92)) continue;
            ++n5;
            n4 = n3;
            n15 = n2;
            if (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                n6 += 4;
            }
            if (n8 != -1) continue;
            n8 = n3;
        }
        if (n5 > 0) {
            if ((n6 += n5) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n5 == 1) {
                if (n15 == 8232) {
                    n3 = n4 + 1;
                    n2 = n4 + 6;
                    n5 = n14 - n4 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n5);
                    this.buf[n4] = 92;
                    this.buf[++n4] = 117;
                    this.buf[++n4] = 50;
                    this.buf[++n4] = 48;
                    this.buf[++n4] = 50;
                    this.buf[++n4] = 56;
                } else if (n15 == 8233) {
                    n3 = n4 + 1;
                    n2 = n4 + 6;
                    n5 = n14 - n4 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n5);
                    this.buf[n4] = 92;
                    this.buf[++n4] = 117;
                    this.buf[++n4] = 50;
                    this.buf[++n4] = 48;
                    this.buf[++n4] = 50;
                    this.buf[++n4] = 57;
                } else if (n15 == 40 || n15 == 41 || n15 == 60 || n15 == 62) {
                    n3 = n15;
                    n2 = n4 + 1;
                    n5 = n4 + 6;
                    n = n14 - n4 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n5, n);
                    n = n4;
                    this.buf[n++] = 92;
                    this.buf[n++] = 117;
                    this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                    this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                    this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                    this.buf[n] = IOUtils.DIGITS[n3 & 0xF];
                } else {
                    n3 = n15;
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                        n2 = n4 + 1;
                        n5 = n4 + 6;
                        n = n14 - n4 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n5, n);
                        n = n4;
                        this.buf[n++] = 92;
                        this.buf[n++] = 117;
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n] = IOUtils.DIGITS[n3 & 0xF];
                    } else {
                        n2 = n4 + 1;
                        n5 = n4 + 2;
                        n = n14 - n4 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n5, n);
                        this.buf[n4] = 92;
                        this.buf[++n4] = IOUtils.replaceChars[n3];
                    }
                }
            } else if (n5 > 1) {
                n3 = n8 - n;
                n2 = n8;
                for (n5 = n3; n5 < string2.length(); ++n5) {
                    n = string2.charAt(n5);
                    if (this.browserSecure && (n == 40 || n == 41 || n == 60 || n == 62)) {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n & 0xF];
                        continue;
                    }
                    if (n < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n] != 0 || n == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n2++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n] == 4) {
                            this.buf[n2++] = 117;
                            this.buf[n2++] = IOUtils.DIGITS[n >>> 12 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[n >>> 8 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[n >>> 4 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[n & 0xF];
                            continue;
                        }
                        this.buf[n2++] = IOUtils.replaceChars[n];
                        continue;
                    }
                    if (n == 8232 || n == 8233) {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n & 0xF];
                        continue;
                    }
                    this.buf[n2++] = n;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldValueStringWithDoubleQuote(char c, String string, String string2) {
        int n = string.length();
        int n2 = this.count;
        int n3 = string2.length();
        if ((n2 += n + n3 + 6) > this.buf.length) {
            if (this.writer != null) {
                this.write(c);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n2);
        }
        this.buf[this.count] = c;
        int n4 = this.count + 2;
        c = (char)n4;
        int n5 = n4 + n;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n, this.buf, c);
        this.count = n2;
        this.buf[n5] = 34;
        char c2 = c = (char)(n5 + 1);
        c = (char)(c + 1);
        this.buf[c2] = 58;
        char c3 = c;
        c = (char)(c + 1);
        this.buf[c3] = 34;
        string2.getChars(0, n3, this.buf, c);
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldValue(char c, String string, Enum<?> enum_) {
        if (enum_ == null) {
            this.write(c);
            this.writeFieldName(string);
            this.writeNull();
            return;
        }
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c, string, enum_.name());
            return;
        }
        if (this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c, string, enum_.toString());
            return;
        }
        this.writeFieldValue(c, string, enum_.ordinal());
    }

    private void writeEnumFieldValue(char c, String string, String string2) {
        if (this.useSingleQuotes) {
            this.writeFieldValue(c, string, string2);
            return;
        }
        this.writeFieldValueStringWithDoubleQuote(c, string, string2);
    }

    public final void writeFieldValue(char c, String string, BigDecimal bigDecimal) {
        this.write(c);
        this.writeFieldName(string);
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        c = (char)bigDecimal.scale();
        SerializeWriter serializeWriter = this;
        serializeWriter.write(serializeWriter.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) && c >= '\uffffff9c' && c < 'd' ? bigDecimal.toPlainString() : bigDecimal.toString());
    }

    public final void writeString(String string, char c) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            this.write(c);
            return;
        }
        this.writeStringWithDoubleQuote(string, c);
    }

    public final void writeString(String string) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            return;
        }
        this.writeStringWithDoubleQuote(string, '\u0000');
    }

    public final void writeString(char[] object) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote((char[])object);
            return;
        }
        object = new String((char[])object);
        this.writeStringWithDoubleQuote((String)object, '\u0000');
    }

    protected final void writeStringWithSingleQuote(String string) {
        char c;
        int n;
        if (string == null) {
            int n2 = this.count + 4;
            if (n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n2;
            return;
        }
        int n3 = string.length();
        int n4 = this.count + n3 + 2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i = 0; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    if (c2 <= '\r' || c2 == '\\' || c2 == '\'' || c2 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c2]);
                        continue;
                    }
                    this.write(c2);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        int n6 = n5 + n3;
        this.buf[this.count] = 39;
        string.getChars(0, n3, this.buf, n5);
        this.count = n4;
        int n7 = 0;
        n3 = -1;
        char c3 = '\u0000';
        for (n = n5; n < n6; ++n) {
            c = this.buf[n];
            if (c > '\r' && c != '\\' && c != '\'' && (c != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n7;
            n3 = n;
            c3 = c;
        }
        if ((n4 += n7) > this.buf.length) {
            this.expandCapacity(n4);
        }
        this.count = n4;
        if (n7 == 1) {
            System.arraycopy(this.buf, n3 + 1, this.buf, n3 + 2, n6 - n3 - 1);
            this.buf[n3] = 92;
            this.buf[++n3] = IOUtils.replaceChars[c3];
        } else if (n7 > 1) {
            System.arraycopy(this.buf, n3 + 1, this.buf, n3 + 2, n6 - n3 - 1);
            this.buf[n3] = 92;
            this.buf[++n3] = IOUtils.replaceChars[c3];
            ++n6;
            for (n = n3 - 2; n >= n5; --n) {
                c = this.buf[n];
                if (c > '\r' && c != '\\' && c != '\'' && (c != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n + 1, this.buf, n + 2, n6 - n - 1);
                this.buf[n] = 92;
                this.buf[n + 1] = IOUtils.replaceChars[c];
                ++n6;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    protected final void writeStringWithSingleQuote(char[] cArray) {
        char c;
        int n;
        if (cArray == null) {
            int n2 = this.count + 4;
            if (n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n2;
            return;
        }
        int n3 = cArray.length;
        int n4 = this.count + n3 + 2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i = 0; i < cArray.length; ++i) {
                    n3 = cArray[i];
                    if (n3 <= 13 || n3 == 92 || n3 == 39 || n3 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[n3]);
                        continue;
                    }
                    this.write(n3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        n3 = n5 + n3;
        this.buf[this.count] = 39;
        System.arraycopy(cArray, 0, this.buf, n5, cArray.length);
        this.count = n4;
        int n6 = 0;
        int n7 = -1;
        char c2 = '\u0000';
        for (n = n5; n < n3; ++n) {
            c = this.buf[n];
            if (c > '\r' && c != '\\' && c != '\'' && (c != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n6;
            n7 = n;
            c2 = c;
        }
        if ((n4 += n6) > this.buf.length) {
            this.expandCapacity(n4);
        }
        this.count = n4;
        if (n6 == 1) {
            System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 2, n3 - n7 - 1);
            this.buf[n7] = 92;
            this.buf[++n7] = IOUtils.replaceChars[c2];
        } else if (n6 > 1) {
            System.arraycopy(this.buf, n7 + 1, this.buf, n7 + 2, n3 - n7 - 1);
            this.buf[n7] = 92;
            this.buf[++n7] = IOUtils.replaceChars[c2];
            ++n3;
            for (n = n7 - 2; n >= n5; --n) {
                c = this.buf[n];
                if (c > '\r' && c != '\\' && c != '\'' && (c != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n + 1, this.buf, n + 2, n3 - n - 1);
                this.buf[n] = 92;
                this.buf[n + 1] = IOUtils.replaceChars[c];
                ++n3;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public final void writeFieldName(String string) {
        this.writeFieldName(string, false);
    }

    public final void writeFieldName(String string, boolean bl) {
        if (string == null) {
            this.write("null:");
            return;
        }
        if (this.useSingleQuotes) {
            if (this.quoteFieldNames) {
                this.writeStringWithSingleQuote(string);
                this.write(58);
                return;
            }
            this.writeKeyWithSingleQuoteIfHasSpecial(string);
            return;
        }
        if (this.quoteFieldNames) {
            this.writeStringWithDoubleQuote(string, ':');
            return;
        }
        bl = string.length() == 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c < '@' && (this.sepcialBits & 1L << c) != 0L || c == '\\')) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.writeStringWithDoubleQuote(string, ':');
            return;
        }
        this.write(string);
        this.write(58);
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String string) {
        byte[] byArray = IOUtils.specicalFlags_singleQuotes;
        int n = string.length();
        int n2 = this.count + n + 1;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                char c;
                int n3;
                if (n == 0) {
                    this.write(39);
                    this.write(39);
                    this.write(58);
                    return;
                }
                boolean bl = false;
                for (n3 = 0; n3 < n; ++n3) {
                    c = string.charAt(n3);
                    if (c >= byArray.length || byArray[c] == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.write(39);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    c = string.charAt(n3);
                    if (c < byArray.length && byArray[c] != 0) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c]);
                        continue;
                    }
                    this.write(c);
                }
                if (bl) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(n2);
        }
        if (n == 0) {
            if (this.count + 3 > this.buf.length) {
                SerializeWriter serializeWriter = this;
                serializeWriter.expandCapacity(serializeWriter.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int n4 = this.count;
        int n5 = n4 + n;
        string.getChars(0, n, this.buf, n4);
        this.count = n2;
        boolean bl = false;
        for (int i = n4; i < n5; ++i) {
            n = this.buf[i];
            if (n >= byArray.length || byArray[n] == 0) continue;
            if (!bl) {
                if ((n2 += 3) > this.buf.length) {
                    this.expandCapacity(n2);
                }
                this.count = n2;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, n5 - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[n4] = 39;
                this.buf[++i] = 92;
                this.buf[++i] = IOUtils.replaceChars[n];
                n5 += 2;
                this.buf[this.count - 2] = 39;
                bl = true;
                continue;
            }
            if (++n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            this.count = n2;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, n5 - i);
            this.buf[i] = 92;
            this.buf[++i] = IOUtils.replaceChars[n];
            ++n5;
        }
        this.buf[n2 - 1] = 58;
    }

    @Override
    public final void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.count = 0;
    }

    public final void reset() {
        this.count = 0;
    }

    static {
        try {
            int n;
            String string = IOUtils.getStringProperty("fastjson.serializer_buffer_threshold");
            if (string != null && string.length() > 0 && (n = Integer.parseInt(string)) >= 64 && n <= 65536) {
                BUFFER_THRESHOLD = n * 1024;
            }
        }
        catch (Throwable throwable) {}
        nonDirectFeatures = 0 | SerializerFeature.UseSingleQuotes.mask | SerializerFeature.BrowserCompatible.mask | SerializerFeature.PrettyFormat.mask | SerializerFeature.WriteEnumUsingToString.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.WriteSlashAsSpecial.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.WriteClassName.mask | SerializerFeature.NotWriteDefaultValue.mask;
    }
}

