/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

public enum SerializerFeature {
    QuoteFieldNames,
    UseSingleQuotes,
    WriteMapNullValue,
    WriteEnumUsingToString,
    WriteEnumUsingName,
    UseISO8601DateFormat,
    WriteNullListAsEmpty,
    WriteNullStringAsEmpty,
    WriteNullNumberAsZero,
    WriteNullBooleanAsFalse,
    SkipTransientField,
    SortField,
    WriteTabAsSpecial,
    PrettyFormat,
    WriteClassName,
    DisableCircularReferenceDetect,
    WriteSlashAsSpecial,
    BrowserCompatible,
    WriteDateUseDateFormat,
    NotWriteRootClassName,
    DisableCheckSpecialChar,
    BeanToArray,
    WriteNonStringKeyAsString,
    NotWriteDefaultValue,
    BrowserSecure,
    IgnoreNonFieldGetter,
    WriteNonStringValueAsString,
    IgnoreErrorGetter,
    WriteBigDecimalAsPlain,
    MapSortField;

    public final int mask = 1 << this.ordinal();
    public static final SerializerFeature[] EMPTY;
    public static final int WRITE_MAP_NULL_FEATURES;

    public final int getMask() {
        return this.mask;
    }

    public static boolean isEnabled(int n, SerializerFeature serializerFeature) {
        return (n & serializerFeature.mask) != 0;
    }

    public static boolean isEnabled(int n, int n2, SerializerFeature serializerFeature) {
        int n3 = serializerFeature.mask;
        return (n & n3) != 0 || (n2 & n3) != 0;
    }

    public static int jsonCfg(int n, SerializerFeature serializerFeature, boolean bl) {
        n = bl ? (n |= serializerFeature.mask) : (n &= ~serializerFeature.mask);
        return n;
    }

    public static int of(SerializerFeature[] serializerFeatureArray) {
        if (serializerFeatureArray == null) {
            return 0;
        }
        int n = 0;
        for (SerializerFeature serializerFeature : serializerFeatureArray) {
            n |= serializerFeature.mask;
        }
        return n;
    }

    static {
        EMPTY = new SerializerFeature[0];
        WRITE_MAP_NULL_FEATURES = WriteMapNullValue.getMask() | WriteNullBooleanAsFalse.getMask() | WriteNullListAsEmpty.getMask() | WriteNullNumberAsZero.getMask() | WriteNullStringAsEmpty.getMask();
    }
}

