/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.PropertyPreFilter;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import java.util.HashSet;
import java.util.Set;

public class SimplePropertyPreFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private int maxLevel = 0;

    public SimplePropertyPreFilter(String ... stringArray) {
        this((Class<?>)null, stringArray);
    }

    public SimplePropertyPreFilter(Class<?> stringArray, String ... stringArray2) {
        this.clazz = stringArray;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this.includes.add(string);
        }
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean apply(JSONSerializer object, Object object2, String string) {
        if (object2 == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(object2)) {
            return true;
        }
        if (this.excludes.contains(string)) {
            return false;
        }
        if (this.maxLevel > 0) {
            int n = 0;
            object = ((JSONSerializer)object).context;
            while (object != null) {
                if (++n > this.maxLevel) {
                    return false;
                }
                object = ((SerialContext)object).parent;
            }
        }
        return this.includes.size() == 0 || this.includes.contains(string);
    }
}

