/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.asm.ClassReader;
import com.tradplus.ads.common.serialization.asm.TypeCollector;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ASMUtils {
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final boolean IS_ANDROID = ASMUtils.isAndroid(JAVA_VM_NAME);

    public static boolean isAndroid(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).contains("dalvik") || string.contains("lemur");
    }

    public static String desc(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder(classArray.length + 1 << 4);
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(ASMUtils.desc(classArray[i]));
        }
        stringBuilder.append(')');
        stringBuilder.append(ASMUtils.desc(method.getReturnType()));
        return stringBuilder.toString();
    }

    public static String desc(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        return "L" + ASMUtils.type(clazz) + ";";
    }

    public static String type(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        if (!clazz.isPrimitive()) {
            return clazz.getName().replace('.', '/');
        }
        return ASMUtils.getPrimitiveLetter(clazz);
    }

    public static String getPrimitiveLetter(Class<?> clazz) {
        if (Integer.TYPE == clazz) {
            return "I";
        }
        if (Void.TYPE == clazz) {
            return "V";
        }
        if (Boolean.TYPE == clazz) {
            return "Z";
        }
        if (Character.TYPE == clazz) {
            return "C";
        }
        if (Byte.TYPE == clazz) {
            return "B";
        }
        if (Short.TYPE == clazz) {
            return "S";
        }
        if (Float.TYPE == clazz) {
            return "F";
        }
        if (Long.TYPE == clazz) {
            return "J";
        }
        if (Double.TYPE == clazz) {
            return "D";
        }
        throw new IllegalStateException("Type: " + clazz.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> clazz, String string) {
        try {
            return clazz.getMethod(string, new Class[0]).getGenericReturnType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c <= '\u007f' && c != '.') continue;
            return false;
        }
        return true;
    }

    public static String[] lookupParameterNames(AccessibleObject object) {
        Annotation[][] annotationArray;
        Object object2;
        String string;
        Object object3;
        if (IS_ANDROID) {
            return new String[0];
        }
        if (object instanceof Method) {
            object3 = (Method)object;
            object = object3.getParameterTypes();
            string = object3.getName();
            object2 = object3.getDeclaringClass();
            annotationArray = TypeUtils.getParameterAnnotations((Method)object3);
        } else {
            object3 = (Constructor)object;
            object = object3.getParameterTypes();
            object2 = object3.getDeclaringClass();
            string = "<init>";
            annotationArray = TypeUtils.getParameterAnnotations((Constructor)object3);
        }
        if (((Class<?>[])object).length == 0) {
            return new String[0];
        }
        object3 = ((Class)object2).getClassLoader();
        if (object3 == null) {
            object3 = ClassLoader.getSystemClassLoader();
        }
        object2 = ((Class)object2).getName();
        object2 = ((String)object2).replace('.', '/') + ".class";
        if ((object2 = object3.getResourceAsStream((String)object2)) == null) {
            return new String[0];
        }
        try {
            object3 = new ClassReader((InputStream)object2, false);
            object = new TypeCollector(string, (Class<?>[])object);
            object3.accept((TypeCollector)object);
            object = ((TypeCollector)object).getParameterNamesForMethod();
            for (int i = 0; i < ((Object)object).length; ++i) {
                object3 = annotationArray[i];
                if (object3 == null) continue;
                for (int j = 0; j < ((Annotation[])object3).length; ++j) {
                    String string2;
                    if (!(object3[j] instanceof JSONField) || (string2 = ((JSONField)object3[j]).name()) == null || string2.length() <= 0) continue;
                    object[i] = string2;
                }
            }
            Object object4 = object;
            return object4;
        }
        catch (IOException iOException) {
            object = new String[]{};
            return object;
        }
        finally {
            IOUtils.close((Closeable)object2);
        }
    }
}

