/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class AntiCollisionHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable,
Map<K, V> {
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final int M_MASK = -2023358765;
    static final int SEED = -2128831035;
    static final int KEY = 16777619;
    final int random = new Random().nextInt(99999);
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    private int hashString(String string) {
        int n = -2128831035 * this.random;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 16777619 ^ string.charAt(i);
        }
        int n2 = n;
        return (n2 ^ n2 >> 1) & 0x8765FED3;
    }

    public AntiCollisionHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: ".concat(String.valueOf(n)));
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: ".concat(String.valueOf(f)));
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public AntiCollisionHashMap(int n) {
        this(n, 0.75f);
    }

    public AntiCollisionHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public AntiCollisionHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(map);
    }

    void init() {
    }

    static int hash(int n) {
        int n2 = n;
        n = n2 * n2;
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        int n = object instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode());
        Entry<K, V> entry = this.table[AntiCollisionHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private V getForNullKey() {
        Entry<K, V> entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    final Entry<K, V> getEntry(Object object) {
        int n = object == null ? 0 : (object instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode()));
        Entry<K, V> entry = this.table[AntiCollisionHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object != null && object.equals(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public V put(K object, V v) {
        if (object == null) {
            return this.putForNullKey(v);
        }
        int n = object instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode());
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry = this.table[n2];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                object = entry.value;
                entry.value = v;
                return (V)object;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, object, v, n2);
        return null;
    }

    private V putForNullKey(V v) {
        Entry<K, V> entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(0, null, v, 0);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = k == null ? 0 : (k instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)k)) : AntiCollisionHashMap.hash(k.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k != null && k.equals(k2))) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k, v, n2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        if (this.table.length == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray = new Entry[n];
        this.transfer(entryArray);
        this.table = entryArray;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry<K, V>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<K, V> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = AntiCollisionHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object entry) {
        if ((entry = this.removeEntryForKey(entry)) == null) {
            return null;
        }
        return entry.value;
    }

    final Entry<K, V> removeEntryForKey(Object object) {
        Entry<K, V> entry;
        int n = object == null ? 0 : (object instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)object)) : AntiCollisionHashMap.hash(object.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Object k;
            Entry entry3 = entry2.next;
            if (entry2.hash == n && ((k = entry2.key) == object || object != null && object.equals(k))) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    final Entry<K, V> removeMapping(Object object) {
        Entry<K, V> entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Object k = (object = (Map.Entry)object).getKey();
        int n = k == null ? 0 : (k instanceof String ? AntiCollisionHashMap.hash(this.hashString((String)k)) : AntiCollisionHashMap.hash(k.hashCode()));
        int n2 = AntiCollisionHashMap.indexFor(n, this.table.length);
        Entry<K, V> entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && entry2.equals(object)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        AntiCollisionHashMap antiCollisionHashMap = null;
        try {
            antiCollisionHashMap = (AntiCollisionHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        antiCollisionHashMap.table = new Entry[this.table.length];
        antiCollisionHashMap.entrySet = null;
        antiCollisionHashMap.modCount = 0;
        antiCollisionHashMap.size = 0;
        antiCollisionHashMap.init();
        antiCollisionHashMap.putAllForCreate(this);
        return antiCollisionHashMap;
    }

    void addEntry(int n, K k, V v, int n2) {
        Entry<K, V> entry = this.table[n2];
        this.table[n2] = new Entry<K, V>(n, k, v, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry<K, V> entry = this.table[n2];
        this.table[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        Iterator<Map.Entry<K, V>> iterator = this.size > 0 ? this.entrySet0().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return AntiCollisionHashMap.this.newEntryIterator();
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Entry entry = AntiCollisionHashMap.this.getEntry((object = (Map.Entry)object).getKey());
            return entry != null && entry.equals(object);
        }

        @Override
        public final boolean remove(Object object) {
            return AntiCollisionHashMap.this.removeMapping(object) != null;
        }

        @Override
        public final int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public final void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public final Iterator<V> iterator() {
            return AntiCollisionHashMap.this.newValueIterator();
        }

        @Override
        public final int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public final boolean contains(Object object) {
            return AntiCollisionHashMap.this.containsValue(object);
        }

        @Override
        public final void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public final Iterator<K> iterator() {
            return AntiCollisionHashMap.this.newKeyIterator();
        }

        @Override
        public final int size() {
            return AntiCollisionHashMap.this.size;
        }

        @Override
        public final boolean contains(Object object) {
            return AntiCollisionHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return AntiCollisionHashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public final void clear() {
            AntiCollisionHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextEntry().value;
        }
    }

    abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
            if (AntiCollisionHashMap.this.size > 0) {
                AntiCollisionHashMap.this = AntiCollisionHashMap.this.table;
                while (this.index < AntiCollisionHashMap.this.length && (this.next = AntiCollisionHashMap.this[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.next = entry.next;
            if (this.next == null) {
                Entry<K, V>[] entryArray = AntiCollisionHashMap.this.table;
                while (this.index < entryArray.length && (this.next = entryArray[this.index++]) == null) {
                }
            }
            this.current = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            AntiCollisionHashMap.this.removeEntryForKey(k);
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> next;
        final int hash;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public final boolean equals(Object object) {
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            Object object2 = this.getKey();
            return (object2 == (k = object.getKey()) || object2 != null && object2.equals(k)) && ((object2 = this.getValue()) == (object = object.getValue()) || object2 != null && object2.equals(object));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

