/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            return DEFAULT_PROPERTIES.getProperty(string);
        }
        return string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (inputStream != null) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3 = n;
        int n4 = 0;
        if (l < 0L) {
            n4 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n3] = DigitOnes[n];
            cArray[--n3] = DigitTens[n];
        }
        int n5 = (int)l;
        while (n5 >= 65536) {
            int n6 = n5 / 100;
            n = n5 - ((n6 << 6) + (n6 << 5) + (n6 << 2));
            n5 = n6;
            cArray[--n3] = DigitOnes[n];
            cArray[--n3] = DigitTens[n];
        }
        do {
            n2 = n5 * 52429 >>> 19;
            n = n5 - ((n2 << 3) + (n2 << 1));
            cArray[--n3] = digits[n];
        } while ((n5 = n2) != 0);
        if (n4 != 0) {
            cArray[--n3] = n4;
        }
    }

    public static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4 = n2;
        int n5 = 0;
        if (n < 0) {
            n5 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n2 = n / 100;
            n3 = n - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n = n2;
            cArray[--n4] = DigitOnes[n3];
            cArray[--n4] = DigitTens[n3];
        }
        do {
            n2 = n * 52429 >>> 19;
            n3 = n - ((n2 << 3) + (n2 << 1));
            cArray[--n4] = digits[n3];
        } while ((n = n2) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    public static void getChars(byte by, int n, char[] cArray) {
        byte by2 = by;
        int n2 = n;
        int n3 = 0;
        if (by < 0) {
            n3 = 45;
            by2 = -by;
        }
        do {
            by = (byte)(by2 * 52429 >>> 19);
            n = by2 - ((by << 3) + (by << 1));
            cArray[--n2] = digits[n];
        } while ((by2 = by) != 0);
        if (n3 != 0) {
            cArray[--n2] = n3;
        }
    }

    public static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public static void dd(CharsetDecoder charsetDecoder, ByteBuffer object, CharBuffer charBuffer) {
        try {
            object = charsetDecoder.decode((ByteBuffer)object, charBuffer, true);
            if (!((CoderResult)object).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            if (!((CoderResult)(object = charsetDecoder.flush(charBuffer))).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c) {
        return c < firstIdentifierFlags.length && firstIdentifierFlags[c];
    }

    public static boolean isIdent(char c) {
        return c < identifierFlags.length && identifierFlags[c];
    }

    public static byte[] ddb(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n;
        n = n + n2 - 1;
        while (n3 < n && IA[cArray[n3]] < 0) {
            ++n3;
        }
        while (n > 0 && IA[cArray[n]] < 0) {
            --n;
        }
        int n4 = cArray[n] == '=' ? (cArray[n - 1] == '=' ? 2 : 1) : 0;
        int n5 = n - n3 + 1;
        n2 = n2 > 76 ? (cArray[76] == '\r' ? n5 / 78 : 0) << 1 : 0;
        n5 = ((n5 - n2) * 6 >> 3) - n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n5 / 3 * 3;
        while (n6 < n8) {
            int n9 = IA[cArray[n3++]] << 18 | IA[cArray[n3++]] << 12 | IA[cArray[n3++]] << 6 | IA[cArray[n3++]];
            byArray[n6++] = (byte)(n9 >> 16);
            byArray[n6++] = (byte)(n9 >> 8);
            byArray[n6++] = (byte)n9;
            if (n2 <= 0 || ++n7 != 19) continue;
            n3 += 2;
            n7 = 0;
        }
        if (n6 < n5) {
            n7 = 0;
            n8 = 0;
            while (n3 <= n - n4) {
                n7 |= IA[cArray[n3++]] << 18 - n8 * 6;
                ++n8;
            }
            n8 = 16;
            while (n6 < n5) {
                byArray[n6++] = (byte)(n7 >> n8);
                n8 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string, int n, int n2) {
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n;
        n = n + n2 - 1;
        while (n3 < n && IA[string.charAt(n3)] < 0) {
            ++n3;
        }
        while (n > 0 && IA[string.charAt(n)] < 0) {
            --n;
        }
        int n4 = string.charAt(n) == '=' ? (string.charAt(n - 1) == '=' ? 2 : 1) : 0;
        int n5 = n - n3 + 1;
        n2 = n2 > 76 ? (string.charAt(76) == '\r' ? n5 / 78 : 0) << 1 : 0;
        n5 = ((n5 - n2) * 6 >> 3) - n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n5 / 3 * 3;
        while (n6 < n8) {
            int n9 = IA[string.charAt(n3++)] << 18 | IA[string.charAt(n3++)] << 12 | IA[string.charAt(n3++)] << 6 | IA[string.charAt(n3++)];
            byArray[n6++] = (byte)(n9 >> 16);
            byArray[n6++] = (byte)(n9 >> 8);
            byArray[n6++] = (byte)n9;
            if (n2 <= 0 || ++n7 != 19) continue;
            n3 += 2;
            n7 = 0;
        }
        if (n6 < n5) {
            n7 = 0;
            n8 = 0;
            while (n3 <= n - n4) {
                n7 |= IA[string.charAt(n3++)] << 18 - n8 * 6;
                ++n8;
            }
            n8 = 16;
            while (n6 < n5) {
                byArray[n6++] = (byte)(n7 >> n8);
                n8 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] ddb(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n2 - 1;
        for (n = 0; n < n3 && IA[string.charAt(n) & 0xFF] < 0; ++n) {
        }
        while (n3 > 0 && IA[string.charAt(n3) & 0xFF] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n3 - n + 1;
        n2 = n2 > 76 ? (string.charAt(76) == '\r' ? n5 / 78 : 0) << 1 : 0;
        n5 = ((n5 - n2) * 6 >> 3) - n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n5 / 3 * 3;
        while (n6 < n8) {
            int n9 = IA[string.charAt(n++)] << 18 | IA[string.charAt(n++)] << 12 | IA[string.charAt(n++)] << 6 | IA[string.charAt(n++)];
            byArray[n6++] = (byte)(n9 >> 16);
            byArray[n6++] = (byte)(n9 >> 8);
            byArray[n6++] = (byte)n9;
            if (n2 <= 0 || ++n7 != 19) continue;
            n += 2;
            n7 = 0;
        }
        if (n6 < n5) {
            n7 = 0;
            n8 = 0;
            while (n <= n3 - n4) {
                n7 |= IA[string.charAt(n++)] << 18 - n8 * 6;
                ++n8;
            }
            n8 = 16;
            while (n6 < n5) {
                byArray[n6++] = (byte)(n7 >> n8);
                n8 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int edu(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = n + n2;
        int n4 = 0;
        n2 = 0 + Math.min(n2, byArray.length);
        while (n4 < n2 && cArray[n] < '\u0080') {
            byArray[n4++] = (byte)cArray[n++];
        }
        while (true) {
            block12: {
                block11: {
                    block13: {
                        if (n >= n3) {
                            return n4;
                        }
                        if ((n2 = cArray[n++]) < 128) {
                            byArray[n4++] = (byte)n2;
                            continue;
                        }
                        if (n2 < 2048) {
                            byArray[n4++] = (byte)(0xC0 | n2 >> 6);
                            byArray[n4++] = (byte)(0x80 | n2 & 0x3F);
                            continue;
                        }
                        if (n2 < 55296 || n2 >= 57344) break block12;
                        int n5 = n - 1;
                        if (n2 < 55296 || n2 >= 56320) break block13;
                        if (n3 - n5 < 2) {
                            n2 = -1;
                            break block11;
                        } else if ((n5 = cArray[n5 + 1]) >= 56320 && n5 < 57344) {
                            n2 = (n2 << 10) + n5 + -56613888;
                            break block11;
                        } else {
                            byArray[n4++] = 63;
                            continue;
                        }
                    }
                    if (n2 >= 56320 && n2 < 57344) {
                        byArray[n4++] = 63;
                        continue;
                    }
                }
                if (n2 < 0) {
                    byArray[n4++] = 63;
                    continue;
                }
                byArray[n4++] = (byte)(0xF0 | n2 >> 18);
                byArray[n4++] = (byte)(0x80 | n2 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n2 & 0x3F);
                ++n;
                continue;
            }
            byArray[n4++] = (byte)(0xE0 | n2 >> 12);
            byArray[n4++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n2 & 0x3F);
        }
    }

    public static int ddu(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = n + n2;
        int n4 = 0;
        n2 = Math.min(n2, cArray.length);
        while (n4 < n2 && byArray[n] >= 0) {
            cArray[n4++] = (char)byArray[n++];
        }
        while (n < n3) {
            char c;
            byte by;
            byte by2;
            if ((n2 = byArray[n++]) >= 0) {
                cArray[n4++] = (char)n2;
                continue;
            }
            if (n2 >> 5 == -2 && (n2 & 0x1E) != 0) {
                if (n < n3) {
                    if (((by2 = byArray[n++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n4++] = (char)(n2 << 6 ^ by2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (n2 >> 4 == -2) {
                if (n + 1 < n3) {
                    by2 = byArray[n++];
                    by = byArray[n++];
                    if (n2 == -32 && (by2 & 0xE0) == 128 || (by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                        return -1;
                    }
                    c = (char)(n2 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (c >= '\ud800' && c < '\ue000') {
                        return -1;
                    }
                    cArray[n4++] = c;
                    continue;
                }
                return -1;
            }
            if (n2 >> 3 == -2) {
                if (n + 2 < n3) {
                    by2 = byArray[n++];
                    by = byArray[n++];
                    c = byArray[n++];
                    n2 = n2 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                    if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (c & 0xC0) != 128 || n2 < 65536 || n2 >= 0x110000) {
                        return -1;
                    }
                    cArray[n4++] = (char)((n2 >>> 10) + 55232);
                    cArray[n4++] = (char)((n2 & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return n4;
    }

    public static String readAll(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = reader.read(cArray, 0, 2048)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new JSONException("read string from reader error", exception);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' || IOUtils.isIdent(c)) continue;
            return false;
        }
        return true;
    }

    static {
        int n;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        for (n = 0; n < firstIdentifierFlags.length; n = (int)((char)(n + 1))) {
            if (!(n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 95) && n != 36) continue;
            IOUtils.firstIdentifierFlags[n] = true;
        }
        for (n = 0; n < identifierFlags.length; n = (int)((char)(n + 1))) {
            if (n >= 65 && n <= 90) {
                IOUtils.identifierFlags[n] = true;
                continue;
            }
            if (n >= 97 && n <= 122) {
                IOUtils.identifierFlags[n] = true;
                continue;
            }
            if (n == 95) {
                IOUtils.identifierFlags[n] = true;
                continue;
            }
            if (n < 48 || n > 57) continue;
            IOUtils.identifierFlags[n] = true;
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {}
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (n = 14; n <= 31; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 127; n < 160; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 0; n < 161; ++n) {
            IOUtils.specicalFlags_doubleQuotesFlags[n] = specicalFlags_doubleQuotes[n] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[n] = specicalFlags_singleQuotes[n] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n2 = CA.length;
        for (n = 0; n < n2; ++n) {
            IOUtils.IA[IOUtils.CA[n]] = n;
        }
        IOUtils.IA[61] = 0;
    }
}

