/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import java.util.Arrays;

public class IdentityHashMap<K, V> {
    private final Entry<K, V>[] buckets;
    private final int indexMask;
    public static final int DEFAULT_SIZE = 8192;

    public IdentityHashMap() {
        this(8192);
    }

    public IdentityHashMap(int n) {
        this.indexMask = n - 1;
        this.buckets = new Entry[n];
    }

    public final V get(K k) {
        int n = System.identityHashCode(k) & this.indexMask;
        Entry<K, V> entry = this.buckets[n];
        while (entry != null) {
            if (k == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Class findClass(String string) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry<K, V> entry = this.buckets[i];
            if (entry == null) continue;
            Entry<K, V> entry2 = entry;
            while (entry2 != null) {
                Object object = entry.key;
                if (object instanceof Class && ((Class)(object = (Class)object)).getName().equals(string)) {
                    return object;
                }
                entry2 = entry2.next;
            }
        }
        return null;
    }

    public boolean put(K k, V v) {
        int n = System.identityHashCode(k);
        int n2 = n & this.indexMask;
        Entry<K, V> entry = this.buckets[n2];
        while (entry != null) {
            if (k == entry.key) {
                entry.value = v;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[n2] = entry = new Entry<K, V>(k, v, n, this.buckets[n2]);
        return false;
    }

    public void clear() {
        Arrays.fill(this.buckets, null);
    }

    public int size() {
        int n = 0;
        Entry<K, V>[] entryArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Entry<K, V> entry = entryArray[i];
            while (entry != null) {
                ++n;
                entry = entry.next;
            }
        }
        return n;
    }

    protected static final class Entry<K, V> {
        public final int hashCode;
        public final K key;
        public V value;
        public final Entry<K, V> next;

        public Entry(K k, V v, int n, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.next = entry;
            this.hashCode = n;
        }
    }
}

