/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Looper;
import android.os.StatFs;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.tradplus.ads.common.CreativeOrientation;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.common.util.VersionCode;
import java.io.File;

public class DeviceUtils {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static final int MIN_DISK_CACHE_SIZE = 0x1E00000;
    private static final int MAX_DISK_CACHE_SIZE = 0x6400000;

    private DeviceUtils() {
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        try {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context == null) {
                return false;
            }
            if ((context = context.getActiveNetworkInfo()) != null) {
                return context.isConnected();
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void isMainThread() {
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        Log.i((String)"TradPlus isMainThread", (String)"isMainThread == ".concat(String.valueOf(bl)));
    }

    public static int getCPUProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int memoryCacheSizeBytes(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        long l = activityManager.getMemoryClass();
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB)) {
            try {
                int n = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
                if (Utils.bitMaskContainsFlag(context.getApplicationInfo().flags, n)) {
                    l = ((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
                }
            }
            catch (Exception exception) {
                LogUtil.show("Unable to reflectively determine large heap size on Honeycomb and above.");
            }
        }
        return (int)Math.min(0x1E00000L, l / 8L * 1024L * 1024L);
    }

    public static long diskCacheSizeBytes(File file, long l) {
        long l2 = l;
        try {
            file = new StatFs(file.getAbsolutePath());
            l2 = (long)file.getBlockCount() * (long)file.getBlockSize() / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return Math.max(Math.min(l2, 0x6400000L), 0x1E00000L);
    }

    public static long diskCacheSizeBytes(File file) {
        return DeviceUtils.diskCacheSizeBytes(file, 0x1E00000L);
    }

    public static int getScreenOrientation(Activity activity) {
        int n = activity.getWindowManager().getDefaultDisplay().getRotation();
        int n2 = activity.getResources().getConfiguration().orientation;
        return DeviceUtils.getScreenOrientationFromRotationAndOrientation(n, n2);
    }

    static int getScreenOrientationFromRotationAndOrientation(int n, int n2) {
        if (1 == n2) {
            switch (n) {
                case 1: 
                case 2: {
                    return 9;
                }
            }
            return 1;
        }
        if (2 == n2) {
            switch (n) {
                case 2: 
                case 3: {
                    return 8;
                }
            }
            return 0;
        }
        LogUtil.show("Unknown screen orientation. Defaulting to portrait.");
        return 9;
    }

    public static boolean isScreenLandscapeOrientation(Context context) {
        if (context == null) {
            return false;
        }
        if ((context = context.getResources()) == null) {
            return false;
        }
        if ((context = context.getConfiguration()) == null) {
            return false;
        }
        switch (context.orientation) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public static String getScreenOrientationToString(Context context) {
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "\u6a2a\u5c4f";
        }
        return "\u7ad6\u5c4f";
    }

    public static String getScreenOrientationToString(int n) {
        if (n == 3 || n == 0) {
            return "\u81ea\u9002\u5e94";
        }
        if (n == 1) {
            return "\u7ad6\u5c4f";
        }
        if (n == 2) {
            return "\u6a2a\u5c4f";
        }
        if (n == 4) {
            return "\u4ec5\u7ad6\u5c4f";
        }
        if (n == 5) {
            return "\u4ec5\u6a2a\u5c4f";
        }
        return "\u81ea\u9002\u5e94";
    }

    public static void lockOrientation(Activity activity, CreativeOrientation creativeOrientation) {
        int n;
        if (!Preconditions.NoThrow.checkNotNull((Object)creativeOrientation) || !Preconditions.NoThrow.checkNotNull(activity)) {
            return;
        }
        int n2 = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getRotation();
        int n3 = activity.getResources().getConfiguration().orientation;
        n2 = DeviceUtils.getScreenOrientationFromRotationAndOrientation(n2, n3);
        if (CreativeOrientation.PORTRAIT == creativeOrientation) {
            n = 9 == n2 ? 9 : 1;
        } else if (CreativeOrientation.LANDSCAPE == creativeOrientation) {
            n = 8 == n2 ? 8 : 0;
        } else {
            return;
        }
        activity.setRequestedOrientation(n);
    }

    @TargetApi(value=17)
    public static Point getDeviceDimensions(Context context) {
        Display display;
        Integer n = null;
        Integer n2 = null;
        if (Build.VERSION.SDK_INT >= 13) {
            display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                Point point = new Point();
                display.getRealSize(point);
                n = point.x;
                n2 = point.y;
            } else {
                try {
                    n = (Integer)new Reflection.MethodBuilder(display, "getRawWidth").execute();
                    n2 = (Integer)new Reflection.MethodBuilder(display, "getRawHeight").execute();
                }
                catch (Exception exception) {
                    LogUtil.show("Display#getRawWidth/Height failed.".concat(String.valueOf(exception)));
                }
            }
        }
        if (n == null || n2 == null) {
            display = context.getResources().getDisplayMetrics();
            n = display.widthPixels;
            n2 = display.heightPixels;
        }
        return new Point(n.intValue(), n2.intValue());
    }

    public static String getIpAddress(IP iP) {
        return null;
    }

    @Deprecated
    public static String getHashedUdid(Context context) {
        return null;
    }

    public static int dip2px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2dip(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f / (f2 <= 0.0f ? 1.0f : f2) + 0.5f);
    }

    public static float getScreenWidthDp(Context context) {
        float f = context.getResources().getDisplayMetrics().density;
        return (float)context.getResources().getDisplayMetrics().widthPixels / (f <= 0.0f ? 1.0f : f) + 0.5f;
    }

    public static String getScreenOrientation(Context context) {
        if (DeviceUtils.isScreenLandscapeOrientation(context)) {
            return "2";
        }
        return "1";
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @Deprecated
    public static enum IP {
        IPv4,
        IPv6;

    }

    public static enum ForceOrientation {
        FORCE_PORTRAIT("portrait"),
        FORCE_LANDSCAPE("landscape"),
        DEVICE_ORIENTATION("device"),
        UNDEFINED("");

        private final String mKey;

        private ForceOrientation(String string2) {
            this.mKey = string2;
        }

        public static ForceOrientation getForceOrientation(String string) {
            for (ForceOrientation forceOrientation : ForceOrientation.values()) {
                if (!forceOrientation.mKey.equalsIgnoreCase(string)) continue;
                return forceOrientation;
            }
            return UNDEFINED;
        }
    }
}

