/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import com.tradplus.ads.common.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Reflection {
    public static Method getDeclaredMethodWithTraversal(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException();
    }

    public static boolean classFound(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static <T> T instantiateClassWithEmptyConstructor(String object, Class<? extends T> clazz) {
        Preconditions.checkNotNull(object);
        object = Class.forName((String)object).asSubclass(clazz).getDeclaredConstructor(null);
        ((Constructor)object).setAccessible(true);
        return ((Constructor)object).newInstance(new Object[0]);
    }

    public static <T> T instantiateClassWithConstructor(String object, Class<? extends T> clazz, Class[] classArray, Object[] objectArray) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(classArray);
        Preconditions.checkNotNull(objectArray);
        object = Class.forName((String)object).asSubclass(clazz).getDeclaredConstructor(classArray);
        ((Constructor)object).setAccessible(true);
        return ((Constructor)object).newInstance(objectArray);
    }

    public static class MethodBuilder {
        private final Object mInstance;
        private final String mMethodName;
        private Class<?> mClass;
        private List<Class<?>> mParameterClasses;
        private List<Object> mParameters;
        private boolean mIsAccessible;
        private boolean mIsStatic;

        public MethodBuilder(Object object, String string) {
            this.mInstance = object;
            this.mMethodName = string;
            this.mParameterClasses = new ArrayList();
            this.mParameters = new ArrayList<Object>();
            this.mClass = object != null ? object.getClass() : null;
        }

        public <T> MethodBuilder addParam(Class<T> clazz, T t) {
            this.mParameterClasses.add(clazz);
            this.mParameters.add(t);
            return this;
        }

        public MethodBuilder setAccessible() {
            this.mIsAccessible = true;
            return this;
        }

        public MethodBuilder setStatic(Class<?> clazz) {
            this.mIsStatic = true;
            this.mClass = clazz;
            return this;
        }

        public Object execute() {
            Object object = new Class[this.mParameterClasses.size()];
            object = this.mParameterClasses.toArray((T[])object);
            object = Reflection.getDeclaredMethodWithTraversal(this.mClass, this.mMethodName, object);
            if (this.mIsAccessible) {
                ((Method)object).setAccessible(true);
            }
            Object[] objectArray = this.mParameters.toArray();
            if (this.mIsStatic) {
                return ((Method)object).invoke(null, objectArray);
            }
            return ((Method)object).invoke(this.mInstance, objectArray);
        }
    }
}

