/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.view.View;
import com.tradplus.ads.common.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public class Utils {
    private static final AtomicLong sNextGeneratedId = new AtomicLong(1L);

    public static long generateUniqueId() {
        long l;
        long l2;
        do {
            if ((l = (l2 = sNextGeneratedId.get()) + 1L) <= 0x7FFFFFFFFFFFFFFEL) continue;
            l = 1L;
        } while (!sNextGeneratedId.compareAndSet(l2, l));
        return l2;
    }

    public static boolean bitMaskContainsFlag(int n, int n2) {
        return (n & n2) != 0;
    }

    public static void hideNavigationBar(Activity activity) {
        Preconditions.checkNotNull(activity);
        activity = activity.getWindow();
        if (activity != null) {
            activity = activity.getDecorView();
            Utils.hideNavigation((View)activity);
            Activity activity2 = activity;
            activity2.setOnSystemUiVisibilityChangeListener(Utils.createHideNavigationListener((View)activity2));
        }
    }

    static View.OnSystemUiVisibilityChangeListener createHideNavigationListener(final View view) {
        Preconditions.checkNotNull(view);
        return new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int n) {
                if ((n & 2) == 0) {
                    Utils.hideNavigation(view);
                }
            }
        };
    }

    static void hideNavigation(View view) {
        Preconditions.checkNotNull(view);
        view.setSystemUiVisibility(4870);
    }
}

