/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.tradplus.ads.common.util.LogUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class Views {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public static void removeFromParent(View view) {
        if (view == null || view.getParent() == null) {
            return;
        }
        if (view.getParent() instanceof ViewGroup) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public static View getTopmostView(Context context, View view) {
        context = Views.getRootViewFromActivity(context);
        view = Views.getRootViewFromView(view);
        if (context != null) {
            return context;
        }
        return view;
    }

    private static View getRootViewFromActivity(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        return ((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
    }

    private static View getRootViewFromView(View view) {
        if (view == null) {
            return null;
        }
        if (!Views.isAttachedToWindow(view)) {
            LogUtil.show("Attempting to call View#getRootView() on an unattached View.");
        }
        if ((view = view.getRootView()) == null) {
            return null;
        }
        View view2 = view.findViewById(0x1020002);
        if (view2 != null) {
            return view2;
        }
        return view;
    }

    public static boolean isAttachedToWindow(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }

    public static int generateViewId() {
        int n;
        int n2;
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        do {
            if ((n = (n2 = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            n = 1;
        } while (!sNextGeneratedId.compareAndSet(n2, n));
        return n2;
    }

    public static boolean getLocalVisibleRect(Context context, View view) {
        Point point = new Point();
        ((Activity)context).getWindowManager().getDefaultDisplay().getSize(point);
        int n = point.x;
        int n2 = point.y;
        Rect rect = new Rect(0, 0, n, n2);
        int[] nArray = new int[2];
        view.getLocationInWindow(nArray);
        view.setTag((Object)nArray[1]);
        return view.getLocalVisibleRect(rect);
    }
}

