/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.pushcenter.http;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.response.BaseResponse;
import org.json.JSONObject;

public class PushCenterHttpUtils {
    private static Context context;
    private static boolean enableLog;

    public static void init(Context context) {
        PushCenterHttpUtils.context = context;
    }

    private static void printLog(String string, String string2) {
        if (enableLog) {
            LogUtil.show(string, TextUtils.isEmpty((CharSequence)string2) ? "tradplus push" : string2);
        }
    }

    public static void pushMessageArray(String string, String[] stringArray, Listener listener) {
        if (TextUtils.isEmpty((CharSequence)string) || stringArray == null || stringArray.length == 0) {
            return;
        }
        LogUtil.ownShow("push url = ".concat(String.valueOf(string)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        Object object = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = PushCenterHttpUtils.addTimeDiff(object[i]);
            stringBuilder.append(string2).append(",");
            PushCenterHttpUtils.printLog(string2, "tradplus push size:" + stringArray.length + " index:" + n++);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        stringBuilder.append("]");
        object = stringBuilder.toString();
        LogUtil.ownShow("push url DATA = ".concat(String.valueOf(stringBuilder)));
        PushCenterHttpUtils.push(string, (String)object, listener);
    }

    private static String addTimeDiff(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            long l = System.currentTimeMillis();
            jSONObject.put("time", (int)((l - jSONObject.optLong("createTime", l)) / 1000L));
            return jSONObject.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void pushSingleMessage(String string, Object object, Listener listener) {
        LogUtil.ownShow("push url = ".concat(String.valueOf(string)));
        if (object == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        PushCenterHttpUtils.printLog("pushMessage url=".concat(String.valueOf(string)), null);
        stringBuilder.append(JSONHelper.toJSON(object));
        stringBuilder.append("]");
        object = stringBuilder.toString();
        PushCenterHttpUtils.printLog((String)object, null);
        PushCenterHttpUtils.push(string, (String)object, listener);
    }

    public static void pushGet(String string, Listener listener) {
        PushCenterHttpUtils.printLog("pushGet url=".concat(String.valueOf(string)), null);
        PushCenterHttpUtils.push(string, null, listener);
    }

    public static void push(String string, String string2, final Listener listener) {
        if (context == null) {
            return;
        }
        TPRequestManager.getInstance().requestPushMessage(string, string2, new BaseHttpRequest.OnHttpLoaderListener(){

            public void loadSuccess(Object object) {
                LogUtil.ownShow("push message success");
                if (listener != null) {
                    listener.onSuccess(new BaseResponse(200));
                }
            }

            @Override
            public void loadError(int n, String string) {
                LogUtil.ownShow("push message error code = " + n + " msg = " + string);
                if (listener != null) {
                    listener.oError(n, string);
                }
            }

            @Override
            public void loadCanceled() {
            }
        });
    }

    static {
        enableLog = false;
    }
}

