/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.pushcenter.utils;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import com.tradplus.ads.pushcenter.reqeust.VideoRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;

public class SendMessageUtil {
    private static SendMessageUtil instance;

    public static SendMessageUtil getInstance() {
        if (instance == null) {
            instance = new SendMessageUtil();
        }
        return instance;
    }

    public void sendOpenAPIStart(Context context) {
        TPPushCenter.getInstance().pushEvent(new BaseRequest(context, PushMessageUtils.PushStatus.EV_REQ_OPEN_API_START.getValue()));
        TPPushCenter.getInstance().pushEvent(new SimplifyEvent(PushMessageUtils.PushStatus.EV_REQ_OPEN_API_START.getValue()));
    }

    public void sendPrivacyResult(final Context context) {
        TPTaskManager.getInstance().runOnMainThreadDelayed(new Runnable(){

            @Override
            public void run() {
                BaseRequest baseRequest = new BaseRequest(context, PushMessageUtils.PushStatus.EV_REQ_PRIVACY_RESULT.getValue());
                TPPushCenter.getInstance().saveEvent(baseRequest);
                if (TestDeviceUtil.getInstance().isNeedTestDevice()) {
                    if (!TextUtils.isEmpty((CharSequence)baseRequest.getDdid())) {
                        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.ADVERTIDING_ID, baseRequest.getDdid());
                    }
                    if (!TextUtils.isEmpty((CharSequence)baseRequest.getDid())) {
                        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.DEVICE_ID, baseRequest.getDid());
                    }
                }
            }
        }, 2000L);
    }

    public void sendLoadAdconfStart(Context object, String string, boolean bl) {
        object = new AdconfRequest((Context)object, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF_START.getValue());
        object.setLuid(string);
        if (bl) {
            TPPushCenter.getInstance().pushEvent((BaseRequest)object);
        }
        object = new SimplifyEvent(PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF_START.getValue());
        object.setLuid(string);
        if (bl) {
            TPPushCenter.getInstance().pushEvent((SimplifyEvent)object);
        }
    }

    public void sendLoadAdStart(Context object, String string, String string2, int n) {
        object = new VideoRequest((Context)object, PushMessageUtils.PushStatus.EV_LOAD_AD_START.getValue());
        ((BaseRequest)object).setLuid(string);
        ((VideoRequest)object).setRequestId(string2);
        ((VideoRequest)object).setOp(String.valueOf(n));
        TPPushCenter.getInstance().saveEvent((BaseRequest)object);
    }
}

