/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.vungle;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.vungle.VungleErrorUtil;
import com.tradplus.ads.vungle.VungleInitManager;
import com.tradplus.ads.vungle.VungleInterstitialCallbackRouter;
import com.vungle.warren.AdConfig;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleInterstitialVideo
extends TPRewardAdapter {
    private static final String TAG = "VungleRewardedVideo";
    private VungleInterstitialCallbackRouter mRouter;
    private String placementId;
    private String userId;
    private String payload;
    private String appId;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;
    private Integer mVideoMute = 1;
    private Integer mAdOri = 0;
    private Map<String, Object> localExtras;
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback(){

        public void onAdLoad(String placementReferenceID) {
            VungleInterstitialVideo.this.setFirstLoadedTime();
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdLoad: ");
            if (VungleInterstitialVideo.this.mRouter.getListener(placementReferenceID) != null) {
                VungleInterstitialVideo.this.mRouter.getListener(placementReferenceID).loadAdapterLoaded(null);
            }
        }

        public void onError(String id, VungleException exception) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)("onError: " + exception.getLocalizedMessage()));
            if (VungleInterstitialVideo.this.mRouter.getListener(id) != null) {
                VungleInterstitialVideo.this.mRouter.getListener(id).loadAdapterLoadFailed(VungleErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", (Throwable)exception));
            }
        }
    };
    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback(){

        public void creativeId(String s) {
        }

        public void onAdStart(String placementReferenceID) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdStart: ");
        }

        public void onAdEnd(String id, boolean completed, boolean isCTAClicked) {
        }

        public void onAdEnd(String id) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdEnd: ");
            if (VungleInterstitialVideo.this.mRouter.getShowListener(id) == null) {
                return;
            }
            VungleInterstitialVideo.this.mRouter.getShowListener(id).onAdVideoEnd();
            if (VungleInterstitialVideo.this.hasGrantedReward || VungleInterstitialVideo.this.alwaysRewardUser) {
                VungleInterstitialVideo.this.mRouter.getShowListener(id).onReward();
            }
            VungleInterstitialVideo.this.mRouter.getShowListener(id).onAdClosed();
        }

        public void onAdClick(String id) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdClick: ");
            if (VungleInterstitialVideo.this.mRouter.getShowListener(id) != null) {
                VungleInterstitialVideo.this.mRouter.getShowListener(id).onAdClicked();
            }
        }

        public void onAdRewarded(String id) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdRewarded: ");
            VungleInterstitialVideo.this.hasGrantedReward = true;
        }

        public void onAdLeftApplication(String id) {
        }

        public void onError(String id, VungleException exception) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)("onError: " + exception.getLocalizedMessage()));
            if (VungleInterstitialVideo.this.mRouter.getListener(id) != null) {
                VungleInterstitialVideo.this.mRouter.getListener(id).loadAdapterLoadFailed(VungleErrorUtil.getTradPlusErrorCode("Didn't find valid adv.Show Failed", (Throwable)exception));
            }
        }

        public void onAdViewed(String id) {
            Log.i((String)VungleInterstitialVideo.TAG, (String)"onAdViewed: ");
            if (VungleInterstitialVideo.this.mRouter.getShowListener(id) != null) {
                VungleInterstitialVideo.this.mRouter.getShowListener(id).onAdShown();
                VungleInterstitialVideo.this.mRouter.getShowListener(id).onAdVideoStart();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.localExtras = localExtras;
        if (this.extrasAreValid(serverExtras)) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            this.payload = serverExtras.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)serverExtras.get("always_reward"))) {
                int rewardUser = Integer.parseInt(serverExtras.get("always_reward"));
                boolean bl = this.alwaysRewardUser = rewardUser == 1;
            }
            if (serverExtras.containsKey("direction")) {
                this.mAdOri = Integer.parseInt(serverExtras.get("direction"));
            }
            if (serverExtras.containsKey("video_mute")) {
                this.mVideoMute = Integer.parseInt(serverExtras.get("video_mute"));
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras != null && localExtras.size() > 0) {
            if (localExtras.containsKey("user_id")) {
                this.userId = (String)localExtras.get("user_id");
                if (TextUtils.isEmpty((CharSequence)this.userId)) {
                    this.userId = "";
                }
            }
            if (localExtras.containsKey("video_mute")) {
                this.mVideoMute = (int)((Integer)localExtras.get("video_mute"));
            }
            if (localExtras.containsKey("ad_orientation")) {
                this.mAdOri = (int)((Integer)localExtras.get("ad_orientation"));
            }
        }
        this.mRouter = VungleInterstitialCallbackRouter.getInstance();
        this.mRouter.addListener(this.placementId, this.mLoadAdapterListener);
        VungleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                VungleInterstitialVideo.this.VungleLoadAd();
            }

            public void onFailed(String code, String msg) {
                if (VungleInterstitialVideo.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    VungleInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void VungleLoadAd() {
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            Vungle.loadAd((String)this.placementId, (AdConfig)this.getAdConfig(), (LoadAdCallback)this.vungleLoadAdCallback);
        } else {
            Vungle.loadAd((String)this.placementId, (String)this.payload, (AdConfig)this.getAdConfig(), (LoadAdCallback)this.vungleLoadAdCallback);
        }
    }

    private AdConfig getAdConfig() {
        AdConfig adConfig = new AdConfig();
        adConfig.setBackButtonImmediatelyEnabled(true);
        adConfig.setAdOrientation(this.AdOrientation(this.mAdOri));
        adConfig.setMuted(this.mVideoMute == 1);
        adConfig.setOrdinal(1);
        return adConfig;
    }

    private int AdOrientation(int ori) {
        Log.i((String)TAG, (String)("AdOrientation: " + ori));
        if (ori == 0) {
            return 2;
        }
        if (ori == 1) {
            return 0;
        }
        if (ori == 2) {
            return 1;
        }
        if (ori == 3) {
            return 3;
        }
        return 2;
    }

    public boolean isReady() {
        if (this.placementId == null) {
            return !this.isAdsTimeOut();
        }
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            return !this.isAdsTimeOut() && Vungle.canPlayAd((String)this.placementId, (String)this.payload);
        }
        return !this.isAdsTimeOut() && Vungle.canPlayAd((String)this.placementId);
    }

    public void showAd() {
        if (this.mRouter != null && this.mShowListener != null) {
            this.mRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if (!Vungle.isInitialized()) {
            this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Third-party network SDK failed to init"));
            return;
        }
        if (this.mRouter.getShowListener(this.placementId) == null) {
            this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.userId)) {
            Log.i((String)TAG, (String)("RewardData: userId : " + this.userId));
            Vungle.setIncentivizedFields((String)this.userId, (String)"", (String)"", (String)"", (String)"");
        }
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            Log.i((String)TAG, (String)("showAd payload : " + this.payload));
            if (!Vungle.canPlayAd((String)this.placementId, (String)this.payload)) {
                this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                return;
            }
            Vungle.playAd((String)this.placementId, (String)this.payload, (AdConfig)this.getAdConfig(), (PlayAdCallback)this.vunglePlayAdCallback);
        } else {
            if (!Vungle.canPlayAd((String)this.placementId)) {
                this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                return;
            }
            Vungle.playAd((String)this.placementId, (AdConfig)this.getAdConfig(), (PlayAdCallback)this.vunglePlayAdCallback);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("7");
    }

    public String getNetworkVersion() {
        return "6.12.0";
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams) {
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return "";
        }
        this.appId = tpParams.get("appId");
        this.placementId = tpParams.get("placementId");
        if (GlobalTradPlus.getInstance().getContext() != null && !TextUtils.isEmpty((CharSequence)this.appId)) {
            VungleInitManager.getInstance().initSDK(context, this.localExtras, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                }

                public void onFailed(String code, String msg) {
                }
            });
            return Vungle.getAvailableBidTokens((Context)GlobalTradPlus.getInstance().getContext(), (String)this.placementId, (int)100);
        }
        return "";
    }
}

