/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.vungle;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.vungle.VungleErrorUtil;
import com.tradplus.ads.vungle.VungleInitManager;
import com.tradplus.ads.vungle.VungleTpNativeAd;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleNative
extends TPNativeAdapter {
    private VungleTpNativeAd mVungleTpNativeAd;
    private String placementId;
    private String payload;
    private String appId;
    private BannerAdConfig mBannerAdConfig;
    private VungleBanner mVungleBanner;
    private static final String TAG = "VungleNative";
    private Map<String, Object> userParams;
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback(){

        public void onAdLoad(String placementReferenceId) {
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context == null) {
                if (VungleNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Context == null");
                    tpError.setErrorMessage("context == null");
                    VungleNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
                return;
            }
            if (Banners.canPlayAd((String)VungleNative.this.placementId, (String)VungleNative.this.isEmptyPayLoad(), (AdConfig.AdSize)AdConfig.AdSize.VUNGLE_MREC)) {
                VungleNative.this.mVungleBanner = Banners.getBanner((String)VungleNative.this.placementId, (String)VungleNative.this.isEmptyPayLoad(), (BannerAdConfig)VungleNative.this.getAdConfig(), (PlayAdCallback)VungleNative.this.vunglePlayAdCallback);
                if (VungleNative.this.mVungleBanner != null) {
                    Log.i((String)VungleNative.TAG, (String)"onAdLoad:");
                    VungleNative.this.mVungleTpNativeAd = new VungleTpNativeAd(context, VungleNative.this.mVungleBanner);
                    if (VungleNative.this.mLoadAdapterListener != null) {
                        VungleNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)VungleNative.this.mVungleTpNativeAd);
                    }
                    return;
                }
                if (VungleNative.this.mLoadAdapterListener != null) {
                    Log.i((String)VungleNative.TAG, (String)"onAdLoad, but Banners.getBanner return null");
                    TPError tpError = new TPError("Third-party network failed to provide an ad.");
                    tpError.setErrorMessage("onAdLoad, but Banners.getBanner return null");
                    VungleNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
                return;
            }
            if (VungleNative.this.mLoadAdapterListener != null) {
                Log.i((String)VungleNative.TAG, (String)"onAdLoad, but Banners can't PlayAd");
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage("onAdLoad ,but Banners can't PlayAd");
                VungleNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }

        public void onError(String placementReferenceId, VungleException exception) {
            if (exception != null) {
                Log.i((String)VungleNative.TAG, (String)("InitCallback - onError: " + exception.getLocalizedMessage()));
                if (VungleNative.this.mLoadAdapterListener != null) {
                    VungleNative.this.mLoadAdapterListener.loadAdapterLoadFailed(VungleErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", (Throwable)exception));
                }
            } else {
                Log.i((String)VungleNative.TAG, (String)"Throwable is null");
            }
        }
    };
    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback(){

        public void creativeId(String s) {
        }

        public void onAdStart(String placementReferenceId) {
            Log.i((String)VungleNative.TAG, (String)"onAdStart: ");
        }

        public void onAdEnd(String s, boolean b, boolean b1) {
        }

        public void onAdEnd(String id) {
            Log.i((String)VungleNative.TAG, (String)"onAdEnd: ");
            if (VungleNative.this.mVungleTpNativeAd != null) {
                VungleNative.this.mVungleTpNativeAd.clean();
            }
        }

        public void onAdClick(String id) {
            Log.i((String)VungleNative.TAG, (String)"onAdClick: ");
            if (VungleNative.this.mVungleTpNativeAd != null) {
                VungleNative.this.mVungleTpNativeAd.onAdClicked();
            }
        }

        public void onAdRewarded(String id) {
            Log.i((String)VungleNative.TAG, (String)"onAdRewarded: ");
        }

        public void onAdLeftApplication(String id) {
            Log.i((String)VungleNative.TAG, (String)"onAdLeftApplication: ");
        }

        public void onError(String placementReferenceId, VungleException exception) {
            Log.i((String)VungleNative.TAG, (String)("onError ,placementReferenceID : " + exception + " , errormessage :" + exception.getLocalizedMessage()));
            if (VungleNative.this.mVungleTpNativeAd != null) {
                VungleNative.this.mVungleTpNativeAd.onAdVideoError(VungleErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", (Throwable)exception));
            }
        }

        public void onAdViewed(String id) {
            Log.i((String)VungleNative.TAG, (String)"onAdViewed: ");
            if (VungleNative.this.mVungleTpNativeAd != null) {
                VungleNative.this.mVungleTpNativeAd.onAdShown();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.userParams = userParams;
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appId = tpParams.get("appId");
        this.placementId = tpParams.get("placementId");
        this.payload = tpParams.get("Bidding-Payload");
        VungleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Banners.loadBanner((String)VungleNative.this.placementId, (String)VungleNative.this.isEmptyPayLoad(), (BannerAdConfig)VungleNative.this.getAdConfig(), (LoadAdCallback)VungleNative.this.vungleLoadAdCallback);
            }

            public void onFailed(String code, String msg) {
                if (VungleNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    VungleNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private BannerAdConfig getAdConfig() {
        this.mBannerAdConfig = new BannerAdConfig();
        this.mBannerAdConfig.setAdSize(AdConfig.AdSize.VUNGLE_MREC);
        this.mBannerAdConfig.setMuted(true);
        return this.mBannerAdConfig;
    }

    private String isEmptyPayLoad() {
        return TextUtils.isEmpty((CharSequence)this.payload) ? null : this.payload;
    }

    public void clean() {
        if (this.mVungleBanner != null) {
            Log.i((String)TAG, (String)"clean: ");
            this.mVungleBanner.destroyAd();
        }
    }

    private boolean extrasAreValid(Map<String, String> tpParams) {
        return tpParams.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("7");
    }

    public String getNetworkVersion() {
        return "6.12.0";
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams) {
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return "";
        }
        this.appId = tpParams.get("appId");
        this.placementId = tpParams.get("placementId");
        if (GlobalTradPlus.getInstance().getContext() != null && !TextUtils.isEmpty((CharSequence)this.appId)) {
            VungleInitManager.getInstance().initSDK(context, this.userParams, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                }

                public void onFailed(String code, String msg) {
                }
            });
            return Vungle.getAvailableBidTokens((Context)GlobalTradPlus.getInstance().getContext(), (String)this.placementId, (int)100);
        }
        return "";
    }
}

