/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.maticoo.sdk.ad.banner.BannerAd;
import com.maticoo.sdk.ad.banner.BannerAdListener;
import com.maticoo.sdk.ad.banner.BannerAdOptions;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.MaticooInitManager;
import java.util.HashMap;
import java.util.Map;

public class MaticooBanner
extends TPBannerAdapter {
    private String mPlacementId;
    private BannerAd mBannerAd;
    private String payload;
    private TPBannerAdImpl mTpBannerAd;
    private static final String TAG = "MaticooBanner";
    private String mName;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("Bidding-Payload"))) {
                this.payload = tpParams.get("Bidding-Payload");
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooBanner.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
                if (MaticooBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestAd(Context context) {
        BannerAdOptions.Builder builder = new BannerAdOptions.Builder(this.mPlacementId);
        builder.setCanCloseAd(true);
        builder.setAutoRefresh(false);
        this.mBannerAd = new BannerAd(context, builder.build());
        this.mBannerAd.setAdListener(new BannerAdListener(){

            public void onBannerAdReady(String placementId, View view) {
                if (view == null) {
                    TPError tpError = new TPError("Unspecified error.");
                    Log.i((String)MaticooBanner.TAG, (String)"Load Failed, view == null");
                    tpError.setErrorMessage("Load Failed, view == null");
                    MaticooBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    return;
                }
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdReady:");
                if (MaticooBanner.this.mLoadAdapterListener != null) {
                    MaticooBanner.this.mTpBannerAd = new TPBannerAdImpl((Object)view, (View)MaticooBanner.this.mBannerAd);
                    MaticooBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)MaticooBanner.this.mTpBannerAd);
                }
            }

            public void onBannerAdFailed(String s, Error error) {
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdFailed: ");
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooBanner.TAG, (String)("error\uff1a" + error.toString()));
                }
                if (MaticooBanner.this.mLoadAdapterListener != null) {
                    MaticooBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onBannerAdClicked(String placementId) {
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdClicked: ");
                if (MaticooBanner.this.mTpBannerAd != null) {
                    MaticooBanner.this.mTpBannerAd.adClicked();
                }
            }

            public void onBannerAdShow(String s) {
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdShow: ");
                if (MaticooBanner.this.mTpBannerAd != null) {
                    MaticooBanner.this.mTpBannerAd.adShown();
                }
            }

            public void onBannerAdShowFailed(String placementId, Error error) {
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdShowFailed: ");
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooBanner.TAG, (String)("error\uff1a" + error.toString()));
                }
                if (MaticooBanner.this.mTpBannerAd != null) {
                    MaticooBanner.this.mTpBannerAd.onAdShowFailed(tpError);
                }
            }

            public void onBannerAdClosed(String placementId) {
                Log.i((String)MaticooBanner.TAG, (String)"onBannerAdClosed: ");
                if (MaticooBanner.this.mTpBannerAd != null) {
                    MaticooBanner.this.mTpBannerAd.adClosed();
                }
            }
        });
        this.mBannerAd.setLocalExtra(MaticooInitManager.getInstance().getParameters());
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            this.mBannerAd.loadAd(this.payload);
        } else {
            this.mBannerAd.loadAd();
        }
    }

    public void clean() {
        if (this.mBannerAd != null) {
            this.mBannerAd.destroy();
            this.mBannerAd = null;
        }
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
        }
        MaticooInitManager.getInstance().setInitState("2");
        MaticooInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                long currentTimeMillis = System.currentTimeMillis();
                String biddingToken = MaticooAds.getBiddingToken((String)MaticooBanner.this.mPlacementId, (long)currentTimeMillis);
                Log.i((String)MaticooBanner.TAG, (String)("biddingToken: " + biddingToken));
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("time_stamp", currentTimeMillis);
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(biddingToken, hashMap);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

