/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.maticoo.sdk.InitConfiguration;
import com.maticoo.sdk.core.InitCallback;
import com.maticoo.sdk.core.MaticooAds;
import com.maticoo.sdk.utils.error.InternalError;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.util.TestDeviceUtil;
import java.util.HashMap;
import java.util.Map;

public class MaticooInitManager
extends TPInitMediation {
    private static final String TAG = "zMaticoo";
    private static MaticooInitManager sInstance;
    private String appKey;
    private String mName;

    public static synchronized MaticooInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new MaticooInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        if (tpParams != null && tpParams.size() > 0) {
            this.appKey = tpParams.get("AppKey");
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        }
        if (MaticooInitManager.isInited((String)this.appKey)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(this.appKey, initCallback)) {
            return;
        }
        if (MaticooAds.isInit()) {
            this.sendResult(this.appKey, true);
            return;
        }
        boolean needTestDevice = TestDeviceUtil.getInstance().isNeedTestDevice();
        InitConfiguration configuration = new InitConfiguration.Builder().appKey(this.appKey).localExtra(this.getParameters()).logEnable(needTestDevice).build();
        MaticooAds.init((InitConfiguration)configuration, (InitCallback)new InitCallback(){

            public void onSuccess() {
                Log.i((String)MaticooInitManager.TAG, (String)"onSuccess: ");
                MaticooInitManager.this.sendResult(MaticooInitManager.this.appKey, true);
            }

            public void onError(InternalError internalError) {
                Log.i((String)MaticooInitManager.TAG, (String)"onError: ");
                if (internalError != null) {
                    int errorCode = internalError.getErrorCode();
                    String errorMessage = internalError.getErrorMessage();
                    MaticooInitManager.this.sendResult(MaticooInitManager.this.appKey, false, errorCode + "", errorMessage);
                } else {
                    MaticooInitManager.this.sendResult(MaticooInitManager.this.appKey, false, "", "Unspecified error.");
                }
            }
        });
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> localExtra = new HashMap<String, Object>();
        localExtra.put("mediation", "TradPlus");
        Log.i((String)TAG, (String)"setlocalExtra: mediation :: TRADPLUS");
        return localExtra;
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
    }

    public String getNetworkVersionCode() {
        return MaticooAds.getSDKVersion();
    }

    public String getNetworkVersionName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? TAG : this.mName;
    }
}

