/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.maticoo.sdk.ad.interact.InteractAd;
import com.maticoo.sdk.ad.interact.InteractAdListener;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interactive.TPInterActiveAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.InterstitialCallbackRouter;
import com.tradplus.ads.maticoo.MaticooInitManager;
import java.util.Map;

public class MaticooInteractive
extends TPInterActiveAdapter {
    private InteractAd mInteractAd;
    private String mPlacementId;
    private View interactiveAdView;
    private InterstitialCallbackRouter mCallbackRouter;
    private static final String TAG = "MaticooInteractive";
    private String mName;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.mCallbackRouter = InterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.mPlacementId, this.mLoadAdapterListener);
        this.mLoadAdapterListener = this.mCallbackRouter.getListener(this.mPlacementId);
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooInteractive.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
                if (MaticooInteractive.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooInteractive.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestAd(Context context) {
        this.mInteractAd = new InteractAd(context, this.mPlacementId);
        this.mInteractAd.setAdListener(new InteractAdListener(){

            public void onInteractAdReady(String placementId, View view) {
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdReady: ");
                if (MaticooInteractive.this.mLoadAdapterListener != null) {
                    MaticooInteractive.this.interactiveAdView = view;
                    MaticooInteractive.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onInteractAdFailed(String placementId, Error error) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInteractive.TAG, (String)("error\uff1a" + error.toString()));
                }
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdFailed: ");
                if (MaticooInteractive.this.mLoadAdapterListener != null) {
                    MaticooInteractive.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onInteractAdEntranceShowed(String placementId) {
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdEntranceShowed: ");
            }

            public void onInteractAdEntranceShowFailed(String placementId, Error error) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInteractive.TAG, (String)("error\uff1a" + error.toString()));
                }
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdEntranceShowFailed: ");
                if (MaticooInteractive.this.mShowListener != null) {
                    MaticooInteractive.this.mShowListener.onAdVideoError(tpError);
                }
            }

            public void onInteractAdEntranceClick(String placementId) {
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdEntranceClick: ");
                if (MaticooInteractive.this.mShowListener != null) {
                    MaticooInteractive.this.mShowListener.onAdClicked();
                }
            }

            public void onInteractAdFullScreenOpened(String placementId) {
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdFullScreenOpened: ");
                if (MaticooInteractive.this.mShowListener != null) {
                    MaticooInteractive.this.mShowListener.onAdShown();
                }
            }

            public void onInteractAdFullScreenOpenFailed(String placementId, Error error) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInteractive.TAG, (String)("error\uff1a" + error.toString()));
                }
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdFullScreenOpenFailed: ");
                if (MaticooInteractive.this.mShowListener != null) {
                    MaticooInteractive.this.mShowListener.onAdVideoError(tpError);
                }
            }

            public void onInteractAdFullScreenClose(String placementId) {
                Log.i((String)MaticooInteractive.TAG, (String)"onInteractAdFullScreenClose: ");
                if (MaticooInteractive.this.mShowListener != null) {
                    MaticooInteractive.this.mShowListener.onAdClosed();
                }
            }
        });
        this.mInteractAd.setLocalExtra(MaticooInitManager.getInstance().getParameters());
        this.mInteractAd.loadAd();
    }

    public View getInterActiveView() {
        return this.interactiveAdView;
    }

    public boolean isReady() {
        return true;
    }

    public void showAd() {
        if (this.mCallbackRouter != null && this.mShowListener != null) {
            this.mCallbackRouter.addShowListener(this.mPlacementId, this.mShowListener);
            this.mShowListener = this.mCallbackRouter.getShowListener(this.mPlacementId);
        }
    }

    public void clean() {
        if (this.mInteractAd != null) {
            this.mInteractAd.destroy();
            this.mInteractAd.setAdListener(null);
            this.mInteractAd = null;
        }
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }
}

