/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.maticoo.sdk.ad.interstitial.InterstitialAd;
import com.maticoo.sdk.ad.interstitial.InterstitialAdListener;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.InterstitialCallbackRouter;
import com.tradplus.ads.maticoo.MaticooInitManager;
import java.util.HashMap;
import java.util.Map;

public class MaticooInterstitial
extends TPInterstitialAdapter {
    private InterstitialCallbackRouter mCallbackRouter;
    private String mPlacementId;
    private String payload;
    private static final String TAG = "MaticooInterstitial";
    private String mName;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("Bidding-Payload"))) {
                this.payload = tpParams.get("Bidding-Payload");
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.mCallbackRouter = InterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.mPlacementId, this.mLoadAdapterListener);
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooInterstitial.this.requestAd();
            }

            public void onFailed(String code, String msg) {
                if (MaticooInterstitial.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestAd() {
        InterstitialAd.setAdListener((String)this.mPlacementId, (InterstitialAdListener)new InterstitialAdListener(){

            public void onAdLoadSuccess(String placementId) {
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPLoadAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadSuccess: ");
                        listener.loadAdapterLoaded(null);
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadSuccess but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadSuccess but placementId == null: ");
                }
            }

            public void onAdLoadFailed(String s, Error error) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInterstitial.TAG, (String)("errorCode\uff1a" + errorCode + ", errorMessage :" + errorMessage));
                }
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPLoadAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadFailed: ");
                        listener.loadAdapterLoadFailed(tpError);
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadFailed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdLoadFailed but placementId == null: ");
                }
            }

            public void onAdDisplayed(String placementId) {
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getShowListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayed: ");
                        listener.onAdShown();
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayed but placementId == null: ");
                }
            }

            public void onAdDisplayFailed(String placementId, Error error) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInterstitial.TAG, (String)("errorCode\uff1a" + errorCode + ", errorMessage :" + errorMessage));
                }
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getShowListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayFailed: ");
                        listener.onAdVideoError(tpError);
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayFailed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdDisplayFailed but placementId == null: ");
                }
            }

            public void onAdClicked(String placementId) {
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getShowListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdClicked: ");
                        listener.onAdVideoClicked();
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdClicked but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdClicked but placementId == null: ");
                }
            }

            public void onAdClosed(String placementId) {
                if (MaticooInterstitial.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitial.this.mCallbackRouter.getShowListener(MaticooInterstitial.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdClosed: ");
                        listener.onAdClosed();
                    } else {
                        Log.i((String)MaticooInterstitial.TAG, (String)"onAdClosed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitial.TAG, (String)"onAdClosed but placementId == null: ");
                }
            }
        });
        InterstitialAd.setLocalExtra((String)this.mPlacementId, MaticooInitManager.getInstance().getParameters());
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            InterstitialAd.loadAd((String)this.mPlacementId, (String)this.payload);
        } else {
            InterstitialAd.loadAd((String)this.mPlacementId);
        }
    }

    public void showAd() {
        if (this.mShowListener == null || this.mPlacementId == null) {
            return;
        }
        this.mCallbackRouter.addShowListener(this.mPlacementId, this.mShowListener);
        boolean ready = InterstitialAd.isReady((String)this.mPlacementId);
        Log.i((String)TAG, (String)("showAd isReady : " + ready));
        if (!ready) {
            TPShowAdapterListener showListener = this.mCallbackRouter.getShowListener(this.mPlacementId);
            if (showListener != null) {
                showListener.onAdVideoError(new TPError("5"));
            }
            return;
        }
        InterstitialAd.showAd((String)this.mPlacementId);
    }

    public void clean() {
        if (this.mPlacementId != null) {
            InterstitialAd.destroy((String)this.mPlacementId);
            if (this.mCallbackRouter != null) {
                this.mCallbackRouter.removeListeners(this.mPlacementId);
            }
        }
    }

    public boolean isReady() {
        return this.mPlacementId != null && InterstitialAd.isReady((String)this.mPlacementId);
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
        }
        MaticooInitManager.getInstance().setInitState("2");
        MaticooInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                long currentTimeMillis = System.currentTimeMillis();
                String biddingToken = MaticooAds.getBiddingToken((String)MaticooInterstitial.this.mPlacementId, (long)currentTimeMillis);
                Log.i((String)MaticooInterstitial.TAG, (String)("biddingToken: " + biddingToken));
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("time_stamp", currentTimeMillis);
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(biddingToken, hashMap);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

