/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.ad.video.RewardedVideoAd;
import com.maticoo.sdk.ad.video.RewardedVideoListener;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.InterstitialCallbackRouter;
import com.tradplus.ads.maticoo.MaticooInitManager;
import java.util.HashMap;
import java.util.Map;

public class MaticooInterstitialVideo
extends TPRewardAdapter {
    private String mPlacementId;
    private InterstitialCallbackRouter mCallbackRouter;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;
    private String payload;
    private static final String TAG = "MaticooRewardedVideo";
    private String mName;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("always_reward"))) {
                int rewardUser = Integer.parseInt(tpParams.get("always_reward"));
                boolean bl = this.alwaysRewardUser = rewardUser == 1;
            }
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("Bidding-Payload"))) {
                this.payload = tpParams.get("Bidding-Payload");
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.mCallbackRouter = InterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.mPlacementId, this.mLoadAdapterListener);
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooInterstitialVideo.this.requestAd();
            }

            public void onFailed(String code, String msg) {
                if (MaticooInterstitialVideo.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestAd() {
        RewardedVideoAd.setAdListener((String)this.mPlacementId, (RewardedVideoListener)new RewardedVideoListener(){

            public void onRewardedVideoAdLoadSuccess(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPLoadAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadSuccess: ");
                        listener.loadAdapterLoaded(null);
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadSuccess but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadSuccess but placementId == null: ");
                }
            }

            public void onRewardedVideoAdLoadFailed(String placementId, Error error) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)("errorCode\uff1a" + errorCode + ", errorMessage :" + errorMessage));
                }
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPLoadAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadFailed: ");
                        listener.loadAdapterLoadFailed(tpError);
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadFailed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdLoadFailed but placementId == null: ");
                }
            }

            public void onRewardedVideoAdShowed(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowed: ");
                        listener.onAdShown();
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowed but placementId == null: ");
                }
            }

            public void onRewardedVideoAdShowFailed(String placementId, Error error) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String errorMessage = error.getMessage();
                    int errorCode = error.getCode();
                    tpError.setErrorCode(errorCode + "");
                    tpError.setErrorMessage(errorMessage);
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)("errorCode\uff1a" + errorCode + ", errorMessage :" + errorMessage));
                }
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowFailed: ");
                        listener.onAdVideoError(tpError);
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowFailed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdShowFailed but placementId == null: ");
                }
            }

            public void onRewardedVideoAdStarted(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdStarted: ");
                        listener.onAdVideoStart();
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdStarted but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdStarted but placementId == null: ");
                }
            }

            public void onRewardedVideoAdCompleted(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdCompleted: ");
                        listener.onAdVideoEnd();
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdCompleted but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdCompleted but placementId == null: ");
                }
            }

            public void onRewardedVideoAdRewarded(String placementId) {
                Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdRewarded: ");
                MaticooInterstitialVideo.this.hasGrantedReward = true;
            }

            public void onRewardedVideoAdClicked(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClicked: ");
                        listener.onAdVideoClicked();
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClicked but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClicked but placementId == null: ");
                }
            }

            public void onRewardedVideoAdClosed(String placementId) {
                if (MaticooInterstitialVideo.this.mPlacementId != null) {
                    TPShowAdapterListener listener = MaticooInterstitialVideo.this.mCallbackRouter.getShowListener(MaticooInterstitialVideo.this.mPlacementId);
                    if (listener != null) {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClosed: ");
                        if (MaticooInterstitialVideo.this.hasGrantedReward || MaticooInterstitialVideo.this.alwaysRewardUser) {
                            listener.onReward();
                        }
                        listener.onAdClosed();
                    } else {
                        Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClosed but listen == null: ");
                    }
                } else {
                    Log.i((String)MaticooInterstitialVideo.TAG, (String)"onRewardedVideoAdClosed but placementId == null: ");
                }
            }
        });
        RewardedVideoAd.setLocalExtra((String)this.mPlacementId, MaticooInitManager.getInstance().getParameters());
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            RewardedVideoAd.loadAd((String)this.mPlacementId, (String)this.payload);
        } else {
            RewardedVideoAd.loadAd((String)this.mPlacementId);
        }
    }

    public void showAd() {
        if (this.mShowListener == null || this.mPlacementId == null) {
            return;
        }
        this.mCallbackRouter.addShowListener(this.mPlacementId, this.mShowListener);
        boolean ready = RewardedVideoAd.isReady((String)this.mPlacementId);
        if (!ready) {
            TPShowAdapterListener showListener = this.mCallbackRouter.getShowListener(this.mPlacementId);
            if (showListener != null) {
                showListener.onAdVideoError(new TPError("5"));
            }
            return;
        }
        RewardedVideoAd.showAd((String)this.mPlacementId);
    }

    public void clean() {
        if (this.mPlacementId != null) {
            RewardedVideoAd.destroy((String)this.mPlacementId);
            if (this.mCallbackRouter != null) {
                this.mCallbackRouter.removeListeners(this.mPlacementId);
            }
        }
    }

    public boolean isReady() {
        return this.mPlacementId != null && RewardedVideoAd.isReady((String)this.mPlacementId);
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
        }
        MaticooInitManager.getInstance().setInitState("2");
        MaticooInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                long currentTimeMillis = System.currentTimeMillis();
                String biddingToken = MaticooAds.getBiddingToken((String)MaticooInterstitialVideo.this.mPlacementId, (long)currentTimeMillis);
                Log.i((String)MaticooInterstitialVideo.TAG, (String)("biddingToken: " + biddingToken));
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("time_stamp", currentTimeMillis);
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(biddingToken, hashMap);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

