/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.maticoo.sdk.ad.nativead.AdLoader;
import com.maticoo.sdk.ad.nativead.NativeAd;
import com.maticoo.sdk.ad.nativead.NativeAdListener;
import com.maticoo.sdk.ad.nativead.NativeAdOptions;
import com.maticoo.sdk.ad.utils.AdSize;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.ad.video.VideoAdListener;
import com.maticoo.sdk.ad.video.VideoOptions;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.MaticooInitManager;
import com.tradplus.ads.maticoo.MaticooNativeAd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MaticooNative
extends TPNativeAdapter {
    private static final String TAG = "MaticooNative";
    private String mPlacementId;
    private String payload;
    private boolean mNeedDownloadImg = false;
    private boolean isVideoMute = true;
    private int mIsTemplateRending;
    private int adChoicesPosition = 3;
    private MaticooNativeAd mMaticooNativeAd;
    private String mName;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            String videoMute;
            String template;
            this.mPlacementId = tpParams.get("placementId");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("Bidding-Payload"))) {
                this.payload = tpParams.get("Bidding-Payload");
            }
            if (!TextUtils.isEmpty((CharSequence)(template = tpParams.get("is_template_rendering")))) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
            if (!TextUtils.isEmpty((CharSequence)(videoMute = tpParams.get("video_mute"))) && !"1".equals(videoMute)) {
                this.isVideoMute = false;
                Log.i((String)TAG, (String)("videoMute: " + this.isVideoMute));
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams != null && userParams.size() > 0) {
            String downLoadImg;
            if (userParams.containsKey("need_down_load_img") && (downLoadImg = (String)userParams.get("need_down_load_img")).equals("true")) {
                this.mNeedDownloadImg = true;
            }
            if (userParams.containsKey("adchoices_position")) {
                this.adChoicesPosition = (Integer)userParams.get("adchoices_position");
                Log.i((String)TAG, (String)("adChoicesPosition: " + this.adChoicesPosition));
            }
        }
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooNative.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
                if (MaticooNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestAd(Context context) {
        NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
        if (this.mIsTemplateRending != 1) {
            nativeAdOptionsBuilder.setAdSize(new AdSize(320, 640));
        }
        nativeAdOptionsBuilder.setAdChoicesPlacement(this.adChoicesPostition(this.adChoicesPosition));
        ArrayList<NativeAdOptions.AdElement> elements = new ArrayList<NativeAdOptions.AdElement>();
        elements.add(NativeAdOptions.AdElement.TITLE);
        elements.add(NativeAdOptions.AdElement.CALL_TO_ACTION);
        elements.add(NativeAdOptions.AdElement.DESCRIBE);
        elements.add(NativeAdOptions.AdElement.ICON);
        nativeAdOptionsBuilder.setRequiredElements(elements);
        nativeAdOptionsBuilder.setLocalExtra(MaticooInitManager.getInstance().getParameters());
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            nativeAdOptionsBuilder.setRequestId(this.payload);
        }
        nativeAdOptionsBuilder.setLoadListener(new NativeAdListener(){

            public void onAdLoadSuccess(String placementId, NativeAd nativeAd) {
                if (nativeAd == null) {
                    if (MaticooNative.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network failed to provide an ad.");
                        tpError.setErrorMessage("nativeAd == null");
                        MaticooNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                    return;
                }
                if (MaticooNative.this.mIsTemplateRending == 2) {
                    MaticooNative.this.mMaticooNativeAd = new MaticooNativeAd(nativeAd, 0);
                    MaticooNative.this.downloadAndCallback(MaticooNative.this.mMaticooNativeAd, MaticooNative.this.mNeedDownloadImg);
                } else {
                    View templateView = nativeAd.getTemplateView();
                    if (templateView == null) {
                        if (MaticooNative.this.mLoadAdapterListener != null) {
                            TPError tpError = new TPError("Third-party network failed to provide an ad.");
                            tpError.setErrorMessage("templateView == null");
                            MaticooNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                        }
                        return;
                    }
                    MaticooNative.this.mMaticooNativeAd = new MaticooNativeAd(templateView, 1);
                    if (MaticooNative.this.mLoadAdapterListener != null) {
                        MaticooNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)MaticooNative.this.mMaticooNativeAd);
                    }
                }
                Log.i((String)MaticooNative.TAG, (String)"onAdLoadSuccess: ");
            }

            public void onAdLoadFailed(String placementId, Error error) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String message = error.getMessage();
                    int code = error.getCode();
                    tpError.setErrorMessage(message);
                    tpError.setErrorCode(code + "");
                    Log.i((String)MaticooNative.TAG, (String)("onAdLoadFailed: code :" + code + ", message :" + message));
                }
                Log.i((String)MaticooNative.TAG, (String)"onAdLoadFailed: ");
                if (MaticooNative.this.mLoadAdapterListener != null) {
                    MaticooNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAdDisplayed(String placementId) {
                Log.i((String)MaticooNative.TAG, (String)"onAdDisplayed: ");
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    MaticooNative.this.mMaticooNativeAd.onAdShown();
                }
            }

            public void onAdDisplayFailed(String placementId, Error error) {
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                    if (error != null) {
                        String message = error.getMessage();
                        int code = error.getCode();
                        tpError.setErrorMessage(message);
                        tpError.setErrorCode(code + "");
                        Log.i((String)MaticooNative.TAG, (String)("onAdDisplayFailed: code :" + code + ", message :" + message));
                    }
                    Log.i((String)MaticooNative.TAG, (String)"onAdDisplayFailed: ");
                    MaticooNative.this.mMaticooNativeAd.onAdVideoError(tpError);
                }
            }

            public void onAdClicked(String placementId) {
                Log.i((String)MaticooNative.TAG, (String)"onAdClicked: ");
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    MaticooNative.this.mMaticooNativeAd.onAdClicked();
                }
            }

            public void onAdClosed(String placementId) {
                Log.i((String)MaticooNative.TAG, (String)"onAdClosed: ");
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    MaticooNative.this.mMaticooNativeAd.onAdClosed();
                }
            }
        });
        if (this.mIsTemplateRending == 1) {
            nativeAdOptionsBuilder.setAdTemplate(NativeAdOptions.AdTemplate.MEDIUM);
        }
        VideoOptions.Builder videoOptionsBuilder = new VideoOptions.Builder();
        videoOptionsBuilder.setStartMuted(this.isVideoMute);
        videoOptionsBuilder.setVideoAdListener(new VideoAdListener(){

            public void onVideoStarted(String s) {
                Log.i((String)MaticooNative.TAG, (String)"onVideoStarted: ");
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    MaticooNative.this.mMaticooNativeAd.onAdVideoStart();
                }
            }

            public void onVideoCompleted(String s) {
                Log.i((String)MaticooNative.TAG, (String)"onVideoCompleted: ");
                if (MaticooNative.this.mMaticooNativeAd != null) {
                    MaticooNative.this.mMaticooNativeAd.onAdVideoEnd();
                }
            }
        });
        AdLoader adLoader = new AdLoader.Builder(context, this.mPlacementId).setNativeAdOptions(nativeAdOptionsBuilder.build()).setVideoOptions(videoOptionsBuilder.build()).build();
        Log.i((String)TAG, (String)"adLoader loadAd: ");
        adLoader.loadAd();
    }

    public void clean() {
    }

    private int adChoicesPostition(int postion) {
        if (postion == 1) {
            return 1;
        }
        if (postion == 2) {
            return 2;
        }
        if (postion == 3) {
            return 3;
        }
        return 3;
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
        }
        MaticooInitManager.getInstance().setInitState("2");
        MaticooInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                long currentTimeMillis = System.currentTimeMillis();
                String biddingToken = MaticooAds.getBiddingToken((String)MaticooNative.this.mPlacementId, (long)currentTimeMillis);
                Log.i((String)MaticooNative.TAG, (String)("biddingToken: " + biddingToken));
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("time_stamp", currentTimeMillis);
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(biddingToken, hashMap);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

