/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.maticoo.sdk.ad.nativead.NativeAd;
import com.maticoo.sdk.ad.nativead.view.MediaView;
import com.maticoo.sdk.ad.nativead.view.NativeAdView;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdView;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import java.util.ArrayList;
import java.util.List;

public class MaticooNativeAd
extends TPBaseAd {
    private static final String TAG = "MaticooNative";
    private NativeAd mMaticooNativeAd;
    private NativeAdView nativeAdContainer;
    private TPNativeAdView mTPNativeAdView;
    private MediaView mediaView;
    private int template;
    private View templateView;
    private Application.ActivityLifecycleCallbacks callbacks;

    public MaticooNativeAd(NativeAd nativeAd, int renderType) {
        this.mMaticooNativeAd = nativeAd;
        this.template = renderType;
        this.initViewData(nativeAd);
    }

    public MaticooNativeAd(View view, int renderType) {
        this.template = renderType;
        this.templateView = view;
    }

    private void initViewData(NativeAd nativeAd) {
        NativeAd.ImageContent icon;
        String url;
        String headline;
        String callToAction;
        this.mTPNativeAdView = new TPNativeAdView();
        String body = nativeAd.getBody();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            this.mTPNativeAdView.setSubTitle(body);
        }
        if (!TextUtils.isEmpty((CharSequence)(callToAction = nativeAd.getCallToAction()))) {
            this.mTPNativeAdView.setCallToAction(callToAction);
        }
        if (!TextUtils.isEmpty((CharSequence)(headline = nativeAd.getHeadline()))) {
            this.mTPNativeAdView.setTitle(headline);
        }
        if (!TextUtils.isEmpty((CharSequence)(url = (icon = nativeAd.getIcon()).getUrl()))) {
            this.mTPNativeAdView.setIconImageUrl(url);
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        NativeAd.MediaContent mediaContent = nativeAd.getMediaContent();
        this.mediaView = new MediaView(context);
        this.mediaView.setMediaContent(mediaContent);
        this.mTPNativeAdView.setMediaView((View)this.mediaView);
        this.nativeAdContainer = new NativeAdView(context);
        this.nativeAdContainer.setNativeAd(nativeAd);
    }

    public Object getNetworkObj() {
        if (this.template == 0) {
            return this.mMaticooNativeAd;
        }
        return this.templateView;
    }

    public ArrayList<String> getDownloadImgUrls() {
        if (this.mTPNativeAdView != null) {
            String mainImageUrl;
            this.downloadImgUrls.clear();
            String iconImageUrl = this.mTPNativeAdView.getIconImageUrl();
            if (!TextUtils.isEmpty((CharSequence)iconImageUrl)) {
                this.downloadImgUrls.add(iconImageUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)(mainImageUrl = this.mTPNativeAdView.getMainImageUrl()))) {
                this.downloadImgUrls.add(mainImageUrl);
            }
        }
        return super.getDownloadImgUrls();
    }

    public void registerClickView(ViewGroup viewGroup, ArrayList<View> clickViews) {
        if (this.mMaticooNativeAd != null && this.mediaView != null) {
            this.mMaticooNativeAd.registerViewForInteraction((View)this.nativeAdContainer, this.mediaView, clickViews);
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context != null) {
                this.callbacks = new Application.ActivityLifecycleCallbacks(){

                    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    }

                    public void onActivityStarted(Activity activity) {
                    }

                    public void onActivityResumed(Activity activity) {
                        Log.i((String)MaticooNativeAd.TAG, (String)"onActivityResumed: ");
                        if (MaticooNativeAd.this.mediaView != null) {
                            MaticooNativeAd.this.mediaView.resume();
                        }
                    }

                    public void onActivityPaused(Activity activity) {
                        Log.i((String)MaticooNativeAd.TAG, (String)"onActivityPaused: ");
                        if (MaticooNativeAd.this.mediaView != null) {
                            MaticooNativeAd.this.mediaView.pause();
                        }
                    }

                    public void onActivityStopped(Activity activity) {
                    }

                    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                    }

                    public void onActivityDestroyed(Activity activity) {
                    }
                };
                ((Application)context).registerActivityLifecycleCallbacks(this.callbacks);
            }
        }
    }

    public void onAdShown() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdShown();
        }
    }

    public void onAdClosed() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdClosed();
        }
    }

    public void onAdVideoError(TPError tpError) {
        if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(tpError);
        }
    }

    public void onAdClicked() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdClicked();
        }
    }

    public void onAdVideoStart() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdVideoStart();
        }
    }

    public void onAdVideoEnd() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdVideoEnd();
        }
    }

    public TPNativeAdView getTPNativeView() {
        return this.mTPNativeAdView;
    }

    public int getNativeAdType() {
        if (this.template == 0) {
            return 0;
        }
        return 1;
    }

    public View getRenderView() {
        return this.templateView;
    }

    public List<View> getMediaViews() {
        return null;
    }

    public ViewGroup getCustomAdContainer() {
        if (this.template == 0) {
            return this.nativeAdContainer;
        }
        return null;
    }

    public void clean() {
        Context context;
        Log.i((String)TAG, (String)"clean : ");
        if (this.callbacks != null && (context = GlobalTradPlus.getInstance().getContext()) != null) {
            ((Application)context).unregisterActivityLifecycleCallbacks(this.callbacks);
        }
    }
}

