/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.maticoo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.maticoo.sdk.ad.splash.SplashAd;
import com.maticoo.sdk.ad.splash.SplashAdListener;
import com.maticoo.sdk.ad.utils.error.Error;
import com.maticoo.sdk.core.MaticooAds;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.maticoo.MaticooInitManager;
import java.util.HashMap;
import java.util.Map;

public class MaticooSplash
extends TPSplashAdapter {
    private static final String TAG = "MaticooSplash";
    private String mPlacementId;
    private String payload;
    private String mName;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("Bidding-Payload"))) {
                this.payload = tpParams.get("Bidding-Payload");
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        MaticooInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                MaticooSplash.this.requestAd();
            }

            public void onFailed(String code, String msg) {
                if (MaticooSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    MaticooSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    public void requestAd() {
        SplashAd.setAdListener((String)this.mPlacementId, (SplashAdListener)new SplashAdListener(){

            public void onAdLoadSuccess(String s) {
                Log.i((String)MaticooSplash.TAG, (String)"onAdLoadSuccess: ");
                if (MaticooSplash.this.mLoadAdapterListener != null) {
                    MaticooSplash.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onAdLoadFailed(String s, Error error) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String message = error.getMessage();
                    int code = error.getCode();
                    tpError.setErrorMessage(message);
                    tpError.setErrorCode(code + "");
                    Log.i((String)MaticooSplash.TAG, (String)("onAdLoadFailed: code :" + code + ", message :" + message));
                }
                Log.i((String)MaticooSplash.TAG, (String)"onAdLoadFailed: ");
                if (MaticooSplash.this.mLoadAdapterListener != null) {
                    MaticooSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }

            public void onAdDisplayed(String s) {
                Log.i((String)MaticooSplash.TAG, (String)"onAdDisplayed: ");
                if (MaticooSplash.this.mShowListener != null) {
                    MaticooSplash.this.mShowListener.onAdShown();
                }
            }

            public void onAdDisplayFailed(String s, Error error) {
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String message = error.getMessage();
                    int code = error.getCode();
                    tpError.setErrorMessage(message);
                    tpError.setErrorCode(code + "");
                    Log.i((String)MaticooSplash.TAG, (String)("onAdDisplayFailed: code :" + code + ", message :" + message));
                }
                Log.i((String)MaticooSplash.TAG, (String)"onAdDisplayFailed: ");
                if (MaticooSplash.this.mShowListener != null) {
                    MaticooSplash.this.mShowListener.onAdVideoError(tpError);
                }
            }

            public void onAdClicked(String s) {
                Log.i((String)MaticooSplash.TAG, (String)"onAdClicked: ");
                if (MaticooSplash.this.mShowListener != null) {
                    MaticooSplash.this.mShowListener.onAdClicked();
                }
            }

            public void onAdClosed(String s) {
                Log.i((String)MaticooSplash.TAG, (String)"onAdClosed: ");
                if (MaticooSplash.this.mShowListener != null) {
                    MaticooSplash.this.mShowListener.onAdClosed();
                }
            }
        });
        SplashAd.setLocalExtra((String)this.mPlacementId, MaticooInitManager.getInstance().getParameters());
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            SplashAd.loadAd((String)this.mPlacementId, (String)this.payload);
        } else {
            SplashAd.loadAd((String)this.mPlacementId);
        }
    }

    public void clean() {
    }

    public boolean isReady() {
        return this.mPlacementId != null && SplashAd.isReady((String)this.mPlacementId) && !this.isAdsTimeOut();
    }

    public void showAd() {
        TPError tpErrorShow = new TPError("Didn't find valid adv.Show Failed");
        if (this.mPlacementId == null) {
            tpErrorShow.setErrorMessage("showFailed placement == null");
            this.mShowListener.onAdVideoError(tpErrorShow);
            return;
        }
        if (!SplashAd.isReady((String)this.mPlacementId)) {
            tpErrorShow.setErrorMessage("Not Ready");
            this.mShowListener.onAdVideoError(tpErrorShow);
            return;
        }
        SplashAd.showAd((String)this.mPlacementId);
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "zMaticoo" : this.mName;
    }

    public String getNetworkVersion() {
        return MaticooAds.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mPlacementId = tpParams.get("placementId");
        }
        MaticooInitManager.getInstance().setInitState("2");
        MaticooInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                long currentTimeMillis = System.currentTimeMillis();
                String biddingToken = MaticooAds.getBiddingToken((String)MaticooSplash.this.mPlacementId, (long)currentTimeMillis);
                Log.i((String)MaticooSplash.TAG, (String)("biddingToken: " + biddingToken));
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("time_stamp", currentTimeMillis);
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(biddingToken, hashMap);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

