/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.open.DownloadListener;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.banner.TPBanner;
import com.tradplus.ads.unity.NetworkInfo;
import com.tradplus.ads.unity.TradplusUnityPlugin;
import java.util.HashMap;

public class BannerUnityPlugin
extends TradplusUnityPlugin
implements DownloadListener {
    private RelativeLayout mLayout;
    private TPBanner tpBanner;
    private String mAdSceneId;
    private int mHeight;
    private int mWidth;
    private HashMap<String, Object> hashMap = new HashMap();
    private static final String TAG = "BannerUnityPlugin";
    private BannerAdListener mBannerAdListener = new BannerAdListener(){

        @Override
        public final void onAdClicked(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdClicked: ");
            TradplusUnityPlugin.UnityEvent.onAdClicked.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdImpression(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdImpression: ");
            TradplusUnityPlugin.UnityEvent.onAdImpression.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdLoaded(TPAdInfo tPAdInfo) {
            TradplusUnityPlugin.UnityEvent.onAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(tPAdInfo.height));
            Log.i((String)BannerUnityPlugin.TAG, (String)("onAdLoaded: mWidth \uff1a " + BannerUnityPlugin.this.mWidth + " \uff0c tpAdInfo.adViewWidth \uff1a" + tPAdInfo.adViewWidth));
            if (tPAdInfo.adViewWidth == 0) {
                if (tPAdInfo.width == 0) {
                    BannerUnityPlugin.this.mWidth = 320;
                } else {
                    BannerUnityPlugin.this.mWidth = tPAdInfo.width;
                }
            } else {
                BannerUnityPlugin.this.mWidth = tPAdInfo.adViewWidth;
            }
            if (tPAdInfo.adViewHeight == 0) {
                if (tPAdInfo.height == 0) {
                    BannerUnityPlugin.this.mHeight = 50;
                } else {
                    BannerUnityPlugin.this.mHeight = tPAdInfo.height;
                }
            } else {
                BannerUnityPlugin.this.mHeight = tPAdInfo.adViewHeight;
            }
            Log.i((String)BannerUnityPlugin.TAG, (String)("onAdLoaded: width :" + BannerUnityPlugin.this.mHeight + " , height : " + tPAdInfo.height));
            tPAdInfo = (RelativeLayout.LayoutParams)BannerUnityPlugin.this.tpBanner.getLayoutParams();
            float f2 = ScreenUtil.getScreenDensity((Activity)TradplusUnityPlugin.getActivity());
            tPAdInfo.width = (int)((float)BannerUnityPlugin.this.mWidth * f2);
            tPAdInfo.height = (int)((float)BannerUnityPlugin.this.mHeight * f2);
            BannerUnityPlugin.this.tpBanner.setLayoutParams((ViewGroup.LayoutParams)tPAdInfo);
        }

        @Override
        public final void onAdLoadFailed(TPAdError tPAdError) {
            Log.i((String)BannerUnityPlugin.TAG, (String)("onAdLoadFailed: msg : " + tPAdError.getErrorMsg()));
            if (BannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onAdLoadFailed.Emit(BannerUnityPlugin.this.mAdUnitId, tPAdError.getErrorMsg());
        }

        @Override
        public final void onAdClosed(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdClosed: ");
            TradplusUnityPlugin.UnityEvent.onAdClosed.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdShowFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdShowFailed: ");
            TradplusUnityPlugin.UnityEvent.onAdShowFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }
    };
    private LoadAdEveryLayerListener mLoadAdEveryLayerListener = new LoadAdEveryLayerListener(){

        @Override
        public final void onAdAllLoaded(boolean bl) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdAllLoaded: isSuccess : ".concat(String.valueOf(bl)));
            if (BannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onAdAllLoaded.Emit(String.valueOf(bl), BannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)("oneLayerLoadFailed: msg : " + tPAdError.getErrorMsg()));
            TradplusUnityPlugin.UnityEvent.oneLayerLoadFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }

        @Override
        public final void oneLayerLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"oneLayerLoaded: ");
            TradplusUnityPlugin.UnityEvent.oneLayerLoaded.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdStartLoad(String string) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdStartLoad: ");
            TradplusUnityPlugin.UnityEvent.onAdStartLoad.Emit(string);
        }

        @Override
        public final void oneLayerLoadStart(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"oneLayerLoadStart: ");
            TradplusUnityPlugin.UnityEvent.oneLayerStartLoad.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdIsLoading(String string) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdIsLoading Data : ".concat(String.valueOf(string)));
        }

        @Override
        public final void onBiddingStart(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onBiddingStart: ");
            TradplusUnityPlugin.UnityEvent.onBiddingStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingEnd(TPAdInfo tPAdInfo, TPAdError tPAdError) {
            Log.i((String)BannerUnityPlugin.TAG, (String)("onBiddingEnd: adError :" + tPAdError.getErrorCode()));
            TradplusUnityPlugin.UnityEvent.onBiddingEnd.Emit(JSON.toJSONString((Object)tPAdInfo), "" + tPAdError.getErrorCode());
        }
    };

    public BannerUnityPlugin(String string) {
        super(string);
    }

    public void createBanner(int n) {
        this.createBanner(n, "");
    }

    public void createBanner(final int n, String string) {
        if (this.tpBanner == null) {
            this.tpBanner = new TPBanner((Context)TradplusUnityPlugin.getActivity());
        }
        this.tpBanner.setAdListener(this.mBannerAdListener);
        this.tpBanner.setAllAdLoadListener(this.mLoadAdEveryLayerListener);
        this.tpBanner.setDownloadListener(this);
        if (!this.hashMap.isEmpty()) {
            this.tpBanner.setCustomParams(this.hashMap);
        }
        this.tpBanner.loadAd(this.mAdUnitId, TextUtils.isEmpty((CharSequence)string) ? "" : string, 0.0f);
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                BannerUnityPlugin.this.mLayout = ScreenUtil.prepLayout((int)n, (RelativeLayout)BannerUnityPlugin.this.mLayout, (Context)TradplusUnityPlugin.getActivity());
                TradplusUnityPlugin.getActivity().addContentView((View)BannerUnityPlugin.this.mLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                BannerUnityPlugin.this.mLayout.removeAllViews();
                BannerUnityPlugin.this.mLayout.addView((View)BannerUnityPlugin.this.tpBanner);
                BannerUnityPlugin.this.mLayout.setVisibility(0);
            }
        });
    }

    public void setCustomParams(String object) {
        Log.i((String)TAG, (String)"setCustomParams: map".concat(String.valueOf(object)));
        try {
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.hashMap = (HashMap)JSON.parseObject((String)object, HashMap.class);
                if (this.hashMap.containsKey("width")) {
                    this.mWidth = (Integer)this.hashMap.get("width");
                    Log.i((String)TAG, (String)("local width : " + this.mWidth));
                }
                if (this.hashMap.containsKey("height")) {
                    this.mHeight = (Integer)this.hashMap.get("height");
                    Log.i((String)TAG, (String)("local height : " + this.mHeight));
                }
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            Log.e((String)"UnityPlugin", (String)("Exception: " + ((Throwable)object).getLocalizedMessage()));
            return;
        }
    }

    public void hideBanner(final boolean bl) {
        if (this.tpBanner == null) {
            return;
        }
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (bl) {
                    Log.d((String)"refreshTime", (String)"Banner GONE");
                    BannerUnityPlugin.this.tpBanner.setVisibility(8);
                    return;
                }
                Log.d((String)"refreshTime", (String)"Banner VISIBLE");
                BannerUnityPlugin.this.tpBanner.setVisibility(0);
            }
        });
    }

    public void destroyBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null || BannerUnityPlugin.this.mLayout == null) {
                    return;
                }
                BannerUnityPlugin.this.mLayout.removeAllViews();
                BannerUnityPlugin.this.mLayout.setVisibility(8);
                BannerUnityPlugin.this.tpBanner.onDestroy();
            }
        });
    }

    public void reloadBannerAd() {
    }

    public void entryAdScenario(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mAdSceneId = string;
        }
        if (this.tpBanner != null) {
            this.tpBanner.entryAdScenario(string);
        }
    }

    @Override
    public void onDownloadStart(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onDownloadStart.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadUpdate(TPAdInfo tPAdInfo, long l, long l2, String string, String string2, int n) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2, n);
        TradplusUnityPlugin.UnityEvent.onDownloadUpdate.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadPause(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onDownloadPause.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadFinish(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onDownloadFinish.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadFail(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onDownloadFail.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onInstalled(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onInstalled.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }
}

