/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.banner.TPBanner;
import com.tradplus.ads.unity.TradplusUnityPlugin;

public class BannerUnityPlugin
extends TradplusUnityPlugin {
    private RelativeLayout mLayout;
    private TPBanner tpBanner;
    private static final String TAG = "BannerUnity";

    public BannerUnityPlugin(String string) {
        super(string);
    }

    public void createBanner(final int n) {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null) {
                    BannerUnityPlugin.this.tpBanner = new TPBanner((Context)TradplusUnityPlugin.getActivity());
                }
                BannerUnityPlugin.this.tpBanner.setAdListener(new BannerAdListener(){

                    @Override
                    public final void onAdClicked(TPAdInfo tPAdInfo) {
                        TradplusUnityPlugin.UnityEvent.AdClicked.Emit(tPAdInfo.adUnitId, tPAdInfo.adSourceName, tPAdInfo.adSourceId, tPAdInfo.isoCode);
                    }

                    @Override
                    public final void onAdImpression(TPAdInfo tPAdInfo) {
                        TradplusUnityPlugin.UnityEvent.AdExpanded.Emit(tPAdInfo.adUnitId);
                    }

                    @Override
                    public final void onAdLoaded(TPAdInfo tPAdInfo) {
                        Log.i((String)BannerUnityPlugin.TAG, (String)"onAdLoaded: ");
                        TradplusUnityPlugin.UnityEvent.AdLoaded.Emit(tPAdInfo.adUnitId, String.valueOf(tPAdInfo.height), tPAdInfo.adSourceName, tPAdInfo.adSourceId, tPAdInfo.isoCode, "" + tPAdInfo.loadTime);
                        int n = tPAdInfo.width;
                        int n2 = tPAdInfo.height;
                        Log.i((String)BannerUnityPlugin.TAG, (String)"height :".concat(String.valueOf(n2)));
                        if (n2 < 50) {
                            n2 = 50;
                            n = 320;
                        }
                        float f2 = ScreenUtil.getScreenDensity((Activity)TradplusUnityPlugin.getActivity());
                        if (BannerUnityPlugin.this.tpBanner != null) {
                            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)BannerUnityPlugin.this.tpBanner.getLayoutParams();
                            ((RelativeLayout.LayoutParams)BannerUnityPlugin.this.tpBanner.getLayoutParams()).width = (int)((float)n * f2);
                            layoutParams.height = (int)((float)n2 * f2);
                            Log.i((String)BannerUnityPlugin.TAG, (String)("onAdViewLoaded:  params.height : " + layoutParams.height + ", params.width :" + layoutParams.width));
                            BannerUnityPlugin.this.tpBanner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }

                    @Override
                    public final void onAdLoadFailed(TPAdError tPAdError) {
                        TradplusUnityPlugin.UnityEvent.AdFailed.Emit(" ", tPAdError.getErrorMsg(), " ", " ", " ", " ");
                    }

                    @Override
                    public final void onAdClosed(TPAdInfo tPAdInfo) {
                    }
                });
                BannerUnityPlugin.this.tpBanner.loadAd(BannerUnityPlugin.this.mAdUnitId);
                BannerUnityPlugin.this.mLayout = ScreenUtil.prepLayout((int)n, (RelativeLayout)BannerUnityPlugin.this.mLayout, (Context)TradplusUnityPlugin.getActivity());
                TradplusUnityPlugin.getActivity().addContentView((View)BannerUnityPlugin.this.mLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                BannerUnityPlugin.this.mLayout.addView((View)BannerUnityPlugin.this.tpBanner);
                BannerUnityPlugin.this.mLayout.setVisibility(0);
            }
        });
    }

    public void hideBanner(final boolean bl) {
        if (this.tpBanner == null) {
            return;
        }
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (bl) {
                    Log.d((String)"refreshTime", (String)"Banner GONE");
                    BannerUnityPlugin.this.tpBanner.setVisibility(8);
                    return;
                }
                Log.d((String)"refreshTime", (String)"Banner VISIBLE");
                BannerUnityPlugin.this.tpBanner.setVisibility(0);
            }
        });
    }

    public void refreshBanner(String string) {
        this.refreshBanner(string, null);
    }

    public void refreshBanner(String string, @Nullable String string2) {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null) {
                    return;
                }
            }
        });
    }

    public void destroyBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null || BannerUnityPlugin.this.mLayout == null) {
                    return;
                }
                BannerUnityPlugin.this.mLayout.removeAllViews();
                BannerUnityPlugin.this.mLayout.setVisibility(8);
                BannerUnityPlugin.this.tpBanner = null;
            }
        });
    }

    public void setAutorefreshEnabled(boolean bl) {
    }

    public void forceRefresh() {
    }

    public void entryAdScenario() {
    }
}

