/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.nativead.TPNativeBanner;
import com.tradplus.ads.unity.TradplusUnityPlugin;

public class NativeBannerUnityPlugin
extends TradplusUnityPlugin {
    private TPNativeBanner mTPNativeBanner;
    private RelativeLayout mRelativeLayout;
    private String mAdSceneId;
    private static final String TAG = "NativeBannerPlugin";
    BannerAdListener mBannerAdListener = new BannerAdListener(){

        @Override
        public final void onAdClicked(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClicked: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClicked.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdImpression(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdImpression: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdImpression.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdLoaded: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(tPAdInfo.height));
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"height :50");
            float f2 = ScreenUtil.getScreenDensity((Activity)TradplusUnityPlugin.getActivity());
            if (NativeBannerUnityPlugin.this.mTPNativeBanner != null) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)NativeBannerUnityPlugin.this.mTPNativeBanner.getLayoutParams();
                ((RelativeLayout.LayoutParams)NativeBannerUnityPlugin.this.mTPNativeBanner.getLayoutParams()).width = (int)(320.0f * f2);
                Log.i((String)NativeBannerUnityPlugin.TAG, (String)("onAdViewLoaded:  params.height : " + layoutParams.height + ", params.width :" + layoutParams.width));
                NativeBannerUnityPlugin.this.mTPNativeBanner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            NativeBannerUnityPlugin.this.mTPNativeBanner.showAd();
        }

        @Override
        public final void onAdLoadFailed(TPAdError tPAdError) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("onAdLoadFailed: msg : " + tPAdError.getErrorMsg()));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoadFailed.Emit(NativeBannerUnityPlugin.this.mAdUnitId, tPAdError.getErrorMsg());
        }

        @Override
        public final void onAdClosed(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClosed: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClosed.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };
    LoadAdEveryLayerListener mLoadAdEveryLayerListener = new LoadAdEveryLayerListener(){

        @Override
        public final void onAdAllLoaded(boolean bl) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdAllLoaded: isSuccess : ".concat(String.valueOf(bl)));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdAllLoaded.Emit(String.valueOf(bl), NativeBannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("oneLayerLoadFailed: msg : " + tPAdError.getErrorMsg()));
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoadFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }

        @Override
        public final void oneLayerLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"oneLayerLoaded: ");
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoaded.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onLoadAdStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onLoadAdStart: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerLoadAdStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onBiddingStart: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingEnd(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onBiddingEnd: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingEnd.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };

    public NativeBannerUnityPlugin(String string) {
        super(string);
    }

    public void createNativeBanner(final int n) {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null) {
                    NativeBannerUnityPlugin.this.mTPNativeBanner = new TPNativeBanner((Context)TradplusUnityPlugin.getActivity());
                }
                NativeBannerUnityPlugin.this.mTPNativeBanner.setAdListener(NativeBannerUnityPlugin.this.mBannerAdListener);
                NativeBannerUnityPlugin.this.mTPNativeBanner.setAllAdLoadListener(NativeBannerUnityPlugin.this.mLoadAdEveryLayerListener);
                if (NativeBannerUnityPlugin.this.mTPNativeBanner != null && NativeBannerUnityPlugin.this.mTPNativeBanner.getParent() != null) {
                    ((ViewGroup)NativeBannerUnityPlugin.this.mTPNativeBanner.getParent()).removeView((View)NativeBannerUnityPlugin.this.mTPNativeBanner);
                }
                NativeBannerUnityPlugin.this.mTPNativeBanner.loadAd(NativeBannerUnityPlugin.this.mAdUnitId, TextUtils.isEmpty((CharSequence)NativeBannerUnityPlugin.this.mAdSceneId) ? "" : NativeBannerUnityPlugin.this.mAdSceneId);
                NativeBannerUnityPlugin.this.mTPNativeBanner.closeAutoShow();
                NativeBannerUnityPlugin.this.mRelativeLayout = ScreenUtil.prepLayout((int)n, (RelativeLayout)NativeBannerUnityPlugin.this.mRelativeLayout, (Context)TradplusUnityPlugin.getActivity());
                TradplusUnityPlugin.getActivity().addContentView((View)NativeBannerUnityPlugin.this.mRelativeLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                NativeBannerUnityPlugin.this.mRelativeLayout.setGravity(0);
                NativeBannerUnityPlugin.this.mRelativeLayout.addView((View)NativeBannerUnityPlugin.this.mTPNativeBanner);
            }
        });
    }

    public void destroyNativeBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null || NativeBannerUnityPlugin.this.mRelativeLayout == null) {
                    return;
                }
                NativeBannerUnityPlugin.this.mRelativeLayout.removeAllViews();
                NativeBannerUnityPlugin.this.mRelativeLayout.setVisibility(8);
                NativeBannerUnityPlugin.this.mTPNativeBanner.onDestroy();
            }
        });
    }

    public void entryAdScenario(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.mAdSceneId = string;
        }
        if (this.mTPNativeBanner != null) {
            this.mTPNativeBanner.entryAdScenario(string);
        }
    }
}

