/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.banner.TPBanner;
import com.tradplus.ads.unity.TradplusUnityPlugin;

public class BannerUnityPlugin
extends TradplusUnityPlugin {
    private RelativeLayout mLayout;
    private TPBanner tpBanner;
    private String mAdSceneId;
    private static final String TAG = "BannerUnityPlugin";
    BannerAdListener mBannerAdListener = new BannerAdListener(){

        @Override
        public final void onAdClicked(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdClicked: ");
            TradplusUnityPlugin.UnityEvent.onAdClicked.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdImpression(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdImpression: ");
            TradplusUnityPlugin.UnityEvent.onAdImpression.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdLoaded: ");
            TradplusUnityPlugin.UnityEvent.onAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(tPAdInfo.height));
            int n = tPAdInfo.width;
            int n2 = tPAdInfo.height;
            Log.i((String)BannerUnityPlugin.TAG, (String)"height :".concat(String.valueOf(n2)));
            if (n2 < 50) {
                n2 = 50;
                n = 320;
            }
            float f2 = ScreenUtil.getScreenDensity((Activity)TradplusUnityPlugin.getActivity());
            if (BannerUnityPlugin.this.tpBanner != null) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)BannerUnityPlugin.this.tpBanner.getLayoutParams();
                ((RelativeLayout.LayoutParams)BannerUnityPlugin.this.tpBanner.getLayoutParams()).width = (int)((float)n * f2);
                layoutParams.height = (int)((float)n2 * f2);
                Log.i((String)BannerUnityPlugin.TAG, (String)("onAdViewLoaded:  params.height : " + layoutParams.height + ", params.width :" + layoutParams.width));
                BannerUnityPlugin.this.tpBanner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }

        @Override
        public final void onAdLoadFailed(TPAdError tPAdError) {
            Log.i((String)BannerUnityPlugin.TAG, (String)("onAdLoadFailed: msg : " + tPAdError.getErrorMsg()));
            if (BannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onAdLoadFailed.Emit(BannerUnityPlugin.this.mAdUnitId, tPAdError.getErrorMsg());
        }

        @Override
        public final void onAdClosed(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdClosed: ");
            TradplusUnityPlugin.UnityEvent.onAdClosed.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };
    LoadAdEveryLayerListener mLoadAdEveryLayerListener = new LoadAdEveryLayerListener(){

        @Override
        public final void onAdAllLoaded(boolean bl) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onAdAllLoaded: isSuccess : ".concat(String.valueOf(bl)));
            if (BannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onAdAllLoaded.Emit(String.valueOf(bl), BannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)("oneLayerLoadFailed: msg : " + tPAdError.getErrorMsg()));
            TradplusUnityPlugin.UnityEvent.oneLayerLoadFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }

        @Override
        public final void oneLayerLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"oneLayerLoaded: ");
            TradplusUnityPlugin.UnityEvent.oneLayerLoaded.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onLoadAdStart(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onLoadAdStart: ");
            TradplusUnityPlugin.UnityEvent.onLoadAdStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingStart(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onBiddingStart: ");
            TradplusUnityPlugin.UnityEvent.onBiddingStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingEnd(TPAdInfo tPAdInfo) {
            Log.i((String)BannerUnityPlugin.TAG, (String)"onBiddingEnd: ");
            TradplusUnityPlugin.UnityEvent.onBiddingEnd.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };

    public BannerUnityPlugin(String string) {
        super(string);
    }

    public void createBanner(final int n) {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null) {
                    BannerUnityPlugin.this.tpBanner = new TPBanner((Context)TradplusUnityPlugin.getActivity());
                }
                BannerUnityPlugin.this.tpBanner.setAdListener(BannerUnityPlugin.this.mBannerAdListener);
                BannerUnityPlugin.this.tpBanner.setAllAdLoadListener(BannerUnityPlugin.this.mLoadAdEveryLayerListener);
                BannerUnityPlugin.this.tpBanner.loadAd(BannerUnityPlugin.this.mAdUnitId, TextUtils.isEmpty((CharSequence)BannerUnityPlugin.this.mAdSceneId) ? "" : BannerUnityPlugin.this.mAdSceneId);
                BannerUnityPlugin.this.mLayout = ScreenUtil.prepLayout((int)n, (RelativeLayout)BannerUnityPlugin.this.mLayout, (Context)TradplusUnityPlugin.getActivity());
                TradplusUnityPlugin.getActivity().addContentView((View)BannerUnityPlugin.this.mLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                BannerUnityPlugin.this.mLayout.addView((View)BannerUnityPlugin.this.tpBanner);
                BannerUnityPlugin.this.mLayout.setVisibility(0);
            }
        });
    }

    public void hideBanner(final boolean bl) {
        if (this.tpBanner == null) {
            return;
        }
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (bl) {
                    Log.d((String)"refreshTime", (String)"Banner GONE");
                    BannerUnityPlugin.this.tpBanner.setVisibility(8);
                    return;
                }
                Log.d((String)"refreshTime", (String)"Banner VISIBLE");
                BannerUnityPlugin.this.tpBanner.setVisibility(0);
            }
        });
    }

    public void destroyBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (BannerUnityPlugin.this.tpBanner == null || BannerUnityPlugin.this.mLayout == null) {
                    return;
                }
                BannerUnityPlugin.this.mLayout.removeAllViews();
                BannerUnityPlugin.this.mLayout.setVisibility(8);
                BannerUnityPlugin.this.tpBanner.onDestroy();
            }
        });
    }

    public void entryAdScenario(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.mAdSceneId = string;
        }
        if (this.tpBanner != null) {
            this.tpBanner.entryAdScenario(string);
        }
    }
}

