/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.Json;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.mgr.nativead.TPNativeAdRenderImpl;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.R;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.nativead.TPNativeAdRender;
import com.tradplus.ads.open.nativead.TPNativeBanner;
import com.tradplus.ads.unity.TradplusUnityPlugin;
import java.util.HashMap;

public class NativeBannerUnityPlugin
extends TradplusUnityPlugin {
    private TPNativeBanner mTPNativeBanner;
    private RelativeLayout mRelativeLayout;
    private int mWight;
    private int mHeight;
    private String LayoutIdByName;
    private Activity activity = TradplusUnityPlugin.getActivity();
    private String mLayoutIdByName;
    private static final String TAG = "NativeBannerPlugin";
    private HashMap<String, Object> hashMap = new HashMap();
    BannerAdListener mBannerAdListener = new BannerAdListener(){

        @Override
        public final void onAdClicked(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClicked: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClicked.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdImpression(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdImpression: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdImpression.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdLoaded(final TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdLoaded: ");
            if (tPAdInfo.height != 0) {
                NativeBannerUnityPlugin.this.mHeight = tPAdInfo.height;
            }
            if (NativeBannerUnityPlugin.this.mWight == 0 && NativeBannerUnityPlugin.this.mHeight == 0) {
                NativeBannerUnityPlugin.this.mWight = 320;
                NativeBannerUnityPlugin.this.mHeight = 50;
            }
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("height :" + NativeBannerUnityPlugin.this.mHeight));
            final float f2 = ScreenUtil.getScreenDensity((Activity)TradplusUnityPlugin.getActivity());
            TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (NativeBannerUnityPlugin.this.mTPNativeBanner != null) {
                        View view = NativeBannerUnityPlugin.this.mTPNativeBanner.findViewById(R.id.ll_nativebanner);
                        View view2 = NativeBannerUnityPlugin.this.mTPNativeBanner.findViewById(R.id.ll_ad_choices);
                        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view2.getLayoutParams();
                        LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
                        layoutParams2.width = NativeBannerUnityPlugin.this.mWight == -1 ? DeviceUtils.getScreenWidth((Context)NativeBannerUnityPlugin.this.activity) : (int)((float)NativeBannerUnityPlugin.this.mWight * f2);
                        layoutParams2.height = (int)((float)NativeBannerUnityPlugin.this.mHeight * f2);
                        layoutParams.width = NativeBannerUnityPlugin.this.mWight == -1 ? DeviceUtils.getScreenWidth((Context)NativeBannerUnityPlugin.this.activity) : (int)((float)NativeBannerUnityPlugin.this.mWight * f2);
                        if (tPAdInfo.height != 0 && tPAdInfo.adSourceName.equals("audience-network")) {
                            layoutParams2.width = DeviceUtils.getScreenWidth((Context)NativeBannerUnityPlugin.this.activity);
                        }
                        Log.i((String)NativeBannerUnityPlugin.TAG, (String)("params.height : " + layoutParams2.height + ", params.width :" + layoutParams2.width));
                        view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                    }
                    Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdLoaded: ");
                    TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(NativeBannerUnityPlugin.this.mHeight));
                }
            });
        }

        @Override
        public final void onAdLoadFailed(TPAdError tPAdError) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("onAdLoadFailed: msg : " + tPAdError.getErrorMsg()));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoadFailed.Emit(NativeBannerUnityPlugin.this.mAdUnitId, tPAdError.getErrorMsg());
        }

        @Override
        public final void onAdClosed(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClosed: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClosed.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };
    LoadAdEveryLayerListener mLoadAdEveryLayerListener = new LoadAdEveryLayerListener(){

        @Override
        public final void onAdAllLoaded(boolean bl) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdAllLoaded: isSuccess : ".concat(String.valueOf(bl)));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdAllLoaded.Emit(String.valueOf(bl), NativeBannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("oneLayerLoadFailed: msg : " + tPAdError.getErrorMsg()));
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoadFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }

        @Override
        public final void oneLayerLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"oneLayerLoaded: ");
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoaded.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onLoadAdStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onLoadAdStart: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerLoadAdStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onBiddingStart: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingEnd(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onBiddingEnd: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingEnd.Emit(JSON.toJSONString((Object)tPAdInfo));
        }
    };

    public NativeBannerUnityPlugin(String string) {
        super(string);
    }

    public void setNativeBannerSize(int n, int n2) {
        Log.i((String)TAG, (String)("setSize: width :" + n + ", height :" + n2));
        this.mWight = n;
        this.mHeight = n2;
    }

    public void setCustomParams(String string) {
        Log.i((String)TAG, (String)"setCustomParams: map".concat(String.valueOf(string)));
        try {
            if (!TextUtils.isEmpty((CharSequence)string) && Json.jsonStringToMap((String)string).containsKey("need_down_load_img")) {
                string = (String)Json.jsonStringToMap((String)string).get("need_down_load_img");
                this.hashMap.put("need_down_load_img", string);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void createNativeBanner(int n) {
        this.createNativeBanner(n, "", "");
    }

    public void createNativeBanner(int n, String string) {
        this.createNativeBanner(n, string, "");
    }

    public void createNativeBanner(final int n, String string, String object) {
        Log.i((String)TAG, (String)"createNativeBanner: ".concat(String.valueOf(object)));
        this.mLayoutIdByName = object;
        if (this.mTPNativeBanner == null) {
            this.mTPNativeBanner = new TPNativeBanner((Context)TradplusUnityPlugin.getActivity());
        }
        this.mTPNativeBanner.setAdListener(this.mBannerAdListener);
        this.mTPNativeBanner.setAllAdLoadListener(this.mLoadAdEveryLayerListener);
        if (this.mTPNativeBanner != null && this.mTPNativeBanner.getParent() != null) {
            ((ViewGroup)this.mTPNativeBanner.getParent()).removeView((View)this.mTPNativeBanner);
        }
        if (!this.hashMap.isEmpty()) {
            this.mTPNativeBanner.setCustomParams(this.hashMap);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLayoutIdByName)) {
            object = (ViewGroup)((LayoutInflater)this.activity.getSystemService("layout_inflater")).inflate(ResourceUtils.getLayoutIdByName((Context)this.activity, (String)this.mLayoutIdByName), null);
            object = new TPNativeAdRenderImpl(this.activity.getApplicationContext(), (ViewGroup)object);
            this.mTPNativeBanner.setNativeAdRender((TPNativeAdRender)object);
        }
        this.mTPNativeBanner.loadAd(this.mAdUnitId, TextUtils.isEmpty((CharSequence)string) ? "" : string);
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                NativeBannerUnityPlugin.this.mRelativeLayout = ScreenUtil.prepLayout((int)n, (RelativeLayout)NativeBannerUnityPlugin.this.mRelativeLayout, (Context)TradplusUnityPlugin.getActivity());
                Log.i((String)NativeBannerUnityPlugin.TAG, (String)("alignment: " + n));
                TradplusUnityPlugin.getActivity().addContentView((View)NativeBannerUnityPlugin.this.mRelativeLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                NativeBannerUnityPlugin.this.mRelativeLayout.removeAllViews();
                NativeBannerUnityPlugin.this.mRelativeLayout.addView((View)NativeBannerUnityPlugin.this.mTPNativeBanner);
                NativeBannerUnityPlugin.this.mRelativeLayout.setVisibility(0);
            }
        });
    }

    public void hideNativeBanner(final boolean bl) {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null) {
                    return;
                }
                if (bl) {
                    Log.d((String)"refreshTime", (String)"Native GONE");
                    NativeBannerUnityPlugin.this.mRelativeLayout.setVisibility(8);
                    return;
                }
                Log.d((String)"refreshTime", (String)"Native VISIBLE");
                NativeBannerUnityPlugin.this.mRelativeLayout.setVisibility(0);
            }
        });
    }

    public void destroyNativeBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null || NativeBannerUnityPlugin.this.mRelativeLayout == null) {
                    return;
                }
                NativeBannerUnityPlugin.this.mRelativeLayout.removeAllViews();
                NativeBannerUnityPlugin.this.mRelativeLayout.setVisibility(8);
                NativeBannerUnityPlugin.this.mTPNativeBanner.onDestroy();
            }
        });
    }

    public void entryAdScenario(String string) {
        if (this.mTPNativeBanner != null) {
            this.mTPNativeBanner.entryAdScenario(TextUtils.isEmpty((CharSequence)string) ? "" : string);
        }
    }
}

