/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.admob;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.http.request.LogRequest;
import com.zero.iad.core.impl.IAd;
import com.zero.iad.core.impl.IAdBanner;
import com.zero.iad.core.impl.IAdPlatform;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.platform.BasePlatform;
import com.zero.iad.core.stat.EventTrackerHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.AutomatedLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.HashMap;

public class AdBannerAdmob
extends BasePlatform
implements IAdBanner,
IAdPlatform {
    private String r = "";
    private int aQ = 0;
    private AdView aR;
    private TAdListener aS = null;
    private AdItem f;
    private long aT;

    public AdBannerAdmob(IAd iAd) {
        super(iAd);
    }

    @Override
    public void setBannerSize(int n) {
        this.aQ = n;
    }

    @Override
    public View getBannerView(Context context) {
        this.aR = new AdView(context);
        this.aR.setAdUnitId(this.r);
        switch (this.aQ) {
            case 0: 
            case 3: {
                this.aR.setAdSize(AdSize.BANNER);
                break;
            }
            case 1: {
                this.aR.setAdSize(AdSize.LARGE_BANNER);
                break;
            }
            case 2: {
                this.aR.setAdSize(AdSize.MEDIUM_RECTANGLE);
                break;
            }
            default: {
                this.aR.setAdSize(AdSize.BANNER);
            }
        }
        this.aR.setAdListener(new AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
                AdLogUtil.Log().d("AdBannerAdmob", "admob banner\u5173\u95ed");
                if (AdBannerAdmob.this.aS != null) {
                    AutomatedLogUtil.automatedRecord("admob", AdBannerAdmob.this.r, "Closed", "banner");
                    AdBannerAdmob.this.aS.onAdClosed();
                }
            }

            public void onAdFailedToLoad(int n) {
                super.onAdFailedToLoad(n);
                AdLogUtil.Log().e("AdBannerAdmob", "admob banner\u52a0\u8f7d\u5931\u8d25\uff0cerrorCode:" + n);
                if (AdBannerAdmob.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerAdmob.this.getEvevtMap();
                    hashMap.put("type_code", "1");
                    hashMap.put("status", String.valueOf(n));
                    EventTrackerHelper.trackthirdEvent(AdBannerAdmob.this.parent, hashMap, true);
                    TAdError tAdError = PlatformUtil.getAdError(n);
                    AdLogUtil.Log().e("AdBannerAdmob", tAdError.getErrorMessage());
                    if (AdBannerAdmob.this.aS != null) {
                        AdBannerAdmob.this.aS.onError(tAdError);
                    }
                }
            }

            public void onAdLeftApplication() {
                AdLogUtil.Log().d("AdBannerAdmob", "admob banner\u88ab\u70b9\u51fb");
                long l = System.currentTimeMillis();
                if (l - AdBannerAdmob.this.aT > 2000L) {
                    if (AdBannerAdmob.this.f != null && AdBannerAdmob.this.f.getClkUrlsList() != null) {
                        LogRequest.syncUpdateCLKLogRequest("", AdBannerAdmob.this.f.getClkUrlsList(), AdBannerAdmob.this.f.getCacheNum());
                    }
                    if (AdBannerAdmob.this.aS != null) {
                        AutomatedLogUtil.automatedRecord("admob", AdBannerAdmob.this.r, "Click", "banner");
                        AdBannerAdmob.this.aS.onAdClicked();
                    }
                    AdBannerAdmob.this.aT = l;
                }
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                if (AdBannerAdmob.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerAdmob.this.getEvevtMap();
                    hashMap.put("type_code", "1");
                    hashMap.put("status", "200");
                    EventTrackerHelper.trackthirdEvent(AdBannerAdmob.this.parent, hashMap, true);
                    AdLogUtil.Log().d("AdBannerAdmob", "admob banner\u52a0\u8f7d\u6210\u529f");
                    if (AdBannerAdmob.this.aS != null) {
                        AutomatedLogUtil.automatedRecord("admob", AdBannerAdmob.this.r, "Loaded", "banner");
                        AdBannerAdmob.this.aS.onAdLoaded();
                        AutomatedLogUtil.automatedRecord("admob", AdBannerAdmob.this.r, "Show", "banner");
                    }
                } else {
                    AdLogUtil.Log().d("AdBannerAdmob", "admob banner\u52a0\u8f7d\u6210\u529f,\u4f46\u8d85\u65f6\u4e0d\u663e\u793a");
                }
            }

            public void onAdImpression() {
                super.onAdImpression();
                AutomatedLogUtil.automatedRecord("admob", AdBannerAdmob.this.r, "Impression", "banner");
            }
        });
        this.startTime = System.currentTimeMillis();
        return this.aR;
    }

    @Override
    public boolean isPlatformExists() {
        try {
            Class.forName("com.google.android.gms.ads.AdView");
            return true;
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("AdBannerAdmob", "admob\u5e73\u53f0\u4e0d\u5b58\u5728\uff0cPlatform not exists");
            return false;
        }
    }

    @Override
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd() {
        if (this.aR != null) {
            AdLogUtil.Log().d("AdBannerAdmob", "admob banner\u5f00\u59cb\u52a0\u8f7d");
            AdRequest adRequest = new AdRequest.Builder().build();
            AutomatedLogUtil.automatedRecord("admob", this.r, "LoadAd", "banner");
            this.aR.loadAd(adRequest);
        } else {
            AdLogUtil.Log().e("AdBannerAdmob", "admob banner adView \u4e3a\u7a7a\uff0c\u5f00\u59cb\u52a0\u8f7d\u5931\u8d25");
        }
    }

    @Override
    public boolean isAdAccepted(AdItem adItem) {
        if (adItem == null) {
            AdLogUtil.Log().e("AdBannerAdmob", "AdItem\u4e3a\u7a7a");
            return false;
        }
        this.f = adItem;
        return adItem.getAdSource() == AdSource.AD_ADMOB;
    }

    @Override
    public void setPlacementId(String string2) {
        this.r = string2;
    }

    @Override
    public void setAdListener(TAdListener tAdListener) {
        this.aS = tAdListener;
    }

    @Override
    public void destroy() {
        if (this.aR != null) {
            this.aR.setAdListener(null);
            this.aR.destroy();
            this.aR = null;
        }
        AdLogUtil.Log().d("AdBannerAdmob", "admob banner \u9500\u6bc1");
    }
}

