/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.facebook;

import android.content.Context;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.http.request.LogRequest;
import com.zero.iad.core.impl.IAd;
import com.zero.iad.core.impl.IAdBanner;
import com.zero.iad.core.impl.IAdPlatform;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.platform.BasePlatform;
import com.zero.iad.core.stat.EventTrackerHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.AutomatedLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.HashMap;

public class AdBannerFacebook
extends BasePlatform
implements IAdBanner,
IAdPlatform {
    private TAdListener aZ;
    private String r;
    private int aQ;
    private AdView bq;
    private AdSize br;
    private AdItem f;
    private long aT;

    public AdBannerFacebook(IAd iAd) {
        super(iAd);
    }

    @Override
    public void setBannerSize(int n) {
        this.aQ = n;
    }

    @Override
    public View getBannerView(Context context) {
        switch (this.aQ) {
            case 0: {
                this.br = AdSize.BANNER_HEIGHT_50;
                break;
            }
            case 1: {
                this.br = AdSize.BANNER_HEIGHT_90;
                break;
            }
            case 2: {
                this.br = AdSize.INTERSTITIAL;
                break;
            }
        }
        this.bq = new AdView(context, this.r, this.br);
        this.bq.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError adError) {
                AdLogUtil.Log().e("AdBannerFacebook", "fb banner\u52a0\u8f7d\u9519\u8bef\uff0cerrorCode:" + adError.getErrorCode() + ", msg:" + adError.getErrorMessage());
                if (AdBannerFacebook.this.isNotTimeOut()) {
                    AdLogUtil.Log().e("AdBannerFacebook", adError.getErrorMessage());
                    HashMap<String, String> hashMap = AdBannerFacebook.this.getEvevtMap();
                    hashMap.put("type_code", "2");
                    hashMap.put("status", String.valueOf(adError.getErrorCode()));
                    EventTrackerHelper.trackthirdEvent(AdBannerFacebook.this.parent, hashMap, true);
                    TAdError tAdError = PlatformUtil.getAdError(adError.getErrorCode());
                    if (AdBannerFacebook.this.aZ != null) {
                        AdBannerFacebook.this.aZ.onError(tAdError);
                    }
                }
            }

            public void onAdLoaded(Ad ad) {
                if (AdBannerFacebook.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerFacebook.this.getEvevtMap();
                    hashMap.put("type_code", "2");
                    hashMap.put("status", "200");
                    EventTrackerHelper.trackthirdEvent(AdBannerFacebook.this.parent, hashMap, true);
                    AdLogUtil.Log().d("AdBannerFacebook", "fb banner\u52a0\u8f7d\u6210\u529f");
                    if (AdBannerFacebook.this.aZ != null) {
                        AutomatedLogUtil.automatedRecord("fan", AdBannerFacebook.this.r, "Loaded", "banner");
                        AdBannerFacebook.this.aZ.onAdLoaded();
                        AutomatedLogUtil.automatedRecord("fan", AdBannerFacebook.this.r, "Show", "banner");
                    }
                } else {
                    AdLogUtil.Log().d("AdBannerFacebook", "fb banner\u52a0\u8f7d\u6210\u529f,\u4f46\u8d85\u65f6\u4e0d\u663e\u793a");
                }
            }

            public void onAdClicked(Ad ad) {
                AdLogUtil.Log().d("AdBannerFacebook", "fb banner\u88ab\u70b9\u51fb");
                long l = System.currentTimeMillis();
                if (l - AdBannerFacebook.this.aT > 2000L) {
                    if (AdBannerFacebook.this.f != null && AdBannerFacebook.this.f.getClkUrlsList() != null) {
                        LogRequest.syncUpdateCLKLogRequest("", AdBannerFacebook.this.f.getClkUrlsList(), AdBannerFacebook.this.f.getCacheNum());
                    }
                    if (AdBannerFacebook.this.aZ != null) {
                        AutomatedLogUtil.automatedRecord("fan", AdBannerFacebook.this.r, "Click", "banner");
                        AdBannerFacebook.this.aZ.onAdClicked();
                    }
                    AdBannerFacebook.this.aT = l;
                }
            }

            public void onLoggingImpression(Ad ad) {
                AutomatedLogUtil.automatedRecord("fan", AdBannerFacebook.this.r, "Impression", "banner");
            }
        });
        this.startTime = System.currentTimeMillis();
        return this.bq;
    }

    @Override
    public boolean isPlatformExists() {
        try {
            Class.forName("com.facebook.ads.AdView");
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AdLogUtil.Log().e("AdBannerFacebook", "fb\u5e73\u53f0\u4e0d\u5b58\u5728\uff0cPlatform not exists");
            return false;
        }
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d("AdBannerFacebook", "fb banner\u5f00\u59cb\u52a0\u8f7d");
        AutomatedLogUtil.automatedRecord("fan", this.r, "LoadAd", "banner");
        this.bq.loadAd();
    }

    @Override
    public boolean isAdAccepted(AdItem adItem) {
        if (adItem == null) {
            AdLogUtil.Log().e("AdBannerFacebook", "AdItem\u4e3a\u7a7a");
            return false;
        }
        this.f = adItem;
        return this.f.getAdSource() == AdSource.AD_FAN;
    }

    @Override
    public void setPlacementId(String string2) {
        this.r = string2;
    }

    @Override
    public void setAdListener(TAdListener tAdListener) {
        this.aZ = tAdListener;
    }

    @Override
    public void destroy() {
        if (this.bq != null) {
            this.bq.setAdListener(null);
            this.bq.destroy();
            this.bq = null;
        }
        AdLogUtil.Log().d("AdBannerFacebook", "fb banner \u9500\u6bc1");
    }
}

