/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.utils;

import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import com.facebook.ads.NativeAd;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.transsion.athena.data.TrackData;
import com.transsion.core.utils.ToastUtil;
import com.transsion.ga.AthenaAnalytics;
import com.zero.iad.core.R;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.IntercaptInfor;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.TAdNativeInfo;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.impl.Intercept;
import com.zero.iad.core.ui.activity.TAdExposureActivity;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PackageUtil;
import java.util.ArrayList;
import java.util.List;

public class PlatformUtil {
    public static TAdError getAdError(int n) {
        if (n == 2001 || n == 0) {
            return TAdError.INTERNAL_ERROR;
        }
        if (n == 1000 || n == 2) {
            return TAdError.NETWORK_ERROR;
        }
        if (n == 1001 || n == 3) {
            return TAdError.NO_FILL;
        }
        if (n == 1) {
            return TAdError.ERROR_CODE_INVALID_REQUEST;
        }
        if (n == 1002) {
            return TAdError.LOAD_TOO_FREQUENTLY;
        }
        if (n == 2000) {
            return TAdError.SERVER_ERROR;
        }
        return TAdError.UNKNOWN_ERROR;
    }

    private static TAdNativeInfo d(AdItem adItem) {
        TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
        TAdNativeInfo.Image image = new TAdNativeInfo.Image();
        TAdNativeInfo.Icon icon = new TAdNativeInfo.Icon();
        TAdNativeInfo.Image image2 = new TAdNativeInfo.Image();
        tAdNativeInfo.setSource(AdSource.AD_SELF);
        tAdNativeInfo.setAdId(adItem.getAdId());
        tAdNativeInfo.setcId(adItem.getcId());
        tAdNativeInfo.setPkgs(adItem.getPkgs());
        if (!TextUtils.isEmpty((CharSequence)adItem.getCallToAction())) {
            tAdNativeInfo.setAdCallToAction(adItem.getCallToAction());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getIurl()) && adItem.getAdType() == 1) {
            image.setUrl(adItem.getIurl());
            image.setWidth(adItem.getW());
            image.setHeight(adItem.getH());
            tAdNativeInfo.setImage(image);
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getTitle())) {
            tAdNativeInfo.setTitle(adItem.getTitle());
        }
        if (adItem.getImage() != null) {
            image.setUrl(adItem.getImage().getUrl());
            image.setWidth(adItem.getImage().getW());
            image.setHeight(adItem.getImage().getH());
            tAdNativeInfo.setImage(image);
        }
        if (adItem.getIcon() != null) {
            icon.setIconUrl(adItem.getIcon().getUrl());
            icon.setWidth(adItem.getIcon().getW());
            icon.setHeight(adItem.getIcon().getH());
            tAdNativeInfo.setIcon(icon);
            image2.setUrl(adItem.getIcon().getUrl());
            image2.setWidth(adItem.getIcon().getW());
            image2.setHeight(adItem.getIcon().getH());
            tAdNativeInfo.setIconImage(image2);
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getData())) {
            tAdNativeInfo.setDescription(adItem.getData());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getData2())) {
            tAdNativeInfo.setDescription2(adItem.getData2());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getLikes())) {
            tAdNativeInfo.setLikes(adItem.getLikes());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getSponsored())) {
            tAdNativeInfo.setSponsored(adItem.getSponsored());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getDownloads())) {
            tAdNativeInfo.setDownloads(adItem.getDownloads());
        }
        if (!TextUtils.isEmpty((CharSequence)adItem.getRating())) {
            tAdNativeInfo.setRating(adItem.getRating());
        }
        return tAdNativeInfo;
    }

    public static List<TAdNativeInfo> getTAdNativeInfoList(List<AdItem> list) {
        ArrayList<TAdNativeInfo> arrayList = new ArrayList<TAdNativeInfo>();
        for (AdItem adItem : list) {
            arrayList.add(PlatformUtil.d(adItem));
        }
        return arrayList;
    }

    public static TAdNativeInfo getTAdNativeInfo(Object object) {
        AdSource adSource = AdSource.AD_SELF;
        if (object != null) {
            if (object instanceof NativeAd) {
                TAdNativeInfo.Image image = new TAdNativeInfo.Image();
                TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
                TAdNativeInfo.Icon icon = new TAdNativeInfo.Icon();
                TAdNativeInfo.Image image2 = new TAdNativeInfo.Image();
                NativeAd nativeAd = (NativeAd)object;
                tAdNativeInfo.setAdId(nativeAd.getId());
                tAdNativeInfo.setTitle(nativeAd.getAdTitle());
                tAdNativeInfo.setDescription(nativeAd.getAdBody());
                tAdNativeInfo.setAdCallToAction(nativeAd.getAdCallToAction());
                adSource = AdSource.AD_FAN;
                tAdNativeInfo.setSource(adSource);
                if (nativeAd.getAdIcon() != null && !TextUtils.isEmpty((CharSequence)nativeAd.getAdIcon().getUrl())) {
                    icon.setIconUrl(nativeAd.getAdIcon().getUrl());
                    icon.setWidth(nativeAd.getAdIcon().getWidth());
                    icon.setHeight(nativeAd.getAdIcon().getHeight());
                    image2.setUrl(nativeAd.getAdIcon().getUrl());
                    image2.setWidth(nativeAd.getAdIcon().getWidth());
                    image2.setHeight(nativeAd.getAdIcon().getHeight());
                }
                tAdNativeInfo.setIcon(icon);
                tAdNativeInfo.setIconImage(image2);
                if (nativeAd.getAdCoverImage() != null && !TextUtils.isEmpty((CharSequence)nativeAd.getAdCoverImage().getUrl())) {
                    image.setUrl(nativeAd.getAdCoverImage().getUrl());
                    image.setWidth(nativeAd.getAdCoverImage().getWidth());
                    image.setHeight(nativeAd.getAdCoverImage().getHeight());
                }
                tAdNativeInfo.setImage(image);
                return tAdNativeInfo;
            }
            if (object instanceof AdItem) {
                return PlatformUtil.d((AdItem)object);
            }
            if (object instanceof NativeAppInstallAd) {
                TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
                TAdNativeInfo.Image image = new TAdNativeInfo.Image();
                TAdNativeInfo.Icon icon = new TAdNativeInfo.Icon();
                NativeAppInstallAd nativeAppInstallAd = (NativeAppInstallAd)object;
                tAdNativeInfo.setObject(nativeAppInstallAd);
                if (nativeAppInstallAd.getHeadline() != null) {
                    tAdNativeInfo.setTitle(nativeAppInstallAd.getHeadline().toString());
                }
                if (nativeAppInstallAd.getBody() != null) {
                    tAdNativeInfo.setDescription(nativeAppInstallAd.getBody().toString());
                }
                if (nativeAppInstallAd.getCallToAction() != null) {
                    tAdNativeInfo.setAdCallToAction(nativeAppInstallAd.getCallToAction().toString());
                }
                adSource = AdSource.AD_ADMOB_APP_INSTALL;
                tAdNativeInfo.setSource(adSource);
                if (nativeAppInstallAd.getStarRating() != null) {
                    tAdNativeInfo.setRating(nativeAppInstallAd.getStarRating() + "");
                }
                if (nativeAppInstallAd.getIcon() != null) {
                    if (nativeAppInstallAd.getIcon().getDrawable() != null) {
                        icon.setIconDrawable(nativeAppInstallAd.getIcon().getDrawable());
                    }
                    if (nativeAppInstallAd.getIcon().getUri() != null) {
                        icon.setIconUrl(nativeAppInstallAd.getIcon().getUri().toString());
                    }
                }
                if (nativeAppInstallAd.getImages() != null && !nativeAppInstallAd.getImages().isEmpty()) {
                    if (nativeAppInstallAd.getImages().get(0) != null) {
                        image.setDrawable(((NativeAd.Image)nativeAppInstallAd.getImages().get(0)).getDrawable());
                    }
                    if (nativeAppInstallAd.getImages().get(0) != null && ((NativeAd.Image)nativeAppInstallAd.getImages().get(0)).getUri() != null) {
                        image.setUrl(((NativeAd.Image)nativeAppInstallAd.getImages().get(0)).getUri().toString());
                    }
                }
                tAdNativeInfo.setImage(image);
                tAdNativeInfo.setIcon(icon);
                return tAdNativeInfo;
            }
            if (object instanceof NativeContentAd) {
                TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
                TAdNativeInfo.Image image = new TAdNativeInfo.Image();
                NativeContentAd nativeContentAd = (NativeContentAd)object;
                tAdNativeInfo.setObject(nativeContentAd);
                if (nativeContentAd.getHeadline() != null) {
                    tAdNativeInfo.setTitle(nativeContentAd.getHeadline().toString());
                }
                if (nativeContentAd.getBody() != null) {
                    tAdNativeInfo.setDescription(nativeContentAd.getBody().toString());
                }
                if (nativeContentAd.getCallToAction() != null) {
                    tAdNativeInfo.setAdCallToAction(nativeContentAd.getCallToAction().toString());
                }
                adSource = AdSource.AD_ADMOB_CONTENT;
                tAdNativeInfo.setSource(adSource);
                List list = nativeContentAd.getImages();
                if (list != null && list.size() > 0) {
                    if (list.get(0) != null) {
                        image.setDrawable(((NativeAd.Image)list.get(0)).getDrawable());
                    }
                    if (list != null && list.get(0) != null && ((NativeAd.Image)list.get(0)).getUri() != null) {
                        image.setUrl(((NativeAd.Image)list.get(0)).getUri().toString());
                    }
                }
                tAdNativeInfo.setImage(image);
                return tAdNativeInfo;
            }
            if (object instanceof UnifiedNativeAd) {
                TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
                TAdNativeInfo.Image image = new TAdNativeInfo.Image();
                TAdNativeInfo.Icon icon = new TAdNativeInfo.Icon();
                TAdNativeInfo.Image image3 = new TAdNativeInfo.Image();
                UnifiedNativeAd unifiedNativeAd = (UnifiedNativeAd)object;
                tAdNativeInfo.setObject(unifiedNativeAd);
                if (unifiedNativeAd.getHeadline() != null) {
                    tAdNativeInfo.setTitle(unifiedNativeAd.getHeadline().toString());
                }
                if (unifiedNativeAd.getBody() != null) {
                    tAdNativeInfo.setDescription(unifiedNativeAd.getBody().toString());
                }
                if (unifiedNativeAd.getCallToAction() != null) {
                    tAdNativeInfo.setAdCallToAction(unifiedNativeAd.getCallToAction().toString());
                }
                if (unifiedNativeAd.getStarRating() != null) {
                    tAdNativeInfo.setRating(unifiedNativeAd.getStarRating() + "");
                }
                if (unifiedNativeAd.getIcon() != null) {
                    if (unifiedNativeAd.getIcon().getDrawable() != null) {
                        icon.setIconDrawable(unifiedNativeAd.getIcon().getDrawable());
                        image3.setDrawable(unifiedNativeAd.getIcon().getDrawable());
                    } else {
                        icon.setIconUrl(unifiedNativeAd.getIcon().getUri().toString());
                        image3.setUrl(unifiedNativeAd.getIcon().getUri().toString());
                    }
                }
                tAdNativeInfo.setIcon(icon);
                tAdNativeInfo.setIconImage(image3);
                if (unifiedNativeAd.getImages() != null && !unifiedNativeAd.getImages().isEmpty()) {
                    if (unifiedNativeAd.getImages().get(0) != null) {
                        image.setDrawable(((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getDrawable());
                    }
                    if (unifiedNativeAd.getImages().get(0) != null && ((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getUri() != null) {
                        image.setUrl(((NativeAd.Image)unifiedNativeAd.getImages().get(0)).getUri().toString());
                    }
                }
                tAdNativeInfo.setImage(image);
                adSource = AdSource.AD_ADMOB;
                tAdNativeInfo.setSource(adSource);
                return tAdNativeInfo;
            }
        }
        return null;
    }

    public static boolean isPackageAvilible(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo("com.android.chrome", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        return packageInfo != null;
    }

    public static boolean isNeedRedirectDpl(Context context, String string2, Intercept intercept, int n, AdItem adItem) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            AdLogUtil.Log().d("PlatformUtil", "landingUrl is:=" + string2);
            if (PlatformUtil.isPreDownLoad(string2)) {
                AdLogUtil.Log().d("PlatformUtil", "PreDownload is true");
                return false;
            }
            if (string2.startsWith("http://") || string2.startsWith("https://")) {
                if (string2.endsWith(".apk")) {
                    AdLogUtil.Log().d("PlatformUtil", "targetUrl is apk file download with self downloadManager");
                    return false;
                }
                if (n == 0) {
                    AdLogUtil.Log().d("PlatformUtil", "open flag is WEBVIEW_CHROME");
                    return false;
                }
                if (n == 1) {
                    AdLogUtil.Log().d("PlatformUtil", "open flag is WEBVIEW_SELF");
                    return false;
                }
                if (n == 2) {
                    return true;
                }
                AdLogUtil.Log().d("PlatformUtil", "webView flag is not in {1,2,3}");
            } else {
                AdLogUtil.Log().d("PlatformUtil", context.getResources().getString(R.string.valid_url));
            }
        } else {
            AdLogUtil.Log().e("PlatformUtil", "landingUrl is empty");
        }
        return false;
    }

    public static void startActivity(Context context, String string2, String string3, Intercept intercept, int n, AdItem adItem) {
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            AdLogUtil.Log().e("PlatformUtil", "landingUrl is:=" + string3);
            if (PlatformUtil.isPreDownLoad(string3)) {
                if (intercept != null && adItem != null) {
                    intercept.onclickIntercept(new IntercaptInfor(adItem.getPkgname(), adItem.getPkgver(), adItem.getPkgmd5(), PlatformUtil.getRealUrl(string3)));
                } else {
                    AdLogUtil.Log().d("PlatformUtil", "intercept or is adItem null");
                }
            } else if (string3.startsWith("http://") || string3.startsWith("https://")) {
                if (string3.endsWith(".apk")) {
                    AdLogUtil.Log().e("PlatformUtil", "targetUrl is apk file download with self downloadManager");
                    PlatformUtil.downloadApkWithSelfDownloadManager(context, string3);
                } else if (n == 0) {
                    if (PlatformUtil.isPackageAvilible(context)) {
                        PlatformUtil.doStartActivityWithPackageName(context, string3);
                    } else {
                        PlatformUtil.startActivity(context, string2, "", string3, 1, intercept, n, null);
                    }
                } else if (n == 1) {
                    Intent intent = new Intent(context, TAdExposureActivity.class);
                    Bundle bundle = new Bundle();
                    bundle.putString("url", string3);
                    bundle.putInt("webViewFlag", n);
                    bundle.putString("cId", adItem.getcId());
                    bundle.putInt("adType", adItem.getAdType());
                    bundle.putString("placementId", string2);
                    intent.putExtras(bundle);
                    intent.setFlags(0x10000000);
                    context.startActivity(intent);
                } else if (n == 2) {
                    if (TextUtils.isEmpty((CharSequence)adItem.getRedirectLink())) {
                        Intent intent = new Intent(context, TAdExposureActivity.class);
                        Bundle bundle = new Bundle();
                        bundle.putString("url", string3);
                        bundle.putInt("webViewFlag", n);
                        bundle.putString("cId", adItem.getcId());
                        bundle.putInt("adType", adItem.getAdType());
                        bundle.putString("placementId", string2);
                        intent.putExtras(bundle);
                        intent.setFlags(0x10000000);
                        context.startActivity(intent);
                    } else {
                        try {
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)adItem.getRedirectLink()));
                            intent.setPackage("com.android.vending");
                            intent.setFlags(0x10000000);
                            context.startActivity(intent);
                            PlatformUtil.athenaTracker(string2, adItem.getRedirectLink(), adItem);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    AdLogUtil.Log().d("PlatformUtil", "webView flag is not in {1,2,3}");
                }
            } else {
                AdLogUtil.Log().d("PlatformUtil", context.getResources().getString(R.string.valid_url));
            }
        } else {
            AdLogUtil.Log().e("PlatformUtil", "landingUrl is empty");
        }
    }

    public static void downloadApkWithSelfDownloadManager(Context context, String string2) {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String[] stringArray = string2.split("/");
                if (stringArray.length > 0) {
                    String string3 = stringArray[stringArray.length - 1];
                    AdLogUtil.Log().e("PlatformUtil", "targetName is:=" + string3);
                    DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
                    request.setNotificationVisibility(1);
                    request.setDestinationInExternalFilesDir(context, Environment.DIRECTORY_DOWNLOADS, string3);
                    request.setTitle((CharSequence)string3);
                    DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
                    long l = downloadManager.enqueue(request);
                } else {
                    AdLogUtil.Log().e("PlatformUtil", "targetUrl is illegal");
                }
            } else {
                AdLogUtil.Log().e("PlatformUtil", "targetUrl is null or empty");
            }
        } else {
            ToastUtil.showToast((String)"external storage is needed");
        }
    }

    public static void startActivity(Context context, String string2, String string3, String string4, int n, Intercept intercept, int n2, AdItem adItem) {
        String string5 = !TextUtils.isEmpty((CharSequence)string3) ? string3 : string4;
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        Uri uri = Uri.parse((String)string5);
        intent.setData(uri);
        intent.setFlags(0x10000000);
        if (n == 0) {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            if (list.size() > 0 && packageManager.resolveActivity(intent, 65536) != null) {
                context.startActivity(intent);
            } else {
                PlatformUtil.startActivity(context, string2, string4, intercept, n2, adItem);
            }
        } else {
            context.startActivity(intent);
        }
    }

    public static void doStartActivityWithPackageName(Context context, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        intent.setPackage("com.android.chrome");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean isPreDownLoad(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && string2.startsWith("predownload-");
    }

    public static String getRealUrl(String string2) {
        String string3 = "";
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string2.substring(12);
        }
        return string3;
    }

    public static int getDrawableWidth(Drawable drawable2, int n) {
        if (drawable2 == null) {
            return n;
        }
        if (drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap() != null) {
            int n2 = ((BitmapDrawable)drawable2).getBitmap().getWidth();
            AdLogUtil.Log().d("PlatformUtil", "BitmapDrawable width:=" + n2);
            return n2 > 0 ? n2 : 0;
        }
        int n3 = drawable2.getIntrinsicWidth();
        AdLogUtil.Log().d("PlatformUtil", "GifDrawable width:=" + n3);
        return n3 > 0 ? n3 : 0;
    }

    public static int getDrawableHeight(Drawable drawable2, int n) {
        if (drawable2 == null) {
            return n;
        }
        if (drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap() != null) {
            int n2 = ((BitmapDrawable)drawable2).getBitmap().getHeight();
            AdLogUtil.Log().d("PlatformUtil", "BitmapDrawable height:=" + n2);
            return n2 > 0 ? n2 : 0;
        }
        int n3 = drawable2.getIntrinsicHeight();
        AdLogUtil.Log().d("PlatformUtil", "GifDrawable height:=" + n3);
        return n3 > 0 ? n3 : 0;
    }

    public static boolean isOurSelflanding(AdItem adItem) {
        return adItem != null && (!TextUtils.isEmpty((CharSequence)adItem.getDeeplink()) || !TextUtils.isEmpty((CharSequence)adItem.getLanding_url()));
    }

    public static void athenaTracker(String string2, String string3, AdItem adItem) {
        if (adItem == null) {
            AdLogUtil.Log().e("PlatformUtil", "adItem\u4e3a\u7a7a");
            return;
        }
        AdLogUtil.Log().d("PlatformUtil", "\u8df3\u8f6cgp\u57cb\u70b9");
        TrackData trackData = new TrackData();
        trackData.add("version", PackageUtil.getSdkVersion()).add("sid", string2).add("url", string3).add("cId", adItem.getcId()).add("adType", String.valueOf(adItem.getAdType()));
        AthenaAnalytics.getInstance((int)1026).track("tan_to_gp", trackData, 10260001);
    }
}

