/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.utils;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ImageView;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.TAdNativeInfo;
import com.zero.iad.core.http.callback.DrawableResponseListener;
import com.zero.iad.core.http.request.DownLoadRequest;
import com.zero.iad.core.http.request.RequestBase;
import com.zero.iad.core.utils.AdLogUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AdImageHelper {
    public static void preCacheImages(@NonNull List<String> list, final @NonNull ImageListener imageListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        DownLoadRequest downLoadRequest = (DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, Drawable drawable2, RequestBase requestBase) {
                if (drawable2 != null) {
                    AdLogUtil.Log().d("AdImageHelper", "image cache success");
                    int n2 = atomicInteger.decrementAndGet();
                    if (n2 == 0 && !atomicBoolean.get()) {
                        imageListener.onImagesCached();
                    }
                }
            }

            @Override
            protected void onRequestError(TAdError tAdError) {
                AdLogUtil.Log().e("AdImageHelper", "image cache fail," + tAdError.toString());
                boolean bl = atomicBoolean.getAndSet(true);
                atomicInteger.decrementAndGet();
                if (!bl) {
                    imageListener.onImagesFailedToCache(tAdError);
                }
            }
        });
        for (String string2 : list) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            AdLogUtil.Log().d("AdImageHelper", "request url:" + string2);
            downLoadRequest.setUrl(string2).netRequestPreExecute();
        }
    }

    public static void loadImageView(@NonNull String string2, final @NonNull ImageView imageView) {
        DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, Drawable drawable2, RequestBase requestBase) {
                AdLogUtil.Log().d("AdImageHelper", "image cache success");
                if (drawable2 != null) {
                    imageView.setImageDrawable(drawable2);
                }
            }

            @Override
            protected void onRequestError(TAdError tAdError) {
                AdLogUtil.Log().e("AdImageHelper", "image load fail," + tAdError.toString());
            }
        })).setUrl(string2);
        downLoadRequest.netRequestPreExecute();
    }

    public static void preCacheAdImage(final @NonNull TAdNativeInfo.Image image, final ImageListener imageListener) {
        String string2 = image.getUrl();
        AdLogUtil.Log().d("AdImageHelper", "\u5f00\u59cb\u7f13\u5b58\u56fe\u7247\uff0crequest url:" + string2);
        DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, Drawable drawable2, RequestBase requestBase) {
                AdLogUtil.Log().d("AdImageHelper", "\u56fe\u7247\u7f13\u5b58\u6210\u529f\uff0cimage cache success");
                if (drawable2 != null) {
                    image.setDrawable(drawable2);
                    if (imageListener != null) {
                        imageListener.onImagesCached();
                    }
                }
            }

            @Override
            protected void onRequestError(TAdError tAdError) {
                AdLogUtil.Log().e("AdImageHelper", "\u56fe\u7247\u7f13\u5b58\u5931\u8d25\uff0curl:" + image.getUrl() + ", " + tAdError.toString());
                if (imageListener != null) {
                    imageListener.onImagesFailedToCache(new TAdError(tAdError.getErrorCode(), "cache image fail, url:" + image.getUrl() + ", " + tAdError.getErrorMessage()));
                }
            }
        })).setUrl(string2);
        downLoadRequest.netRequestPreExecute();
    }

    public static void preCacheAdImages(@NonNull List<TAdNativeInfo.Image> list, final @NonNull ImageListener imageListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        for (TAdNativeInfo.Image image : list) {
            AdImageHelper.preCacheAdImage(image, new ImageListener(){

                @Override
                public void onImagesCached() {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }

                @Override
                public void onImagesFailedToCache(TAdError tAdError) {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }
            });
        }
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TAdError var1);
    }
}

