/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.utils.cache;

import android.support.annotation.Nullable;
import com.transsion.core.utils.AppUtil;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.FileUtil;
import com.zero.iad.core.utils.cache.DiskLruCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CacheUtil {
    private String TAG = "CacheUtil";
    private static CacheUtil da;
    private static DiskLruCache db;

    private CacheUtil() {
        try {
            db = DiskLruCache.open(this.getCacheDir(), AppUtil.getVersionCode(), 1, 0x6400000L);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheUtil getInstance() {
        if (da != null) return da;
        Class<CacheUtil> clazz = CacheUtil.class;
        synchronized (CacheUtil.class) {
            if (da != null) return da;
            da = new CacheUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return da;
        }
    }

    @Nullable
    public synchronized String getString(String string2) {
        if (db == null || db.isClosed()) {
            return null;
        }
        try {
            DiskLruCache.Snapshot snapshot = db.get(string2);
            if (snapshot != null) {
                String string3 = snapshot.getString(0);
                AdLogUtil.Log().d(this.TAG, "get content successful.key=" + string2 + ", value=" + string3);
                return string3;
            }
        }
        catch (IOException iOException) {
            AdLogUtil.Log().e(this.TAG, "read cache error: " + iOException.toString());
        }
        return null;
    }

    public synchronized void putString(String string2, String string3) {
        block6: {
            if (db == null || db.isClosed()) {
                return;
            }
            DiskLruCache.Editor editor = null;
            try {
                editor = db.edit(string2);
                if (editor != null) {
                    editor.set(0, string3);
                    editor.commit();
                    db.flush();
                    AdLogUtil.Log().d(this.TAG, "put content successful. key=" + string2);
                }
            }
            catch (IOException iOException) {
                if (editor == null) break block6;
                try {
                    editor.abort();
                }
                catch (IOException iOException2) {
                    AdLogUtil.Log().e(this.TAG, "write cache error: " + iOException.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSerializable(String string2, Serializable serializable) {
        DiskLruCache.Editor editor = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            editor = db.edit(string2);
            if (editor == null) {
                return;
            }
            OutputStream outputStream = editor.newOutputStream(0);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            editor.commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                editor.abort();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAsSerializable(String string2) {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            DiskLruCache.Snapshot snapshot = db.get(string2);
            if (snapshot == null) {
                T t = null;
                return t;
            }
            InputStream inputStream = snapshot.getInputStream(0);
            if (inputStream == null) {
                T t = null;
                return t;
            }
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return (T)object;
    }

    public void diskRemove(String string2) {
        if (db == null || db.isClosed()) {
            return;
        }
        try {
            db.remove(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private File getCacheDir() {
        File file = new File(FileUtil.getAppDateCachePath(), "ZERO_AD_SDK_LRUCACHE");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

