/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.utils.cache;

import com.zero.iad.core.utils.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File dc;
    private final File dd;
    private final File de;
    private final int df;
    private final long dg;
    private final int dh;
    private long size = 0L;
    private Writer di;
    private final LinkedHashMap<String, a> dj = new LinkedHashMap(0, 0.75f, true);
    private int dk;
    private long dl = 0L;
    private final ExecutorService dm = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> dn = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void I() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.di == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.F()) {
                    DiskLruCache.this.E();
                    DiskLruCache.this.dk = 0;
                }
            }
            return null;
        }

        @Override
        public /* synthetic */ Object call() {
            return this.I();
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string2 = stringWriter.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.Log().d("DiskLruCache", "not a directory: " + file);
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.dc = file;
        this.df = n;
        this.dd = new File(file, "journal");
        this.de = new File(file, "journal.tmp");
        this.dh = n2;
        this.dg = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.dd.exists()) {
            try {
                diskLruCache.C();
                diskLruCache.D();
                diskLruCache.di = new BufferedWriter(new FileWriter(diskLruCache.dd, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.E();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void C() {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.dd), 8192);
        try {
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string6 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string2) && "1".equals(string3) && Integer.toString(this.df).equals(string4) && Integer.toString(this.dh).equals(string5) && "".equals(string6))) {
                throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            }
            try {
                while (true) {
                    this.g(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (EOFException eOFException) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void g(String string2) {
        String[] stringArray = string2.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string2);
        }
        String string3 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.dj.remove(string3);
            return;
        }
        a a2 = this.dj.get(string3);
        if (a2 == null) {
            a2 = new a(string3);
            this.dj.put(string3, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.dh) {
            a2.dt = true;
            a2.du = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.du = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string2);
        }
    }

    private void D() {
        DiskLruCache.a(this.de);
        Iterator<a> iterator = this.dj.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.du == null) {
                for (n = 0; n < this.dh; ++n) {
                    this.size += a2.ds[n];
                }
                continue;
            }
            a2.du = null;
            for (n = 0; n < this.dh; ++n) {
                DiskLruCache.a(a2.e(n));
                DiskLruCache.a(a2.f(n));
            }
            iterator.remove();
        }
    }

    private synchronized void E() {
        if (this.di != null) {
            this.di.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.de), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.df));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.dh));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.dj.values()) {
            if (a2.du != null) {
                bufferedWriter.write("DIRTY " + a2.key + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.key + a2.J() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.de.renameTo(this.dd);
        this.di = new BufferedWriter(new FileWriter(this.dd, true), 8192);
    }

    private static void a(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string2) {
        this.G();
        this.h(string2);
        a a2 = this.dj.get(string2);
        if (a2 == null) {
            return null;
        }
        if (!a2.dt) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.dh];
        try {
            for (int i = 0; i < this.dh; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.e(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ++this.dk;
        this.di.append("READ " + string2 + '\n');
        if (this.F()) {
            this.dm.submit(this.dn);
        }
        return new Snapshot(string2, a2.dv, inputStreamArray);
    }

    public Editor edit(String string2) {
        return this.a(string2, -1L);
    }

    private synchronized Editor a(String string2, long l) {
        this.G();
        this.h(string2);
        a a2 = this.dj.get(string2);
        if (l != -1L && (a2 == null || a2.dv != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string2);
            this.dj.put(string2, a2);
        } else if (a2.du != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.du = editor;
        this.di.write("DIRTY " + string2 + '\n');
        this.di.flush();
        return editor;
    }

    public File getDirectory() {
        return this.dc;
    }

    public long maxSize() {
        return this.dg;
    }

    public synchronized long size() {
        return this.size;
    }

    private synchronized void a(Editor editor, boolean bl) {
        int n;
        a a2 = editor.dp;
        if (a2.du != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.dt) {
            for (n = 0; n < this.dh; ++n) {
                if (a2.f(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.dh; ++n) {
            File file = a2.f(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.e(n);
                file.renameTo(file2);
                long l2 = a2.ds[n];
                ((a)a2).ds[n] = l = file2.length();
                this.size = this.size - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.dk;
        a2.du = null;
        if (a2.dt | bl) {
            a2.dt = true;
            this.di.write("CLEAN " + a2.key + a2.J() + '\n');
            if (bl) {
                a2.dv = this.dl++;
            }
        } else {
            this.dj.remove(a2.key);
            this.di.write("REMOVE " + a2.key + '\n');
        }
        if (this.size > this.dg || this.F()) {
            this.dm.submit(this.dn);
        }
    }

    private boolean F() {
        int n = 2000;
        return this.dk >= 2000 && this.dk >= this.dj.size();
    }

    public synchronized boolean remove(String string2) {
        this.G();
        this.h(string2);
        a a2 = this.dj.get(string2);
        if (a2 == null || a2.du != null) {
            return false;
        }
        for (int i = 0; i < this.dh; ++i) {
            File file = a2.e(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= a2.ds[i];
            ((a)a2).ds[i] = 0L;
        }
        ++this.dk;
        this.di.append("REMOVE " + string2 + '\n');
        this.dj.remove(string2);
        if (this.F()) {
            this.dm.submit(this.dn);
        }
        return true;
    }

    public boolean isClosed() {
        return this.di == null;
    }

    private void G() {
        if (this.di == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() {
        this.G();
        this.trimToSize();
        this.di.flush();
    }

    @Override
    public synchronized void close() {
        if (this.di == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.dj.values())) {
            if (a2.du == null) continue;
            a2.du.abort();
        }
        this.trimToSize();
        this.di.close();
        this.di = null;
    }

    private void trimToSize() {
        while (this.size > this.dg) {
            Map.Entry<String, a> entry = this.dj.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() {
        this.close();
        DiskLruCache.deleteContents(this.dc);
    }

    private void h(String string2) {
        if (string2.contains(" ") || string2.contains("\n") || string2.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string2 + "\"");
        }
    }

    private static String a(InputStream inputStream) {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class a {
        private final String key;
        private final long[] ds;
        private boolean dt;
        private Editor du;
        private long dv;

        private a(String string2) {
            this.key = string2;
            this.ds = new long[DiskLruCache.this.dh];
        }

        public String J() {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.ds) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.dh) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.ds[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File e(int n) {
            return new File(DiskLruCache.this.dc, this.key + "." + n);
        }

        public File f(int n) {
            return new File(DiskLruCache.this.dc, this.key + "." + n + ".tmp");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class Editor {
        private final com.zero.iad.core.utils.cache.DiskLruCache$a dp;
        private boolean dq;

        private Editor(com.zero.iad.core.utils.cache.DiskLruCache$a a2) {
            this.dp = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.dp.du != this) {
                    throw new IllegalStateException();
                }
                if (!this.dp.dt) {
                    return null;
                }
                return new FileInputStream(this.dp.e(n));
            }
        }

        public String getString(int n) {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.dp.du != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.dp.f(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string2) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string2);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() {
            if (this.dq) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.dp.key);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.this.dq = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.this.dq = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.dq = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.dq = true;
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long dv;
        private final InputStream[] dw;

        private Snapshot(String string2, long l, InputStream[] inputStreamArray) {
            this.key = string2;
            this.dv = l;
            this.dw = inputStreamArray;
        }

        public Editor edit() {
            return DiskLruCache.this.a(this.key, this.dv);
        }

        public InputStream getInputStream(int n) {
            return this.dw[n];
        }

        public String getString(int n) {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.dw) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

