/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.transsion.appupdate.database.DBData;
import com.transsion.appupdate.database.DBHelper;
import com.transsion.appupdate.reportBean.CreativeStatusData;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.CreativeIndex;
import com.transsion.common.bean.CreativeInfo;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.ImgInfoDL;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.bean.SdkAppID;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;

public class DBManager {
    private static volatile DBManager sInstance;
    private DBHelper mHelper;
    private SQLiteDatabase mDB;

    private DBManager(Context context) {
        this.mHelper = new DBHelper(context);
        this.mDB = this.mHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<DBManager> clazz = DBManager.class;
        synchronized (DBManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DBManager(CoreUtil.getContext());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private synchronized void closeDB() {
        if (this.mDB != null) {
            this.mDB.close();
        }
    }

    public synchronized void increaseCreativeUsedFrequency(int creativeId, int currentFrequencyType) {
        if (this.mDB != null) {
            StringBuilder sql = new StringBuilder("UPDATE ");
            sql.append("creative");
            sql.append(" SET ");
            sql.append("used_freq_count");
            sql.append(" = ");
            sql.append("used_freq_count");
            sql.append(" + 1 WHERE ");
            sql.append("id");
            sql.append(" = ? AND ");
            sql.append("freq_type");
            sql.append(" = ?");
            Object[] args = new String[]{String.valueOf(creativeId), String.valueOf(currentFrequencyType)};
            this.mDB.execSQL(sql.toString(), args);
        }
    }

    public synchronized void resetCreativeUsedFrequency() {
        if (this.mDB != null) {
            ContentValues values = new ContentValues();
            values.put("used_freq_count", Integer.valueOf(0));
            this.mDB.update("creative", values, null, null);
        }
    }

    public synchronized void updateCreativeLastShowTimeById(int id) {
        if (this.mDB != null) {
            ContentValues values = new ContentValues();
            values.put("last_show_time", Long.valueOf(System.currentTimeMillis()));
            String whereClause = "id = ?";
            String[] whereArgs = new String[]{String.valueOf(id)};
            this.mDB.update("creative", values, whereClause, whereArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<CreativeStatusData> saveOrUpdateCreativeList(List<CreativeInfo> creativeInfoList) {
        ArrayList<CreativeStatusData> resultList = null;
        if (creativeInfoList != null && creativeInfoList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                resultList = new ArrayList<CreativeStatusData>();
                for (CreativeInfo creativeInfo : creativeInfoList) {
                    ImgInfo logo;
                    ImgInfo anonymousIcon;
                    CreativeIndex index = creativeInfo.getCreativeIndex();
                    int type = creativeInfo.getCreativeType();
                    ContentValues values = new ContentValues();
                    if (null == index) {
                        CS.log.w("TMS_SERVER", "invalid creative, not to save");
                        continue;
                    }
                    values.put("id", Integer.valueOf(index.getCreativeID()));
                    values.put("version", Long.valueOf(index.getCreativeVersion()));
                    values.put("type", Integer.valueOf(type));
                    values.put("title", creativeInfo.getTitle());
                    values.put("anon_title", creativeInfo.getAnonymousTitle());
                    values.put("sub_title", creativeInfo.getSubTitle());
                    values.put("desc", creativeInfo.getDescription());
                    values.put("sub_desc", creativeInfo.getSubDescription());
                    values.put("rating", creativeInfo.getRating());
                    values.put("likes", Integer.valueOf(creativeInfo.getLikes()));
                    values.put("conversion", Integer.valueOf(creativeInfo.getConversion()));
                    values.put("price", creativeInfo.getPrice());
                    values.put("sale_price", creativeInfo.getSalePrice());
                    values.put("phone", creativeInfo.getPhone());
                    values.put("brand", creativeInfo.getBrand());
                    values.put("sponsored", creativeInfo.getSponsored());
                    values.put("address", creativeInfo.getAddress());
                    values.put("show_url", creativeInfo.getShowUrl());
                    values.put("imp_tracker", creativeInfo.getImpressionTracker());
                    values.put("click_tracker", creativeInfo.getClickTracker());
                    values.put("network", creativeInfo.getNetwork());
                    values.put("call_to_act", creativeInfo.getCallToAction());
                    values.put("extention", creativeInfo.getExtention());
                    values.put("whitelist", creativeInfo.getWhitelist());
                    values.put("blacklist", creativeInfo.getBlacklist());
                    values.put("gray_start_time", creativeInfo.getGrayStartTime());
                    values.put("gray_end_time", creativeInfo.getGrayEndTime());
                    values.put("valid_start_time", Long.valueOf(creativeInfo.getValidStartTime()));
                    values.put("valid_end_time", Long.valueOf(creativeInfo.getValidEndTime()));
                    values.put("freq_type", Integer.valueOf(creativeInfo.getFrequencyType()));
                    values.put("freq_limit_count", Integer.valueOf(creativeInfo.getFrequencyLimitCount()));
                    values.put("used_freq_count", Integer.valueOf(creativeInfo.getFrequencyUsedTime()));
                    values.put("weight", Integer.valueOf(creativeInfo.getWeight()));
                    values.put("app_id", Integer.valueOf(creativeInfo.getAppId()));
                    values.put("download_silent", Integer.valueOf(creativeInfo.getIsDownloadSilent()));
                    values.put("install_silent", Integer.valueOf(creativeInfo.getIsInstallSilent()));
                    values.put("deep_link", creativeInfo.getDeepLink());
                    values.put("click_through_url", creativeInfo.getClickThroughUrl());
                    values.put("open_browser", creativeInfo.getOpenBrowser());
                    values.put("last_show_time", Long.valueOf(creativeInfo.getLastShowTime()));
                    int result = this.saveOrUpdate("creative", "id", String.valueOf(index.getCreativeID()), values);
                    resultList.add(new CreativeStatusData(index.getCreativeID(), index.getCreativeVersion(), result));
                    ArrayList<ImgInfo> imgInfoList = new ArrayList<ImgInfo>();
                    ImgInfo icon = creativeInfo.getIcon();
                    if (null != icon) {
                        icon.setType("icon");
                        imgInfoList.add(icon);
                    }
                    if (null != (anonymousIcon = creativeInfo.getAnonymousIcon())) {
                        anonymousIcon.setType("anonymousIcon");
                        imgInfoList.add(anonymousIcon);
                    }
                    if (null != (logo = creativeInfo.getLogo())) {
                        logo.setType("logo");
                        imgInfoList.add(logo);
                    }
                    if (null != creativeInfo.getImages()) {
                        for (ImgInfo img : creativeInfo.getImages()) {
                            img.setType("image");
                            imgInfoList.add(img);
                        }
                    }
                    if (null != creativeInfo.getScreenShot()) {
                        for (ImgInfo screenshot : creativeInfo.getScreenShot()) {
                            screenshot.setType("screenshot");
                            imgInfoList.add(screenshot);
                        }
                    }
                    ArrayList<Object> dbImgUrlList = new ArrayList<Object>();
                    String[] dbImgColumns = new String[]{"url"};
                    String dbImgSelection = "cid = ?";
                    String[] dbImgSelectionArgs = new String[]{String.valueOf(index.getCreativeID())};
                    Cursor dbImgCursor = this.mDB.query("img_info", dbImgColumns, dbImgSelection, dbImgSelectionArgs, null, null, null);
                    if (dbImgCursor != null) {
                        if (dbImgCursor.getCount() > 0) {
                            while (dbImgCursor.moveToNext()) {
                                String dbImgUrl = dbImgCursor.getString(0);
                                if (TextUtils.isEmpty((CharSequence)dbImgUrl)) continue;
                                dbImgUrlList.add(dbImgUrl);
                            }
                        }
                        dbImgCursor.close();
                    }
                    for (ImgInfo img : imgInfoList) {
                        if (TextUtils.isEmpty((CharSequence)img.getUrl()) || TextUtils.isEmpty((CharSequence)img.getMd5())) continue;
                        if (dbImgUrlList.size() > 0 && dbImgUrlList.contains(img.getUrl())) {
                            dbImgUrlList.remove(img.getUrl());
                            continue;
                        }
                        ContentValues imgValues = new ContentValues();
                        imgValues.put("cid", Integer.valueOf(index.getCreativeID()));
                        imgValues.put("id", Integer.valueOf(img.getId()));
                        imgValues.put("url", img.getUrl());
                        imgValues.put("md5", img.getMd5());
                        imgValues.put("type", img.getType());
                        imgValues.put("weight", Integer.valueOf(creativeInfo.getWeight()));
                        imgValues.put("network", creativeInfo.getNetwork());
                        imgValues.put("cached_path", img.getCachedFilePath());
                        this.mDB.insert("img_info", null, imgValues);
                    }
                    if (dbImgUrlList.size() <= 0) continue;
                    StringBuilder oldImgWhereClause = new StringBuilder("url");
                    oldImgWhereClause.append(" in (");
                    oldImgWhereClause.append(this.buildMultiParamsCondition(dbImgUrlList.size()));
                    oldImgWhereClause.append(")");
                    this.mDB.delete("img_info", oldImgWhereClause.toString(), this.parseListToArray(dbImgUrlList));
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
        return resultList;
    }

    public List<CreativeInfo> getAllCachedCreativeInfo(int creativeType) {
        ArrayList<CreativeInfo> creativeInfoList = null;
        if (this.mDB != null) {
            Cursor cursor;
            String orderBy = "weight desc";
            if (0 == creativeType) {
                cursor = this.mDB.query("creative", DBData.Creative.ALL_COLUMNS, null, null, null, null, orderBy);
            } else {
                String selection = "type = ?";
                String[] selectionArgs = new String[]{String.valueOf(creativeType)};
                cursor = this.mDB.query("creative", DBData.Creative.ALL_COLUMNS, selection, selectionArgs, null, null, orderBy);
            }
            CS.log.d("TMS_SERVER", "getAllCachedCreativeInfo count:" + cursor.getCount());
            if (null != cursor) {
                if (cursor.getCount() > 0) {
                    creativeInfoList = new ArrayList<CreativeInfo>();
                    while (cursor.moveToNext()) {
                        CreativeInfo info = new CreativeInfo();
                        CreativeIndex index = new CreativeIndex();
                        index.setCreativeID(cursor.getInt(cursor.getColumnIndex("id")));
                        index.setCreativeVersion(cursor.getLong(cursor.getColumnIndex("version")));
                        info.setCreativeIndex(index);
                        int type = cursor.getInt(cursor.getColumnIndex("type"));
                        info.setCreativeType(type);
                        info.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                        info.setAnonymousTitle(cursor.getString(cursor.getColumnIndex("anon_title")));
                        info.setSubTitle(cursor.getString(cursor.getColumnIndex("sub_title")));
                        info.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                        info.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                        info.setRating(cursor.getString(cursor.getColumnIndex("rating")));
                        info.setLikes(cursor.getInt(cursor.getColumnIndex("likes")));
                        info.setConversion(cursor.getInt(cursor.getColumnIndex("conversion")));
                        info.setPrice(cursor.getString(cursor.getColumnIndex("price")));
                        info.setSalePrice(cursor.getString(cursor.getColumnIndex("sale_price")));
                        info.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                        info.setBrand(cursor.getString(cursor.getColumnIndex("brand")));
                        info.setSponsored(cursor.getString(cursor.getColumnIndex("sponsored")));
                        info.setAddress(cursor.getString(cursor.getColumnIndex("address")));
                        info.setShowUrl(cursor.getString(cursor.getColumnIndex("show_url")));
                        info.setImpressionTracker(cursor.getString(cursor.getColumnIndex("imp_tracker")));
                        info.setClickTracker(cursor.getString(cursor.getColumnIndex("click_tracker")));
                        info.setNetwork(cursor.getString(cursor.getColumnIndex("network")));
                        info.setCallToAction(cursor.getString(cursor.getColumnIndex("call_to_act")));
                        info.setExtention(cursor.getString(cursor.getColumnIndex("extention")));
                        info.setWhitelist(cursor.getString(cursor.getColumnIndex("whitelist")));
                        info.setBlacklist(cursor.getString(cursor.getColumnIndex("blacklist")));
                        info.setGrayStartTime(cursor.getString(cursor.getColumnIndex("gray_start_time")));
                        info.setGrayEndTime(cursor.getString(cursor.getColumnIndex("gray_end_time")));
                        info.setValidStartTime(cursor.getLong(cursor.getColumnIndex("valid_start_time")));
                        info.setValidEndTime(cursor.getLong(cursor.getColumnIndex("valid_end_time")));
                        info.setFrequencyType(cursor.getInt(cursor.getColumnIndex("freq_type")));
                        info.setFrequencyLimitCount(cursor.getInt(cursor.getColumnIndex("freq_limit_count")));
                        info.setFrequencyUsedTime(cursor.getInt(cursor.getColumnIndex("used_freq_count")));
                        info.setWeight(cursor.getInt(cursor.getColumnIndex("weight")));
                        info.setLastShowTime(cursor.getLong(cursor.getColumnIndex("last_show_time")));
                        if (type == 1) {
                            String[] appSelectionArgs;
                            String appSelection;
                            String[] appColumns;
                            Cursor appCursor;
                            info.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                            info.setIsDownloadSilent(cursor.getInt(cursor.getColumnIndex("download_silent")));
                            info.setIsInstallSilent(cursor.getInt(cursor.getColumnIndex("install_silent")));
                            if (info.getAppId() > 0 && (appCursor = this.mDB.query("app_detail", appColumns = new String[]{"app_id", "pkg_name", "version_code"}, appSelection = "app_id = ?", appSelectionArgs = new String[]{String.valueOf(info.getAppId())}, null, null, null)) != null) {
                                if (appCursor.getCount() > 0 && appCursor.moveToNext()) {
                                    info.setPkgName(appCursor.getString(appCursor.getColumnIndex("pkg_name")));
                                    info.setVersionCode(appCursor.getInt(appCursor.getColumnIndex("version_code")));
                                }
                                appCursor.close();
                            }
                        } else if (type == 2) {
                            info.setDeepLink(cursor.getString(cursor.getColumnIndex("deep_link")));
                            info.setClickThroughUrl(cursor.getString(cursor.getColumnIndex("click_through_url")));
                            info.setOpenBrowser(cursor.getString(cursor.getColumnIndex("open_browser")));
                        }
                        creativeInfoList.add(info);
                    }
                }
                cursor.close();
            }
            if (creativeInfoList != null) {
                Iterator iterator = creativeInfoList.iterator();
                while (iterator.hasNext()) {
                    CreativeInfo creativeInfo = (CreativeInfo)iterator.next();
                    CreativeIndex creativeInfoIndex = creativeInfo.getCreativeIndex();
                    if (null != creativeInfoIndex) {
                        boolean isCached = true;
                        String imgSelection = "cid = ?";
                        String[] imgSelectionArgs = new String[]{String.valueOf(creativeInfo.getCreativeIndex().getCreativeID())};
                        Cursor imgCursor = this.mDB.query("img_info", DBData.ImgInfo.ALL_COLUMNS, imgSelection, imgSelectionArgs, null, null, null);
                        if (imgCursor != null) {
                            if (imgCursor.getCount() > 0) {
                                while (imgCursor.moveToNext()) {
                                    ImgInfo img = new ImgInfo();
                                    img.setId(imgCursor.getInt(imgCursor.getColumnIndex("id")));
                                    img.setUrl(imgCursor.getString(imgCursor.getColumnIndex("url")));
                                    img.setMd5(imgCursor.getString(imgCursor.getColumnIndex("md5")));
                                    img.setType(imgCursor.getString(imgCursor.getColumnIndex("type")));
                                    img.setWeight(imgCursor.getInt(imgCursor.getColumnIndex("weight")));
                                    img.setNetwork(imgCursor.getString(imgCursor.getColumnIndex("network")));
                                    img.setCachedFilePath(imgCursor.getString(imgCursor.getColumnIndex("cached_path")));
                                    if (TextUtils.isEmpty((CharSequence)img.getCachedFilePath())) {
                                        isCached = false;
                                        break;
                                    }
                                    switch (img.getType()) {
                                        case "icon": {
                                            creativeInfo.setIcon(img);
                                            break;
                                        }
                                        case "anonymousIcon": {
                                            creativeInfo.setAnonymousIcon(img);
                                            break;
                                        }
                                        case "logo": {
                                            creativeInfo.setLogo(img);
                                            break;
                                        }
                                        case "image": {
                                            ArrayList<ImgInfo> imgList;
                                            if (creativeInfo.getImages() == null) {
                                                imgList = new ArrayList<ImgInfo>();
                                                imgList.add(img);
                                                creativeInfo.setImages(imgList);
                                                break;
                                            }
                                            creativeInfo.getImages().add(img);
                                            break;
                                        }
                                        case "screenshot": {
                                            ArrayList<ImgInfo> imgList;
                                            if (creativeInfo.getScreenShot() == null) {
                                                imgList = new ArrayList();
                                                imgList.add(img);
                                                creativeInfo.setScreenShot(imgList);
                                                break;
                                            }
                                            creativeInfo.getScreenShot().add(img);
                                            break;
                                        }
                                    }
                                }
                            }
                            imgCursor.close();
                        }
                        if (isCached) continue;
                        CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + " --- IMG NOT CACHED ---!!! \u79bb\u6709\u6548\u671f\u8fd8\u6709(\u8d1f\u6570\u4ee3\u8868\u624b\u673a\u65f6\u95f4\u8d85\u51fa\u6709\u6548\u671f)\uff1a" + (creativeInfo.getValidEndTime() - System.currentTimeMillis()));
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        return creativeInfoList;
    }

    public CreativeInfo getCreativeInfoById(int id) {
        String[] selectionArgs;
        String selection;
        Cursor cursor;
        CreativeInfo info = null;
        if (this.mDB != null && (cursor = this.mDB.query("creative", DBData.Creative.ALL_COLUMNS, selection = "id = ?", selectionArgs = new String[]{String.valueOf(id)}, null, null, null)) != null) {
            if (cursor.getCount() > 0 && cursor.moveToNext()) {
                info = new CreativeInfo();
                CreativeIndex index = new CreativeIndex();
                index.setCreativeID(cursor.getInt(cursor.getColumnIndex("id")));
                index.setCreativeVersion(cursor.getLong(cursor.getColumnIndex("version")));
                info.setCreativeIndex(index);
                int type = cursor.getInt(cursor.getColumnIndex("type"));
                info.setCreativeType(type);
                info.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                info.setAnonymousTitle(cursor.getString(cursor.getColumnIndex("anon_title")));
                info.setSubTitle(cursor.getString(cursor.getColumnIndex("sub_title")));
                info.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                info.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                info.setRating(cursor.getString(cursor.getColumnIndex("rating")));
                info.setLikes(cursor.getInt(cursor.getColumnIndex("likes")));
                info.setConversion(cursor.getInt(cursor.getColumnIndex("conversion")));
                info.setPrice(cursor.getString(cursor.getColumnIndex("price")));
                info.setSalePrice(cursor.getString(cursor.getColumnIndex("sale_price")));
                info.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                info.setBrand(cursor.getString(cursor.getColumnIndex("brand")));
                info.setSponsored(cursor.getString(cursor.getColumnIndex("sponsored")));
                info.setAddress(cursor.getString(cursor.getColumnIndex("address")));
                info.setShowUrl(cursor.getString(cursor.getColumnIndex("show_url")));
                info.setImpressionTracker(cursor.getString(cursor.getColumnIndex("imp_tracker")));
                info.setClickTracker(cursor.getString(cursor.getColumnIndex("click_tracker")));
                info.setNetwork(cursor.getString(cursor.getColumnIndex("network")));
                info.setCallToAction(cursor.getString(cursor.getColumnIndex("call_to_act")));
                info.setExtention(cursor.getString(cursor.getColumnIndex("extention")));
                info.setWhitelist(cursor.getString(cursor.getColumnIndex("whitelist")));
                info.setBlacklist(cursor.getString(cursor.getColumnIndex("blacklist")));
                info.setGrayStartTime(cursor.getString(cursor.getColumnIndex("gray_start_time")));
                info.setGrayEndTime(cursor.getString(cursor.getColumnIndex("gray_end_time")));
                info.setValidStartTime(cursor.getLong(cursor.getColumnIndex("valid_start_time")));
                info.setValidEndTime(cursor.getLong(cursor.getColumnIndex("valid_end_time")));
                info.setFrequencyType(cursor.getInt(cursor.getColumnIndex("freq_type")));
                info.setFrequencyLimitCount(cursor.getInt(cursor.getColumnIndex("freq_limit_count")));
                info.setWeight(cursor.getInt(cursor.getColumnIndex("weight")));
                info.setFrequencyUsedTime(cursor.getInt(cursor.getColumnIndex("used_freq_count")));
                info.setLastShowTime(cursor.getLong(cursor.getColumnIndex("last_show_time")));
                if (type == 1) {
                    info.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                    info.setIsDownloadSilent(cursor.getInt(cursor.getColumnIndex("download_silent")));
                    info.setIsInstallSilent(cursor.getInt(cursor.getColumnIndex("install_silent")));
                } else if (type == 2) {
                    info.setDeepLink(cursor.getString(cursor.getColumnIndex("deep_link")));
                    info.setClickThroughUrl(cursor.getString(cursor.getColumnIndex("click_through_url")));
                    info.setOpenBrowser(cursor.getString(cursor.getColumnIndex("open_browser")));
                }
                String imgSelection = "cid = ?";
                String[] imgSelectionArgs = new String[]{String.valueOf(index.getCreativeID())};
                Cursor imgCursor = this.mDB.query("img_info", DBData.ImgInfo.ALL_COLUMNS, imgSelection, imgSelectionArgs, null, null, null);
                if (imgCursor != null) {
                    if (imgCursor.getCount() > 0) {
                        while (imgCursor.moveToNext()) {
                            ImgInfo img = new ImgInfo();
                            img.setId(imgCursor.getInt(imgCursor.getColumnIndex("id")));
                            img.setUrl(imgCursor.getString(imgCursor.getColumnIndex("url")));
                            img.setMd5(imgCursor.getString(imgCursor.getColumnIndex("md5")));
                            img.setWeight(imgCursor.getInt(imgCursor.getColumnIndex("weight")));
                            img.setType(imgCursor.getString(imgCursor.getColumnIndex("type")));
                            img.setNetwork(imgCursor.getString(imgCursor.getColumnIndex("network")));
                            img.setCachedFilePath(imgCursor.getString(imgCursor.getColumnIndex("cached_path")));
                            switch (img.getType()) {
                                case "icon": {
                                    info.setIcon(img);
                                    break;
                                }
                                case "anonymousIcon": {
                                    info.setAnonymousIcon(img);
                                    break;
                                }
                                case "logo": {
                                    info.setLogo(img);
                                    break;
                                }
                                case "image": {
                                    ArrayList<ImgInfo> imgList;
                                    if (info.getImages() == null) {
                                        imgList = new ArrayList<ImgInfo>();
                                        imgList.add(img);
                                        info.setImages(imgList);
                                        break;
                                    }
                                    info.getImages().add(img);
                                    break;
                                }
                                case "screenshot": {
                                    ArrayList<ImgInfo> imgList;
                                    if (info.getScreenShot() == null) {
                                        imgList = new ArrayList();
                                        imgList.add(img);
                                        info.setScreenShot(imgList);
                                        break;
                                    }
                                    info.getScreenShot().add(img);
                                    break;
                                }
                            }
                        }
                    }
                    imgCursor.close();
                }
            }
            cursor.close();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateSdkAppConfigList(List<SdkAppConfig> sdkAppConfigList) {
        if (sdkAppConfigList != null && sdkAppConfigList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                for (SdkAppConfig sdkAppConfig : sdkAppConfigList) {
                    ContentValues values = new ContentValues();
                    values.put("pkg_name", sdkAppConfig.getSdkAppID().getPkgName());
                    values.put("sign_sha1", sdkAppConfig.getSdkAppID().getSignSha1());
                    values.put("code_version", Integer.valueOf(sdkAppConfig.getSdkAppID().getCodeVersion()));
                    values.put("type", Integer.valueOf(sdkAppConfig.getType()));
                    values.put("permission_list", sdkAppConfig.getPermissionList());
                    values.put("pid_list", sdkAppConfig.getPidList());
                    values.put("awake_start_time", Long.valueOf(sdkAppConfig.getAwakeStartDateRange()));
                    values.put("awake_end_time", Long.valueOf(sdkAppConfig.getaWakeEndDateRange()));
                    values.put("awake_interval", Integer.valueOf(sdkAppConfig.getAwakeInterval()));
                    values.put("awake_last_time", Long.valueOf(sdkAppConfig.getAwakeLastTime()));
                    values.put("fast_download", Integer.valueOf(sdkAppConfig.getFastDownload()));
                    values.put("traffic_remind", Integer.valueOf(sdkAppConfig.getTrafficRemind()));
                    this.saveOrUpdate("sdk_app_config", "pkg_name", sdkAppConfig.getSdkAppID().getPkgName(), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateAllSdkAppConfig(List<SdkAppConfig> sdkAppConfigList) {
        if (sdkAppConfigList != null && sdkAppConfigList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                for (SdkAppConfig sdkAppConfig : sdkAppConfigList) {
                    if (0 == sdkAppConfig.getStatus()) {
                        String whereClause = "pkg_name =? AND sign_sha1 =? ";
                        String[] reqData = new String[]{sdkAppConfig.getSdkAppID().getPkgName(), sdkAppConfig.getSdkAppID().getSignSha1()};
                        this.mDB.delete("sdk_app_config", whereClause, reqData);
                        continue;
                    }
                    ContentValues values = new ContentValues();
                    values.put("pkg_name", sdkAppConfig.getSdkAppID().getPkgName());
                    values.put("sign_sha1", sdkAppConfig.getSdkAppID().getSignSha1());
                    values.put("code_version", Integer.valueOf(sdkAppConfig.getSdkAppID().getCodeVersion()));
                    values.put("type", Integer.valueOf(sdkAppConfig.getType()));
                    values.put("permission_list", sdkAppConfig.getPermissionList());
                    values.put("pid_list", sdkAppConfig.getPidList());
                    values.put("awake_start_time", Long.valueOf(sdkAppConfig.getAwakeStartDateRange()));
                    values.put("awake_end_time", Long.valueOf(sdkAppConfig.getaWakeEndDateRange()));
                    values.put("awake_interval", Integer.valueOf(sdkAppConfig.getAwakeInterval()));
                    values.put("fast_download", Integer.valueOf(sdkAppConfig.getFastDownload()));
                    values.put("traffic_remind", Integer.valueOf(sdkAppConfig.getTrafficRemind()));
                    this.saveOrUpdate("sdk_app_config", "pkg_name", sdkAppConfig.getSdkAppID().getPkgName(), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    public List<SdkAppConfig> getAllSdkAppConfig() {
        String sql;
        Cursor cursor;
        ArrayList<SdkAppConfig> sdkAppConfigList = null;
        if (this.mDB != null && (cursor = this.mDB.rawQuery(sql = "select * from sdk_app_config", null)) != null) {
            if (cursor.getCount() > 0) {
                sdkAppConfigList = new ArrayList<SdkAppConfig>();
                while (cursor.moveToNext()) {
                    SdkAppConfig sdkAppConfig = new SdkAppConfig();
                    SdkAppID sdkAppID = new SdkAppID();
                    sdkAppID.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                    sdkAppID.setSignSha1(cursor.getString(cursor.getColumnIndex("sign_sha1")));
                    sdkAppID.setCodeVersion(cursor.getInt(cursor.getColumnIndex("code_version")));
                    sdkAppConfig.setSdkAppID(sdkAppID);
                    sdkAppConfig.setType(cursor.getInt(cursor.getColumnIndex("type")));
                    sdkAppConfig.setPermissionList(cursor.getString(cursor.getColumnIndex("permission_list")));
                    sdkAppConfig.setPidList(cursor.getString(cursor.getColumnIndex("pid_list")));
                    sdkAppConfig.setAwakeStartDateRange(cursor.getLong(cursor.getColumnIndex("awake_start_time")));
                    sdkAppConfig.setaWakeEndDateRange(cursor.getLong(cursor.getColumnIndex("awake_end_time")));
                    sdkAppConfig.setAwakeLastTime(cursor.getLong(cursor.getColumnIndex("awake_last_time")));
                    sdkAppConfig.setAwakeInterval(cursor.getInt(cursor.getColumnIndex("awake_interval")));
                    sdkAppConfig.setFastDownload(cursor.getInt(cursor.getColumnIndex("fast_download")));
                    sdkAppConfig.setTrafficRemind(cursor.getInt(cursor.getColumnIndex("traffic_remind")));
                    sdkAppConfigList.add(sdkAppConfig);
                }
            }
            cursor.close();
        }
        return sdkAppConfigList;
    }

    public SdkAppConfig getSdkAppConfigByPkgName(String pkgName, String sha1) {
        String[] args;
        String sql;
        Cursor cursor;
        SdkAppConfig sdkAppConfig = null;
        if (this.mDB != null && (cursor = this.mDB.rawQuery(sql = "select * from sdk_app_config where (pkg_name = ? AND sign_sha1 = ? )", args = new String[]{pkgName, sha1})) != null) {
            if (cursor.getCount() > 0 && cursor.moveToNext()) {
                sdkAppConfig = new SdkAppConfig();
                SdkAppID sdkAppID = new SdkAppID();
                sdkAppID.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                sdkAppID.setSignSha1(cursor.getString(cursor.getColumnIndex("sign_sha1")));
                sdkAppID.setCodeVersion(cursor.getInt(cursor.getColumnIndex("code_version")));
                sdkAppConfig.setSdkAppID(sdkAppID);
                sdkAppConfig.setType(cursor.getInt(cursor.getColumnIndex("type")));
                sdkAppConfig.setPermissionList(cursor.getString(cursor.getColumnIndex("permission_list")));
                sdkAppConfig.setPidList(cursor.getString(cursor.getColumnIndex("pid_list")));
                sdkAppConfig.setAwakeStartDateRange(cursor.getLong(cursor.getColumnIndex("awake_start_time")));
                sdkAppConfig.setaWakeEndDateRange(cursor.getLong(cursor.getColumnIndex("awake_end_time")));
                sdkAppConfig.setAwakeLastTime(cursor.getLong(cursor.getColumnIndex("awake_last_time")));
                sdkAppConfig.setAwakeInterval(cursor.getInt(cursor.getColumnIndex("awake_interval")));
                sdkAppConfig.setFastDownload(cursor.getInt(cursor.getColumnIndex("fast_download")));
                sdkAppConfig.setTrafficRemind(cursor.getInt(cursor.getColumnIndex("traffic_remind")));
            }
            cursor.close();
        }
        return sdkAppConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateImageCachedFilePath(String url, String cachedFilePath) {
        if (this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                ContentValues values = new ContentValues();
                values.put("cached_path", cachedFilePath);
                String whereClause = "url = ?";
                String[] whereArgs = new String[]{url};
                this.mDB.update("img_info", values, whereClause, whereArgs);
                CS.log.d("TMS_SERVER", "\u66f4\u65b0\u6210\u529f\uff0c url:" + url);
                this.mDB.setTransactionSuccessful();
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateAppDetailList(List<AppDetailInfo> appDetailInfoList, long validEndTime) {
        if (appDetailInfoList != null && appDetailInfoList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                    if (appDetailInfo == null || appDetailInfo.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)appDetailInfo.getPkgName()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getMd5()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getTitle()) || appDetailInfo.getIcon() == null || appDetailInfo.getApkScreenshotImgList() == null || appDetailInfo.getApkScreenshotImgList().size() == 0 || appDetailInfo.getImages() == null || appDetailInfo.getImages().size() == 0) continue;
                    ContentValues values = new ContentValues();
                    values.put("app_id", Integer.valueOf(appDetailInfo.getAppId()));
                    values.put("title", appDetailInfo.getTitle());
                    values.put("desc_version", Integer.valueOf(appDetailInfo.getDescVersion()));
                    values.put("sub_desc", appDetailInfo.getSubDescription());
                    values.put("desc", appDetailInfo.getDescription());
                    values.put("icon", Tson.toJson((Object)appDetailInfo.getIcon()));
                    values.put("screenshots", Tson.toJson((Object)appDetailInfo.getApkScreenshotImgList()));
                    values.put("images", Tson.toJson((Object)appDetailInfo.getImages()));
                    values.put("category", Integer.valueOf(appDetailInfo.getCategory()));
                    values.put("website", appDetailInfo.getWebsite());
                    values.put("email", appDetailInfo.getEmail());
                    values.put("phone", appDetailInfo.getPhone());
                    values.put("policy", appDetailInfo.getPolicy());
                    values.put("whats_new", appDetailInfo.getWhatNew());
                    values.put("download_url", appDetailInfo.getDownloadUrl());
                    values.put("pkg_name", appDetailInfo.getPkgName());
                    values.put("version_name", appDetailInfo.getVersionName());
                    values.put("version_code", Integer.valueOf(appDetailInfo.getVersionCode()));
                    values.put("size", Long.valueOf(appDetailInfo.getSize()));
                    values.put("md5", appDetailInfo.getMd5());
                    values.put("valid_end_time", Long.valueOf(validEndTime));
                    this.saveOrUpdate("app_detail", "app_id", String.valueOf(appDetailInfo.getAppId()), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateOsLabAppDetailList(List<AppDetailInfo> appDetailInfoList, long validEndTime) {
        if (appDetailInfoList != null && appDetailInfoList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                    if (appDetailInfo.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)appDetailInfo.getPkgName()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getMd5()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getTitle())) continue;
                    ContentValues values = new ContentValues();
                    values.put("app_id", Integer.valueOf(appDetailInfo.getAppId()));
                    values.put("title", appDetailInfo.getTitle());
                    values.put("desc_version", Integer.valueOf(appDetailInfo.getDescVersion()));
                    values.put("sub_desc", appDetailInfo.getSubDescription());
                    values.put("desc", appDetailInfo.getDescription());
                    values.put("icon", Tson.toJson((Object)appDetailInfo.getIcon()));
                    values.put("screenshots", Tson.toJson((Object)appDetailInfo.getApkScreenshotImgList()));
                    values.put("images", Tson.toJson((Object)appDetailInfo.getImages()));
                    values.put("category", Integer.valueOf(appDetailInfo.getCategory()));
                    values.put("website", appDetailInfo.getWebsite());
                    values.put("email", appDetailInfo.getEmail());
                    values.put("phone", appDetailInfo.getPhone());
                    values.put("policy", appDetailInfo.getPolicy());
                    values.put("whats_new", appDetailInfo.getWhatNew());
                    values.put("download_url", appDetailInfo.getDownloadUrl());
                    values.put("pkg_name", appDetailInfo.getPkgName());
                    values.put("version_name", appDetailInfo.getVersionName());
                    values.put("version_code", Integer.valueOf(appDetailInfo.getVersionCode()));
                    values.put("size", Long.valueOf(appDetailInfo.getSize()));
                    values.put("md5", appDetailInfo.getMd5());
                    values.put("valid_end_time", Long.valueOf(validEndTime));
                    this.saveOrUpdate("os_lab_app_detail", "app_id", String.valueOf(appDetailInfo.getAppId()), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    public AppDetailInfo getAppDetailInfobyAppId(String AppId) {
        ArrayList<String> appIdList = new ArrayList<String>(1);
        appIdList.add(AppId);
        List<AppDetailInfo> appDetailList = this.getAppDetailListByAppIdList(appIdList);
        if (appDetailList != null && appDetailList.size() > 0) {
            return appDetailList.get(0);
        }
        return null;
    }

    public List<AppDetailInfo> getAppDetailListByAppIdList(List<String> appIdList) {
        ArrayList<AppDetailInfo> appDetailList = null;
        if (appIdList != null && appIdList.size() > 0) {
            String condition = this.buildMultiParamsCondition(appIdList.size());
            String[] args = this.parseListToArray(appIdList);
            String sql = "select * from app_detail where app_id in (" + condition + ") ";
            Cursor cursor = this.mDB.rawQuery(sql, args);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    appDetailList = new ArrayList<AppDetailInfo>();
                    while (cursor.moveToNext()) {
                        AppDetailInfo app = new AppDetailInfo();
                        app.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                        app.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                        app.setDescVersion(cursor.getInt(cursor.getColumnIndex("desc_version")));
                        app.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                        app.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                        app.setIcon((ImgInfo)Tson.fromJson((String)cursor.getString(cursor.getColumnIndex("icon")), ImgInfo.class));
                        ArrayList<ImgInfo> screenshotList = null;
                        try {
                            screenshotList = new ArrayList<ImgInfo>();
                            JSONArray screenshotJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("screenshots")));
                            for (int i = 0; i < screenshotJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)screenshotJsonArray.getString(i), ImgInfo.class);
                                screenshotList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "screenshot parse exception");
                        }
                        app.setApkScreenshotImgList(screenshotList);
                        ArrayList<ImgInfo> imageList = null;
                        try {
                            imageList = new ArrayList<ImgInfo>();
                            JSONArray imageJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("images")));
                            for (int i = 0; i < imageJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)imageJsonArray.getString(i), ImgInfo.class);
                                imageList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "image list parse exception");
                        }
                        app.setImages(imageList);
                        app.setCategory(cursor.getInt(cursor.getColumnIndex("category")));
                        app.setWebsite(cursor.getString(cursor.getColumnIndex("website")));
                        app.setEmail(cursor.getString(cursor.getColumnIndex("email")));
                        app.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                        app.setPolicy(cursor.getString(cursor.getColumnIndex("policy")));
                        app.setWhatNew(cursor.getString(cursor.getColumnIndex("whats_new")));
                        app.setDownloadUrl(cursor.getString(cursor.getColumnIndex("download_url")));
                        app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                        app.setVersionName(cursor.getString(cursor.getColumnIndex("version_name")));
                        app.setVersionCode(cursor.getInt(cursor.getColumnIndex("version_code")));
                        app.setSize(cursor.getLong(cursor.getColumnIndex("size")));
                        app.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                        appDetailList.add(app);
                    }
                }
                cursor.close();
            }
        }
        return appDetailList;
    }

    public List<Integer> getAllAppDetailInfoId() {
        String[] columns;
        Cursor cursor;
        ArrayList<Integer> appIdList = null;
        if (this.mDB != null && (cursor = this.mDB.query("app_detail", columns = new String[]{"app_id"}, null, null, null, null, null)) != null) {
            if (cursor.getCount() > 0) {
                appIdList = new ArrayList<Integer>();
                while (cursor.moveToNext()) {
                    int appId = cursor.getInt(cursor.getColumnIndex("app_id"));
                    if (appId <= 0) continue;
                    appIdList.add(appId);
                }
            }
            cursor.close();
        }
        return appIdList;
    }

    public List<AppDetailInfo> getOsLabAppDetailListByAppIdList(List<String> appIdList) {
        ArrayList<AppDetailInfo> appDetailList = null;
        if (appIdList != null && appIdList.size() > 0) {
            String condition = this.buildMultiParamsCondition(appIdList.size());
            String[] args = this.parseListToArray(appIdList);
            String sql = "select * from os_lab_app_detail where app_id in (" + condition + ") ";
            Cursor cursor = this.mDB.rawQuery(sql, args);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    appDetailList = new ArrayList<AppDetailInfo>();
                    while (cursor.moveToNext()) {
                        AppDetailInfo app = new AppDetailInfo();
                        app.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                        app.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                        app.setDescVersion(cursor.getInt(cursor.getColumnIndex("desc_version")));
                        app.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                        app.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                        app.setIcon((ImgInfo)Tson.fromJson((String)cursor.getString(cursor.getColumnIndex("icon")), ImgInfo.class));
                        ArrayList<ImgInfo> screenshotList = null;
                        try {
                            screenshotList = new ArrayList<ImgInfo>();
                            JSONArray screenshotJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("screenshots")));
                            for (int i = 0; i < screenshotJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)screenshotJsonArray.getString(i), ImgInfo.class);
                                screenshotList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "screenshot parse exception");
                        }
                        app.setApkScreenshotImgList(screenshotList);
                        ArrayList<ImgInfo> imageList = null;
                        try {
                            imageList = new ArrayList<ImgInfo>();
                            JSONArray imageJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("images")));
                            for (int i = 0; i < imageJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)imageJsonArray.getString(i), ImgInfo.class);
                                imageList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "image list parse exception");
                        }
                        app.setImages(imageList);
                        app.setCategory(cursor.getInt(cursor.getColumnIndex("category")));
                        app.setWebsite(cursor.getString(cursor.getColumnIndex("website")));
                        app.setEmail(cursor.getString(cursor.getColumnIndex("email")));
                        app.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                        app.setPolicy(cursor.getString(cursor.getColumnIndex("policy")));
                        app.setWhatNew(cursor.getString(cursor.getColumnIndex("whats_new")));
                        app.setDownloadUrl(cursor.getString(cursor.getColumnIndex("download_url")));
                        app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                        app.setVersionName(cursor.getString(cursor.getColumnIndex("version_name")));
                        app.setVersionCode(cursor.getInt(cursor.getColumnIndex("version_code")));
                        app.setSize(cursor.getLong(cursor.getColumnIndex("size")));
                        app.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                        appDetailList.add(app);
                    }
                }
                cursor.close();
            }
        }
        return appDetailList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteCreativeByIds(List<CreativeIndex> deleteCreativeList) {
        if (deleteCreativeList != null && deleteCreativeList.size() > 0 && this.mDB != null) {
            String creativeWhereClause = null;
            String[] creativeIds = this.parseListToArray(deleteCreativeList);
            String imgInfoWhereClause = null;
            String condition = this.buildMultiParamsCondition(deleteCreativeList.size());
            creativeWhereClause = "id in (" + condition + ")";
            imgInfoWhereClause = "cid in (" + condition + ")";
            this.mDB.beginTransaction();
            try {
                this.mDB.delete("creative", creativeWhereClause, creativeIds);
                this.mDB.delete("img_info", imgInfoWhereClause, creativeIds);
                for (CreativeIndex creativeIndex : deleteCreativeList) {
                    ContentValues values = new ContentValues();
                    values.put("id", Integer.valueOf(creativeIndex.getCreativeID()));
                    values.put("version", Long.valueOf(creativeIndex.getCreativeVersion()));
                    values.put("save_time", Long.valueOf(System.currentTimeMillis()));
                    this.saveOrUpdate("del_creative", "id", String.valueOf(creativeIndex.getCreativeID()), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAppDetailById(int appId) {
        if (this.mDB != null && appId > 0) {
            this.mDB.beginTransaction();
            try {
                ArrayList<CreativeIndex> creativeIndexList = null;
                String[] columns = new String[]{"id", "version"};
                String selection = "app_id = ?";
                String[] selectionArgs = new String[]{String.valueOf(appId)};
                Cursor cursor = this.mDB.query("creative", columns, selection, selectionArgs, null, null, null);
                if (cursor != null) {
                    if (cursor.getCount() > 0) {
                        creativeIndexList = new ArrayList<CreativeIndex>();
                        while (cursor.moveToNext()) {
                            CreativeIndex creativeIndex = new CreativeIndex();
                            creativeIndex.setCreativeID(cursor.getInt(cursor.getColumnIndex("id")));
                            creativeIndex.setCreativeVersion(cursor.getLong(cursor.getColumnIndex("version")));
                            creativeIndexList.add(creativeIndex);
                        }
                    }
                    cursor.close();
                }
                if (creativeIndexList != null && creativeIndexList.size() > 0) {
                    String condition = this.buildMultiParamsCondition(creativeIndexList.size());
                    String creativeWhereClause = "id in (" + condition + ")";
                    String imgWhereClause = "cid in (" + condition + ")";
                    String[] creativeIds = this.parseListToArray(creativeIndexList);
                    this.mDB.delete("creative", creativeWhereClause, creativeIds);
                    this.mDB.delete("img_info", imgWhereClause, creativeIds);
                    for (CreativeIndex creativeIndex : creativeIndexList) {
                        ContentValues values = new ContentValues();
                        values.put("id", Integer.valueOf(creativeIndex.getCreativeID()));
                        values.put("version", Long.valueOf(creativeIndex.getCreativeVersion()));
                        values.put("save_time", Long.valueOf(System.currentTimeMillis()));
                        this.saveOrUpdate("del_creative", "id", String.valueOf(creativeIndex.getCreativeID()), values);
                    }
                } else {
                    String appWhereClause = "app_id = ?";
                    String[] appWhereArgs = new String[]{String.valueOf(appId)};
                    this.mDB.delete("app_detail", appWhereClause, appWhereArgs);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    public void deleteAppDetailByUrl(String url) {
        if (this.mDB != null && !TextUtils.isEmpty((CharSequence)url)) {
            Integer appId = null;
            String[] columns = new String[]{"app_id"};
            String selection = "download_url = ?";
            String[] selectionArgs = new String[]{url};
            Cursor cursor = this.mDB.query("app_detail", columns, selection, selectionArgs, null, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0 && cursor.moveToNext()) {
                    appId = cursor.getInt(cursor.getColumnIndex("app_id"));
                }
                cursor.close();
            }
            if (appId != null && appId > 0) {
                this.deleteAppDetailById(appId);
            }
        }
    }

    public void deleteOsLabAppDetailByUrl(String url) {
        if (this.mDB != null && !TextUtils.isEmpty((CharSequence)url)) {
            Integer appId = null;
            String[] columns = new String[]{"app_id"};
            String selection = "download_url = ?";
            String[] selectionArgs = new String[]{url};
            Cursor cursor = this.mDB.query("os_lab_app_detail", columns, selection, selectionArgs, null, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0 && cursor.moveToNext()) {
                    appId = cursor.getInt(cursor.getColumnIndex("app_id"));
                }
                cursor.close();
            }
            if (appId != null && appId > 0) {
                this.deleteAppDetailById(appId);
            }
        }
    }

    public void deleteCreativeByImageUrl(String url) {
        String[] selectionArgs;
        String selection;
        String[] columns;
        Cursor cursor;
        if (this.mDB != null && !TextUtils.isEmpty((CharSequence)url) && (cursor = this.mDB.query("img_info", columns = new String[]{"cid"}, selection = "url = ?", selectionArgs = new String[]{url}, null, null, null)) != null) {
            int creativeId;
            if (cursor.getCount() > 0 && cursor.moveToNext() && (creativeId = cursor.getInt(cursor.getColumnIndex("cid"))) > 0) {
                CreativeIndex creativeIndex = new CreativeIndex();
                creativeIndex.setCreativeID(creativeId);
                ArrayList<CreativeIndex> delCreativeList = new ArrayList<CreativeIndex>();
                delCreativeList.add(creativeIndex);
                this.deleteCreativeByIds(delCreativeList);
            }
            cursor.close();
        }
    }

    public List<ImgInfoDL> getNotCachedImgInfoListByWeight() {
        String orderBy;
        String selection;
        Cursor cursor;
        ArrayList<ImgInfoDL> imgInfoList = null;
        if (this.mDB != null && (cursor = this.mDB.query("img_info", DBData.ImgInfo.ALL_COLUMNS, selection = "cached_path is NULL", null, null, null, orderBy = "weight desc")) != null) {
            if (cursor.getCount() > 0) {
                imgInfoList = new ArrayList<ImgInfoDL>();
                while (cursor.moveToNext()) {
                    String subSelection = "id =? AND valid_end_time <? ";
                    int id = cursor.getInt(cursor.getColumnIndex("cid"));
                    String[] subSelectionArgs = new String[]{String.valueOf(id), String.valueOf(System.currentTimeMillis())};
                    Cursor subCursor = this.mDB.query("creative", DBData.Creative.ALL_COLUMNS, subSelection, subSelectionArgs, null, null, null);
                    if (null != subCursor) {
                        if (subCursor.getCount() > 0) continue;
                        subCursor.close();
                    }
                    ImgInfoDL imgInfo = new ImgInfoDL();
                    imgInfo.setCID(cursor.getInt(cursor.getColumnIndex("cid")));
                    imgInfo.setId(cursor.getInt(cursor.getColumnIndex("id")));
                    imgInfo.setUrl(cursor.getString(cursor.getColumnIndex("url")));
                    imgInfo.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                    imgInfo.setWeight(cursor.getInt(cursor.getColumnIndex("weight")));
                    imgInfo.setType(cursor.getString(cursor.getColumnIndex("type")));
                    imgInfo.setNetwork(cursor.getString(cursor.getColumnIndex("network")));
                    imgInfo.setCachedFilePath(cursor.getString(cursor.getColumnIndex("cached_path")));
                    imgInfoList.add(imgInfo);
                }
            }
            cursor.close();
        }
        return imgInfoList;
    }

    public List<ImgInfo> getImgInfoByCreativeIds(List<CreativeIndex> creativeIndexList) {
        String[] selectionArgs;
        String selection;
        String[] columns;
        Cursor cursor;
        ArrayList<ImgInfo> imgList = null;
        if (this.mDB != null && creativeIndexList != null && creativeIndexList.size() > 0 && (cursor = this.mDB.query("img_info", columns = DBData.ImgInfo.ALL_COLUMNS, selection = "cid in (" + this.buildMultiParamsCondition(creativeIndexList.size()) + ")", selectionArgs = this.parseListToArray(creativeIndexList), null, null, null)) != null) {
            if (cursor.getCount() > 0) {
                imgList = new ArrayList<ImgInfo>();
                while (cursor.moveToNext()) {
                    ImgInfo imgInfo = new ImgInfo();
                    imgInfo.setId(cursor.getInt(cursor.getColumnIndex("id")));
                    imgInfo.setUrl(cursor.getString(cursor.getColumnIndex("url")));
                    imgInfo.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                    imgInfo.setWeight(cursor.getInt(cursor.getColumnIndex("weight")));
                    imgInfo.setType(cursor.getString(cursor.getColumnIndex("type")));
                    imgInfo.setNetwork(cursor.getString(cursor.getColumnIndex("network")));
                    imgInfo.setCachedFilePath(cursor.getString(cursor.getColumnIndex("cached_path")));
                    imgList.add(imgInfo);
                }
            }
            cursor.close();
        }
        return imgList;
    }

    public List<CreativeIndex> getAllCachedCreativeIndex() {
        String[] columns;
        Cursor cursor;
        ArrayList<CreativeIndex> indexList = null;
        if (this.mDB != null && (cursor = this.mDB.query("creative", columns = new String[]{"id", "version"}, null, null, null, null, null)) != null) {
            if (cursor.getCount() > 0) {
                indexList = new ArrayList<CreativeIndex>();
                while (cursor.moveToNext()) {
                    CreativeIndex index = new CreativeIndex();
                    index.setCreativeID(cursor.getInt(cursor.getColumnIndex("id")));
                    index.setCreativeVersion(cursor.getLong(cursor.getColumnIndex("version")));
                    indexList.add(index);
                }
            }
            cursor.close();
        }
        return indexList;
    }

    public List<SdkAppID> getAllSdkAppID() {
        String[] columns;
        Cursor cursor;
        ArrayList<SdkAppID> appList = null;
        if (this.mDB != null && (cursor = this.mDB.query("sdk_app_config", columns = new String[]{"pkg_name", "sign_sha1", "code_version"}, null, null, null, null, null)) != null) {
            if (cursor.getCount() > 0) {
                appList = new ArrayList<SdkAppID>();
                while (cursor.moveToNext()) {
                    SdkAppID app = new SdkAppID();
                    app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                    app.setSignSha1(cursor.getString(cursor.getColumnIndex("sign_sha1")));
                    app.setCodeVersion(cursor.getInt(cursor.getColumnIndex("code_version")));
                    appList.add(app);
                }
            }
            cursor.close();
        }
        return appList;
    }

    public List<CreativeIndex> getDeleteCreativeList(int count) {
        String orderBy;
        String[] columns;
        Cursor cursor;
        List<CreativeIndex> deleteIndexList = null;
        if (count > 0 && this.mDB != null && (cursor = this.mDB.query("del_creative", columns = new String[]{"id", "version"}, null, null, null, null, orderBy = "save_time desc")) != null) {
            if (cursor.getCount() > 0) {
                deleteIndexList = new ArrayList();
                while (cursor.moveToNext()) {
                    CreativeIndex index = new CreativeIndex();
                    index.setCreativeID(cursor.getInt(cursor.getColumnIndex("id")));
                    index.setCreativeVersion(cursor.getLong(cursor.getColumnIndex("version")));
                    deleteIndexList.add(index);
                }
                if (deleteIndexList.size() > count) {
                    deleteIndexList = deleteIndexList.subList(0, count);
                }
            }
            cursor.close();
        }
        return deleteIndexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearInvalidAppDetail() {
        if (this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                String whereClause = "valid_end_time < ? and valid_end_time != 0";
                String[] whereArgs = new String[]{String.valueOf(System.currentTimeMillis())};
                this.mDB.delete("app_detail", whereClause, whereArgs);
                String sql = "delete from app_detail where valid_end_time = 0 and app_id not in (select app_id from creative)";
                this.mDB.execSQL(sql);
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    public List<AppDetailInfo> getInvalidAppDetailList() {
        ArrayList<AppDetailInfo> appDetailList = null;
        if (this.mDB != null) {
            String selection = "valid_end_time < ? and valid_end_time != 0";
            String[] selectionArgs = new String[]{String.valueOf(System.currentTimeMillis())};
            Cursor cursor = this.mDB.query("app_detail", DBData.AppDetail.ALL_COLUMNS, selection, selectionArgs, null, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    appDetailList = new ArrayList<AppDetailInfo>();
                    while (cursor.moveToNext()) {
                        AppDetailInfo app = new AppDetailInfo();
                        app.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                        app.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                        app.setDescVersion(cursor.getInt(cursor.getColumnIndex("desc_version")));
                        app.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                        app.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                        app.setIcon((ImgInfo)Tson.fromJson((String)cursor.getString(cursor.getColumnIndex("icon")), ImgInfo.class));
                        ArrayList<ImgInfo> screenshotList = null;
                        try {
                            screenshotList = new ArrayList<ImgInfo>();
                            JSONArray screenshotJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("screenshots")));
                            for (int i = 0; i < screenshotJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)screenshotJsonArray.getString(i), ImgInfo.class);
                                screenshotList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "screenshot parse exception");
                        }
                        app.setApkScreenshotImgList(screenshotList);
                        ArrayList<ImgInfo> imageList = null;
                        try {
                            imageList = new ArrayList<ImgInfo>();
                            JSONArray imageJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("images")));
                            for (int i = 0; i < imageJsonArray.length(); ++i) {
                                ImgInfo img = (ImgInfo)Tson.fromJson((String)imageJsonArray.getString(i), ImgInfo.class);
                                imageList.add(img);
                            }
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", "image list parse exception");
                        }
                        app.setImages(imageList);
                        app.setCategory(cursor.getInt(cursor.getColumnIndex("category")));
                        app.setWebsite(cursor.getString(cursor.getColumnIndex("website")));
                        app.setEmail(cursor.getString(cursor.getColumnIndex("email")));
                        app.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                        app.setPolicy(cursor.getString(cursor.getColumnIndex("policy")));
                        app.setWhatNew(cursor.getString(cursor.getColumnIndex("whats_new")));
                        app.setDownloadUrl(cursor.getString(cursor.getColumnIndex("download_url")));
                        app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                        app.setVersionName(cursor.getString(cursor.getColumnIndex("version_name")));
                        app.setVersionCode(cursor.getInt(cursor.getColumnIndex("version_code")));
                        app.setSize(cursor.getLong(cursor.getColumnIndex("size")));
                        app.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                        appDetailList.add(app);
                    }
                }
                cursor.close();
            }
        }
        return appDetailList;
    }

    public synchronized void clearInvalidOsLanAppDetail() {
        if (this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                String whereClause = "valid_end_time < ? and valid_end_time != 0";
                String[] whereArgs = new String[]{String.valueOf(System.currentTimeMillis())};
                this.mDB.delete("os_lab_app_detail", whereClause, whereArgs);
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("TMS_SERVER", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    private int saveOrUpdate(String table, String keyField, String keyValue, ContentValues values) {
        int result = -1;
        if (this.mDB != null && !TextUtils.isEmpty((CharSequence)table) && values != null) {
            String[] args;
            String whereClause = keyField + " = ?";
            String sql = "select * from " + table + " where " + whereClause;
            Cursor cursor = this.mDB.rawQuery(sql, args = new String[]{keyValue});
            if (cursor != null && cursor.getCount() > 0) {
                this.mDB.update(table, values, whereClause, args);
                result = 2;
            } else {
                this.mDB.insert(table, null, values);
                result = 1;
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    private String buildMultiParamsCondition(int count) {
        if (count <= 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(",?");
        }
        builder.deleteCharAt(0);
        return builder.toString();
    }

    private String[] parseListToArray(List list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        String[] args = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof Integer) {
                args[i] = String.valueOf((Integer)obj);
                continue;
            }
            if (obj instanceof String) {
                args[i] = (String)obj;
                continue;
            }
            if (!(obj instanceof CreativeIndex)) continue;
            CreativeIndex index = (CreativeIndex)obj;
            args[i] = String.valueOf(index.getCreativeID());
        }
        return args;
    }
}

