/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download;

import android.content.ContentValues;
import android.text.TextUtils;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.CoreDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.AppSilentDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppSilentDownLoadTask;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;

public final class DownloadHelper {
    private DownloadHelper() {
    }

    public static DownloadHelper getInstance() {
        return SingletonHolder.sInstance;
    }

    public void addAppDownload(AppDownLoadTask task, boolean onlyMedia) {
        AppDownloadTaskManager dtm = AppDownloadTaskManager.getInstance(CoreUtil.getContext());
        AppDownLoadTask oldTask = dtm.queryByAppId(task, task.appId);
        if (TextUtils.isEmpty((CharSequence)oldTask.url)) {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u65b0\u4efb\u52a1\uff0c url:" + task.url);
            if (!onlyMedia) {
                dtm.insertDownload(task);
            }
        } else {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u7684\u4efb\u52a1\u5b58\u5728");
            if (task.appVersionCode != oldTask.appVersionCode) {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\uff0cstate:" + (Object)((Object)oldTask.downloadState));
                if (oldTask.downloadState != DownloadState.DOWNLOADING) {
                    dtm.deleteDownload(oldTask);
                    FileUtil.deleteFile(oldTask.filePath + ".tmp");
                    task.finishedSize = oldTask.finishedSize;
                    task.downloadState = DownloadState.FAILED;
                    dtm.insertDownload(task);
                }
            } else {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\u8be6\u60c5");
                if (!task.description.equals(oldTask.description)) {
                    ContentValues values = new ContentValues();
                    values.put("description", task.description);
                    dtm.updateDownloadTask(task, values);
                }
            }
        }
    }

    public void addOsLabAppDownload(OsLabAppDownLoadTask task, boolean onlyMedia) {
        AppDownloadTaskManager dtm = AppDownloadTaskManager.getInstance(CoreUtil.getContext());
        OsLabAppDownLoadTask oldTask = dtm.queryByAppId(task, task.appId);
        OsLabAppDownLoadTask oldTask1 = dtm.queryByPkgName(task, task.pkgName);
        if (oldTask1 != null && !TextUtils.isEmpty((CharSequence)oldTask1.pkgName) && oldTask1.pkgName.equals(task.pkgName)) {
            if (task.appVersionCode <= oldTask1.appVersionCode) {
                return;
            }
            if (oldTask == null || TextUtils.isEmpty((CharSequence)oldTask.url)) {
                oldTask = oldTask1;
            }
        }
        if (oldTask == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)oldTask.url)) {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u65b0\u4efb\u52a1\uff0c url:" + task.url);
            if (!onlyMedia) {
                dtm.insertDownload(task);
            }
        } else {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u7684\u4efb\u52a1\u5b58\u5728");
            if (task.appVersionCode != oldTask.appVersionCode) {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\uff0cstate:" + (Object)((Object)oldTask.downloadState));
                if (oldTask.downloadState != DownloadState.DOWNLOADING) {
                    dtm.deleteDownload(oldTask);
                    FileUtil.deleteFile(oldTask.filePath + ".tmp");
                    dtm.insertDownload(task);
                }
            } else {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\u8be6\u60c5");
                if (!task.description.equals(oldTask.description)) {
                    ContentValues values = new ContentValues();
                    values.put("description", task.description);
                    dtm.updateDownloadTask(task, values);
                }
            }
        }
    }

    public void addAppDownload(AppDownLoadTask task) {
        this.addAppDownload(task, false);
    }

    public void addOsLabAppDownload(OsLabAppDownLoadTask task) {
        this.addOsLabAppDownload(task, false);
    }

    public void addSilentDownLoad(AppSilentDownLoadTask task) {
        CoreDownloadTaskManager dtm = CoreDownloadTaskManager.getInstance(CoreUtil.getContext());
        AppSilentDownLoadTask oldTask = dtm.queryByAppId(task, task.appId);
        if (TextUtils.isEmpty((CharSequence)oldTask.url)) {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u9759\u9ed8\u65b0\u4efb\u52a1\uff0c url:" + task.url);
            dtm.insertDownload(task);
        } else {
            CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u9759\u9ed8\u4efb\u52a1\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\uff0cstate:" + (Object)((Object)oldTask.downloadState));
            if (task.appVersionCode != oldTask.appVersionCode && oldTask.downloadState != DownloadState.DOWNLOADING) {
                dtm.deleteDownload(oldTask);
                FileUtil.deleteFile(oldTask.filePath + ".tmp");
                dtm.insertDownload(task);
            }
        }
    }

    public void addOSLabSilentDownLoad(OsLabAppSilentDownLoadTask task) {
        CoreDownloadTaskManager dtm = CoreDownloadTaskManager.getInstance(CoreUtil.getContext());
        OsLabAppSilentDownLoadTask oldTask = dtm.queryByAppId(task, task.appId);
        if (TextUtils.isEmpty((CharSequence)oldTask.url)) {
            CS.log.d("TMS_MEDIA", "\u589e\u52a0\u9759\u9ed8\u65b0\u4efb\u52a1\uff0c url:" + task.url);
            dtm.insertDownload(task);
        } else {
            CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u9759\u9ed8\u4efb\u52a1\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u66f4\u65b0\uff0cstate:" + (Object)((Object)oldTask.downloadState));
            if (task.appVersionCode != oldTask.appVersionCode && oldTask.downloadState != DownloadState.DOWNLOADING) {
                dtm.deleteDownload(oldTask);
                FileUtil.deleteFile(oldTask.filePath + ".tmp");
                dtm.insertDownload(task);
            }
        }
    }

    public void deleteAppDownload(AppDownLoadTask task) {
        AppDownloadTaskManager dtm = AppDownloadTaskManager.getInstance(CoreUtil.getContext());
        AppDownLoadTask oldTask = dtm.queryByAppId(task, task.appId);
        if (TextUtils.isEmpty((CharSequence)oldTask.url)) {
            CS.log.d("TMS_MEDIA", "\u8981\u5220\u9664\u7684\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c url:" + task.url);
        } else {
            CS.log.d("TMS_MEDIA", "\u8981\u5220\u9664\u7684\u4efb\u52a1\u5b58\u5728");
            if (task.appVersionCode != oldTask.appVersionCode) {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5220\u9664");
            } else {
                CS.log.d("TMS_MEDIA", "\u65b0\u65e7\u4efb\u52a1\u7248\u672c\u4e00\u81f4\uff0c\u51c6\u5907\u5220\u9664\uff0cstate:" + (Object)((Object)oldTask.downloadState));
                if (oldTask.downloadState == null || oldTask.downloadState == DownloadState.INITIAL) {
                    dtm.deleteDownload(oldTask);
                }
            }
        }
    }

    private static class SingletonHolder {
        private static DownloadHelper sInstance = new DownloadHelper();

        private SingletonHolder() {
        }
    }
}

