/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.download.DownloadCallbackInterface;
import com.transsion.appupdate.download.DownloadOperator;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.db.DownloadDao;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.AppSilentDownLoadTask;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.reportBean.AppDownloadEvent;
import com.transsion.appupdate.service.UiService;
import com.transsion.appupdate.utils.FileProviderUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.InstallUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.log.CS;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class DownloadTaskManager<E extends DownloadTask> {
    protected Context mContext;
    public static final int URL_ERROR = -1;
    public static final int STORAGE_ERROR = -2;
    public static final int START_DOWNLOADED = 0;
    protected HashMap<String, DownloadOperator> mDownloadMap = new HashMap();
    protected List<IDownloadListener> mDownloadListeners = new ArrayList<IDownloadListener>();
    protected DownloadDao mDownloadDao;
    private DownloadCallbackInterface mDownloadCallbackInterface = new DownloadCallbackInterface<E>(){

        @Override
        public void onWait(E task) {
            CS.log.d("TMS_DOWNLOAD", "\u7b49\u5f85\u4e0b\u8f7d\uff0curl:" + ((DownloadTask)task).url);
            switch (((DownloadTask)task).downloadState) {
                case PAUSE: {
                    DownloadTaskManager.this.trackAppDownloadEvent(5, task, -1, "");
                    break;
                }
                case FAILED: {
                    DownloadTaskManager.this.trackAppDownloadEvent(6, task, -1, "");
                    break;
                }
                default: {
                    DownloadTaskManager.this.trackAppDownloadEvent(0, task, -1, "");
                }
            }
            DownloadTaskManager.this.sendForegroundNotification(task, 0);
        }

        @Override
        public void onStart(E task) {
            CS.log.d("TMS_DOWNLOAD", "\u5f00\u59cb\u4e0b\u8f7d\uff0curl:" + ((DownloadTask)task).url);
        }

        @Override
        public void onPause(E task) {
            ((DownloadTask)task).downloadState = DownloadState.PAUSE;
            DownloadTaskManager.this.notifyStatus(task);
            CS.log.d("TMS_DOWNLOAD", "\u6682\u505c\u4e0b\u8f7d\uff0curl:" + ((DownloadTask)task).url);
            DownloadTaskManager.this.updateDownloadTaskStatus(task);
            if (DownloadTaskManager.this.mDownloadMap.containsKey(((DownloadTask)task).url)) {
                DownloadTaskManager.this.mDownloadMap.remove(((DownloadTask)task).url);
            }
            DownloadTaskManager.this.sendForegroundNotification(task, 2);
        }

        @Override
        public void onSuccess(E task) {
            CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5b8c\u6210\uff0curl:" + ((DownloadTask)task).url + ", path:" + ((DownloadTask)task).filePath);
            ((DownloadTask)task).downloadState = DownloadState.FINISHED;
            DownloadTaskManager.this.notifyStatus(task);
            DownloadTaskManager.this.mDownloadDao.updateDownloadSize((DownloadTask)task);
            if (DownloadTaskManager.this.mDownloadMap.containsKey(((DownloadTask)task).url)) {
                DownloadTaskManager.this.mDownloadMap.remove(((DownloadTask)task).url);
            }
            if (!((DownloadTask)task).filePath.endsWith("apk")) {
                CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4e0d\u662fapk\u6587\u4ef6\uff0c\u4e0d\u5b89\u88c5\uff0c path:" + ((DownloadTask)task).filePath);
                return;
            }
            CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5b8c\u6210\uff0c\u662fapk\u6587\u4ef6\uff0c\u51c6\u5907\u5b89\u88c5\uff0c path:" + ((DownloadTask)task).filePath);
            DownloadTaskManager.this.trackAppDownloadEvent(1, task, -1, "");
            this.installApk(task);
            DownloadTaskManager.this.sendForegroundNotification(task, 1);
        }

        @Override
        public void onFailed(E task, int failType, String errorMsg) {
            CS.log.e("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5931\u8d25\uff0curl\uff1a" + ((DownloadTask)task).url + ", failType:" + failType + "errorMsg: " + errorMsg);
            DownloadTaskManager.this.trackAppDownloadEvent(-3, task, failType, errorMsg);
            this.handlerFail(task, failType, errorMsg);
            DownloadTaskManager.this.notifyStatus(task);
            DownloadTaskManager.this.sendForegroundNotification(task, 1);
        }

        @Override
        public void onLoading(E task) {
            ((DownloadTask)task).downloadState = DownloadState.DOWNLOADING;
            DownloadTaskManager.this.notifyStatus(task);
            int state = DownloadTaskManager.this.mDownloadDao.updateDownloadSize((DownloadTask)task);
            CS.log.d("TMS_DOWNLOAD", "\u5927\u5c0f\u6570\u636e\u5e93\u66f4\u65b0\u72b6\u6001\uff0cstate\uff1a" + state);
        }

        @Override
        public void onRemoved(E task) {
        }

        private void installApk(E task) {
            if (((DownloadTask)task).isSilentInstall) {
                DownloadTaskManager.this.trackAppDownloadEvent(3, task, -1, "");
                InstallUtil.tryInstall(((DownloadTask)task).filePath, success -> {
                    if (success) {
                        CS.log.d("TMS_DOWNLOAD", "\u6587\u4ef6\u53ef\u4ee5\u5b89\u88c5\uff0c\u6b63\u5728\u5b89\u88c5\uff0cpath:" + task.filePath);
                        task.downloadState = DownloadState.INSTALLING;
                        DownloadTaskManager.this.mDownloadDao.updateDownloadStatus((DownloadTask)task);
                        DownloadTaskManager.this.notifyStatus(task);
                    } else {
                        CS.log.e("TMS_DOWNLOAD", "\u6587\u4ef6\u4e0d\u80fd\u5b89\u88c5,\u5b89\u88c5\u5931\u8d25\uff0cpath:" + task.filePath);
                        task.downloadState = DownloadState.FAILED;
                        task.downloadFailType = 4;
                        DownloadTaskManager.this.mDownloadDao.updateDownloadStatus((DownloadTask)task);
                        DownloadTaskManager.this.notifyStatus(task);
                    }
                });
            } else {
                File apkFile = new File(((DownloadTask)task).filePath);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                intent.setDataAndType(FileProviderUtil.getUriByFile(DownloadTaskManager.this.mContext, apkFile), "application/vnd.android.package-archive");
                intent.addFlags(1);
                DownloadTaskManager.this.mContext.startActivity(intent);
            }
        }

        private void handlerFail(E task, int failType, String errorMsg) {
            ((DownloadTask)task).downloadState = DownloadState.FAILED;
            ((DownloadTask)task).downloadFailType = failType;
            switch (failType) {
                case 3: {
                    int updateMd5state = DownloadTaskManager.this.updateReDownloadTimes(task, ConfigInfoManager.getInstance().getCheckStep(), failType, errorMsg);
                    CS.log.d("TMS_DOWNLOAD", "\u5931\u8d25\u6570\u636e\u5e93\u66f4\u65b0\u72b6\u6001\uff0cstate\uff1a" + updateMd5state);
                    boolean success = FileUtil.deleteFile(((DownloadTask)task).filePath);
                    CS.log.d("TMS_DOWNLOAD", "\u5220\u9664\u6821\u9a8c\u5931\u8d25\u6587\u4ef6\uff0cstatus\uff1a" + success);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    int updateState = DownloadTaskManager.this.updateReDownloadTimes(task, 1, failType, errorMsg);
                    CS.log.d("TMS_DOWNLOAD", "\u5931\u8d25\u6570\u636e\u5e93\u66f4\u65b0\u72b6\u6001\uff0cstate\uff1a" + updateState);
                }
            }
        }
    };

    public int startDownload(E newTask) {
        CS.log.v("TMS_DOWNLOAD", "\u5f00\u59cb\u4e0b\u8f7d\u4efb\u52a1\uff0c" + newTask.getClass().getSimpleName() + " url:" + ((DownloadTask)newTask).url);
        if (null == ((DownloadTask)newTask).url || !URLUtil.isHttpUrl((String)((DownloadTask)newTask).url) && !URLUtil.isHttpsUrl((String)((DownloadTask)newTask).url)) {
            CS.log.e("TMS_DOWNLOAD", "ERROR: invalid http url: " + ((DownloadTask)newTask).url);
            return -1;
        }
        E oldTask = this.queryByUrl(newTask);
        if (!((DownloadTask)newTask).equals(oldTask)) {
            CS.log.d("TMS_DOWNLOAD", "\u65b0\u5efa\u4e0b\u8f7d\u4efb\u52a1 :" + ((DownloadTask)newTask).url);
            if (StorageUtils.isLessThanUsagePercent(5L)) {
                CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5185\u90e8\u5b58\u50a8\u7a7a\u95f4\u4e0d\u8db3\uff0curl:" + ((DownloadTask)newTask).url);
                return -2;
            }
            this.insertDownload(newTask);
        } else {
            this.updateDownloadTaskStatus(newTask);
            CS.log.d("TMS_DOWNLOAD", "\u5b58\u5728\u4e0b\u8f7d\u4efb\u52a1 :" + ((DownloadTask)newTask).url);
        }
        DownloadOperator dlOperator = this.mDownloadMap.get(((DownloadTask)newTask).url);
        if (dlOperator == null) {
            dlOperator = new DownloadOperator(this.mDownloadCallbackInterface, (DownloadTask)(!((DownloadTask)newTask).equals(oldTask) ? newTask : oldTask));
            this.mDownloadMap.put(((DownloadTask)newTask).url, dlOperator);
        }
        dlOperator.startDownload();
        return 0;
    }

    public <T extends E> List<T> getAllDownloadTask(T task) {
        return this.mDownloadDao.queryAllDownload(task);
    }

    public <T extends E> List<T> getAllTask(T task) {
        return this.mDownloadDao.queryAll(task);
    }

    public <T extends E> List<T> getAllNewFeatureDownloadTask(T task) {
        return this.mDownloadDao.queryInstallAll(task);
    }

    public List<OsLabAppDownLoadTask> getOsLabAllDownloadTaskByState(OsLabAppDownLoadTask task, DownloadState state) {
        return this.mDownloadDao.queryByState(task, state);
    }

    public List<AppDownLoadTask> getAllDownloadTaskByState(AppDownLoadTask task, DownloadState state) {
        return this.mDownloadDao.queryByState(task, state);
    }

    public <T extends E> T queryByPkgName(T task, String pkgName) {
        return this.mDownloadDao.queryByPkgName(task, pkgName);
    }

    public <T extends E> T queryByUrl(T task) {
        return this.mDownloadDao.queryByUrl(task);
    }

    public <T extends E> T queryByAppId(T task, int appId) {
        return this.mDownloadDao.queryByAppId(task, appId);
    }

    public long insertDownload(E downloadTask) {
        return this.mDownloadDao.insert((DownloadTask)downloadTask);
    }

    private void updateDownload(E downloadTask) {
        this.mDownloadDao.update((DownloadTask)downloadTask);
    }

    public int deleteDownload(E task) {
        return this.mDownloadDao.delete((DownloadTask)task);
    }

    public void updateDownloadTaskStatus(E task) {
        this.mDownloadDao.updateDownloadStatus((DownloadTask)task);
    }

    public int updateDownloadTask(E task, ContentValues values) {
        return this.mDownloadDao.update((DownloadTask)task, values);
    }

    public void deleteDownloadTask(E downloadTask) {
        DownloadOperator operator = this.mDownloadMap.get(((DownloadTask)downloadTask).url);
        if (operator != null) {
            operator.stopDownload();
            this.mDownloadMap.remove(((DownloadTask)downloadTask).url);
        }
        E deleteTask = this.queryByUrl(downloadTask);
        boolean success = FileUtil.deleteFile(((DownloadTask)deleteTask).filePath + ".tmp");
        CS.log.d("TMS_DOWNLOAD", "\u5220\u9664\u4e0b\u8f7d\u4efb\u52a1\uff0c\u5220\u9664\u6587\u4ef6\uff0csuccess:" + success);
        int state = this.mDownloadDao.delete((DownloadTask)downloadTask);
        CS.log.d("TMS_DOWNLOAD", "\u5220\u9664\u6570\u636e\u5e93\u72b6\u6001\uff0cstate\uff1a" + state);
    }

    public void pauseDownloadTask(E downloadTask) {
        DownloadOperator operator = this.mDownloadMap.get(((DownloadTask)downloadTask).url);
        this.mDownloadDao.updateDownloadStatus((DownloadTask)downloadTask);
        if (operator != null) {
            operator.pauseDownload();
            this.mDownloadMap.remove(((DownloadTask)downloadTask).url);
        }
    }

    public void shutdown() {
        for (String url : this.mDownloadMap.keySet()) {
            DownloadOperator operator = this.mDownloadMap.get(url);
            operator.stopDownload();
        }
        this.mDownloadMap.clear();
    }

    private void sendForegroundNotification(E task, int action) {
        if (this.mContext != null && task instanceof AppDownLoadTask && !(task instanceof OsLabAppDownLoadTask)) {
            AppDownLoadTask appDownLoadTask = (AppDownLoadTask)task;
            Intent intent = new Intent(this.mContext, UiService.class);
            intent.putExtra("TASK_ACTION", action);
            if (appDownLoadTask.apkType == 5) {
                intent.putExtra("TASK_APK_TYPE", appDownLoadTask.apkType);
            }
            this.mContext.startService(intent);
        }
    }

    private int updateReDownloadTimes(E task, int increment, int failType, String errorMsg) {
        ((DownloadTask)task).reDownloadTimes += increment;
        if (((DownloadTask)task).reDownloadTimes >= ((DownloadTask)task).reDownloadMaxTimes) {
            CS.log.v("TMS_DOWNLOAD", "\u8d85\u8fc7\u6700\u5927\u4e0b\u8f7d\u6b21\u6570\uff0curl:" + task);
            this.deleteDownloadTask(task);
            return -1;
        }
        return this.mDownloadDao.updateReDownloadTimes((DownloadTask)task);
    }

    public <T extends E> void registerDownloadCallback(IDownloadListener listener, Class<T> cls) {
        listener.setClassSimpleName(cls.getSimpleName());
        if (!this.mDownloadListeners.contains(listener)) {
            this.mDownloadListeners.add(listener);
        }
    }

    public void unregisterDownloadCallback(IDownloadListener listener) {
        if (this.mDownloadListeners.contains(listener)) {
            this.mDownloadListeners.remove(listener);
        }
    }

    private void notifyStatus(E task) {
        for (IDownloadListener listener : this.mDownloadListeners) {
            if (!task.getClass().getSimpleName().equals(listener.getClassSimpleName())) continue;
            listener.updateDownloadStatus(task);
        }
    }

    private void trackAppDownloadEvent(int status, DownloadTask task, int failType, String errorMsg) {
        if (task != null) {
            AppDownloadEvent eventData = new AppDownloadEvent();
            if (task instanceof OsLabAppDownLoadTask) {
                OsLabAppDownLoadTask oslabappDownLoadTask = (OsLabAppDownLoadTask)task;
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(oslabappDownLoadTask.pkgName, oslabappDownLoadTask.appVersionCode, oslabappDownLoadTask.apkType, status, failType, errorMsg);
                TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_DOWNLOAD_STATUS, osLabTrackBean);
                return;
            }
            if (task instanceof AppDownLoadTask) {
                AppDownLoadTask appDownLoadTask = (AppDownLoadTask)task;
                if (appDownLoadTask.apkType == 5) {
                    this.trackNewPhoneRecommendTask(status, appDownLoadTask);
                    return;
                }
                eventData.setAppId(appDownLoadTask.appId);
                eventData.setAppPkg(appDownLoadTask.pkgName);
                eventData.setAppType(this.convertApkTypeToTrackApkType(appDownLoadTask.apkType));
                eventData.setAppVersion(appDownLoadTask.appVersionCode);
                eventData.setStatus(status);
                eventData.setTimes(appDownLoadTask.reDownloadTimes);
                eventData.setMediaPkgName(TextUtils.isEmpty((CharSequence)appDownLoadTask.mediaPkgName) ? PackageUtil.getSelfPackageName(this.mContext) : appDownLoadTask.mediaPkgName);
                eventData.setCreativeId(appDownLoadTask.CID);
                eventData.setFailReason(failType);
            } else if (task instanceof AppSilentDownLoadTask) {
                AppSilentDownLoadTask appSilentDownLoadTask = (AppSilentDownLoadTask)task;
                eventData.setAppId(appSilentDownLoadTask.appId);
                eventData.setAppPkg(appSilentDownLoadTask.pkgName);
                eventData.setAppType(this.convertApkTypeToTrackApkType(0));
                eventData.setAppVersion(appSilentDownLoadTask.appVersionCode);
                eventData.setStatus(status);
                eventData.setTimes(appSilentDownLoadTask.reDownloadTimes);
                eventData.setFailReason(failType);
            } else {
                return;
            }
            Tracker.track(Tracker.TID.TMS_APP_DOWNLOAD_STATUS, eventData.getBundle());
        }
    }

    private int convertApkTypeToTrackApkType(int apkType) {
        int trackApkType = -1;
        switch (apkType) {
            case 0: {
                trackApkType = 1;
                break;
            }
            case 1: {
                trackApkType = 2;
                break;
            }
            case 2: {
                trackApkType = 3;
                break;
            }
        }
        return trackApkType;
    }

    private void trackNewPhoneRecommendTask(int status, AppDownLoadTask task) {
        if (status == 0) {
            NewPhoneRecommendManager.trackDownloadBegin((int)task.appId, (String)task.pkgName, (int)task.appVersionCode);
        } else if (status == 1) {
            NewPhoneRecommendManager.trackDownloadEnd((int)task.appId, (String)task.pkgName, (int)task.appVersionCode, (boolean)true, (int)task.downloadFailType);
        } else if (status == -3) {
            NewPhoneRecommendManager.trackDownloadEnd((int)task.appId, (String)task.pkgName, (int)task.appVersionCode, (boolean)false, (int)task.downloadFailType);
        } else if (status == 3) {
            NewPhoneRecommendManager.trackInstallBegin((int)task.appId, (String)task.pkgName, (int)task.appVersionCode);
        }
    }
}

