/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.transsion.common.log.CS;

class DownloadDBHelper
extends SQLiteOpenHelper {
    private static final int DB_VERSION = 4;
    private static final String DB_NAME = "TmsDownload.db";

    DownloadDBHelper(Context context) {
        super(context, DB_NAME, null, 4);
    }

    public void onCreate(SQLiteDatabase db) {
        CS.log.d("TMS_DOWNLOAD", "\u521b\u5efa\u4e0b\u8f7d\u6570\u636e\u5e93\u8868");
        this.createAppDownloadTable(db);
        this.createAppSilentDownloadTable(db);
        this.createOsLabAppDownloadTable(db);
        this.createOsLabAppSilentDownloadTable(db);
        this.createImgCacheDownloadTable(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u6570\u636e\u5e93\u8868\u5347\u7ea7\uff0c " + oldVersion + "->" + newVersion);
        block4: for (int currentVersion = oldVersion + 1; currentVersion <= newVersion; ++currentVersion) {
            switch (currentVersion) {
                case 3: {
                    this.createOsLabAppDownloadTable(db);
                    this.createOsLabAppSilentDownloadTable(db);
                    continue block4;
                }
                case 4: {
                    this.addTmsColumnToAppDownloadTable(db);
                    continue block4;
                }
            }
        }
    }

    private void createAppDownloadTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table if not exists ");
        buffer.append("app_download");
        buffer.append("(");
        buffer.append(this.getCommonSql());
        buffer.append("cacheNetWork");
        buffer.append(" text, ");
        buffer.append("pkgName");
        buffer.append(" text, ");
        buffer.append("guideOpenTimes");
        buffer.append(" integer, ");
        buffer.append("iconUrl");
        buffer.append(" text, ");
        buffer.append("title");
        buffer.append(" text, ");
        buffer.append("app_id");
        buffer.append(" integer, ");
        buffer.append("imgUrl");
        buffer.append(" text, ");
        buffer.append("appVersionName");
        buffer.append(" text, ");
        buffer.append("appVersionCode");
        buffer.append(" integer, ");
        buffer.append("apkType");
        buffer.append(" integer, ");
        buffer.append("description");
        buffer.append(" text, ");
        buffer.append("CID");
        buffer.append(" integer, ");
        buffer.append("mediaPkgName");
        buffer.append(" text)");
        db.execSQL(buffer.toString());
    }

    private void createAppSilentDownloadTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table if not exists ");
        buffer.append("app_silent_download");
        buffer.append("(");
        buffer.append(this.getCommonSql());
        buffer.append("cacheNetWork");
        buffer.append(" text, ");
        buffer.append("pkgName");
        buffer.append(" text, ");
        buffer.append("app_id");
        buffer.append(" integer, ");
        buffer.append("appVersionName");
        buffer.append(" text, ");
        buffer.append("appVersionCode");
        buffer.append(" integer, ");
        buffer.append("guideOpenTimes");
        buffer.append(" integer)");
        db.execSQL(buffer.toString());
    }

    private void createOsLabAppSilentDownloadTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table if not exists ");
        buffer.append("os_lab_app_silent_download");
        buffer.append("(");
        buffer.append(this.getCommonSql());
        buffer.append("cacheNetWork");
        buffer.append(" text, ");
        buffer.append("pkgName");
        buffer.append(" text, ");
        buffer.append("app_id");
        buffer.append(" integer, ");
        buffer.append("appVersionName");
        buffer.append(" text, ");
        buffer.append("appVersionCode");
        buffer.append(" integer, ");
        buffer.append("guideOpenTimes");
        buffer.append(" integer)");
        db.execSQL(buffer.toString());
    }

    private void createImgCacheDownloadTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table if not exists ");
        buffer.append("img_cache_download");
        buffer.append("(");
        buffer.append(this.getCommonSql());
        buffer.append("CID");
        buffer.append(" integer, ");
        buffer.append("cacheNetWork");
        buffer.append(" text)");
        db.execSQL(buffer.toString());
    }

    private void createOsLabAppDownloadTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table if not exists ");
        buffer.append("oslab_app_download");
        buffer.append("(");
        buffer.append(this.getCommonSql());
        buffer.append("cacheNetWork");
        buffer.append(" text, ");
        buffer.append("pkgName");
        buffer.append(" text, ");
        buffer.append("guideOpenTimes");
        buffer.append(" integer, ");
        buffer.append("iconUrl");
        buffer.append(" text, ");
        buffer.append("title");
        buffer.append(" text, ");
        buffer.append("app_id");
        buffer.append(" integer, ");
        buffer.append("imgUrl");
        buffer.append(" text, ");
        buffer.append("appVersionName");
        buffer.append(" text, ");
        buffer.append("appVersionCode");
        buffer.append(" integer, ");
        buffer.append("apkType");
        buffer.append(" integer, ");
        buffer.append("description");
        buffer.append(" text, ");
        buffer.append("isUsedApk");
        buffer.append(" integer, ");
        buffer.append("CID");
        buffer.append(" integer, ");
        buffer.append("mediaPkgName");
        buffer.append(" text)");
        db.execSQL(buffer.toString());
    }

    private String getCommonSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("url");
        sb.append(" text UNIQUE, ");
        sb.append("MD5");
        sb.append(" text, ");
        sb.append("finishedSize");
        sb.append(" integer, ");
        sb.append("totalSize");
        sb.append(" integer,");
        sb.append("filepath");
        sb.append(" text, ");
        sb.append("downloadState");
        sb.append(" text, ");
        sb.append("startTime");
        sb.append(" integer, ");
        sb.append("reDownloadTimes");
        sb.append(" integer, ");
        sb.append("reDownloadMaxTimes");
        sb.append(" integer, ");
        sb.append("downloadFailType");
        sb.append(" integer, ");
        sb.append("isSilentInstall");
        sb.append(" integer, ");
        return sb.toString();
    }

    private void addTmsColumnToAppDownloadTable(SQLiteDatabase db) {
        try {
            StringBuilder cidAppUpdateSQL = new StringBuilder("alter table ");
            cidAppUpdateSQL.append("app_download");
            cidAppUpdateSQL.append(" add column ");
            cidAppUpdateSQL.append("CID");
            cidAppUpdateSQL.append(" integer default 0");
            db.execSQL(cidAppUpdateSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
        try {
            StringBuilder cidOSLabSQL = new StringBuilder("alter table ");
            cidOSLabSQL.append("oslab_app_download");
            cidOSLabSQL.append(" add column ");
            cidOSLabSQL.append("CID");
            cidOSLabSQL.append(" integer default 0");
            db.execSQL(cidOSLabSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
        try {
            StringBuilder mediaAppUpdateSQL = new StringBuilder("alter table ");
            mediaAppUpdateSQL.append("app_download");
            mediaAppUpdateSQL.append(" add column ");
            mediaAppUpdateSQL.append("mediaPkgName");
            mediaAppUpdateSQL.append(" text");
            db.execSQL(mediaAppUpdateSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
        try {
            StringBuilder mediaOSLabSQL = new StringBuilder("alter table ");
            mediaOSLabSQL.append("oslab_app_download");
            mediaOSLabSQL.append(" add column ");
            mediaOSLabSQL.append("mediaPkgName");
            mediaOSLabSQL.append(" text");
            db.execSQL(mediaOSLabSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
    }
}

