/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.db.DownloadDBHelper;
import com.transsion.appupdate.download.db.IDownloadDao;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.common.log.CS;
import java.util.ArrayList;
import java.util.List;

public class DownloadDao
implements IDownloadDao {
    private static DownloadDao sInstance = null;
    private SQLiteDatabase mDataBase = null;
    private DownloadDBHelper mDownloadHelper;

    private DownloadDao(Context context) {
        this.mDownloadHelper = new DownloadDBHelper(context.getApplicationContext());
    }

    public static DownloadDao getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DownloadDao(context);
        }
        return sInstance;
    }

    @Override
    public long insert(DownloadTask downloadTask) {
        try {
            this.mDataBase = this.mDownloadHelper.getWritableDatabase();
            return this.mDataBase.insert(downloadTask.getTableName(), null, downloadTask.of());
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0c table\uff1a" + downloadTask.getTableName() + ", error:" + e.getMessage());
            e.printStackTrace();
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(List<DownloadTask> tasks) {
        try {
            this.mDataBase = this.mDownloadHelper.getWritableDatabase();
            this.mDataBase.beginTransaction();
            for (DownloadTask task : tasks) {
                this.mDataBase.insert(task.getTableName(), null, task.of());
            }
            this.mDataBase.setTransactionSuccessful();
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0cerror:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.mDataBase.endTransaction();
        }
    }

    @Override
    public int update(DownloadTask downloadTask) {
        return this.update(downloadTask, downloadTask.of());
    }

    @Override
    public int update(DownloadTask downloadTask, ContentValues values) {
        try {
            this.mDataBase = this.mDownloadHelper.getWritableDatabase();
            return this.mDataBase.update(downloadTask.getTableName(), values, "url=?", new String[]{downloadTask.url});
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", e.getLocalizedMessage());
            return -1;
        }
    }

    @Override
    public int updateDownloadStatus(DownloadTask downloadTask) {
        ContentValues values = new ContentValues();
        values.put("downloadState", downloadTask.downloadState.name());
        return this.update(downloadTask, values);
    }

    @Override
    public int updateDownloadSize(DownloadTask downloadTask) {
        ContentValues values = new ContentValues();
        values.put("downloadState", downloadTask.downloadState.name());
        values.put("totalSize", Long.valueOf(downloadTask.totalSize));
        values.put("finishedSize", Long.valueOf(downloadTask.finishedSize));
        return this.update(downloadTask, values);
    }

    @Override
    public int updateReDownloadTimes(DownloadTask task) {
        ContentValues values = new ContentValues();
        values.put("downloadState", task.downloadState.name());
        values.put("reDownloadTimes", Integer.valueOf(task.reDownloadTimes));
        values.put("downloadFailType", Integer.valueOf(task.downloadFailType));
        return this.update(task, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> List<T> queryAll(T task) {
        Cursor cursor = null;
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), null, null, null, null, "startTime desc");
            if (cursor == null) {
                ArrayList<DownloadTask> arrayList = tasks;
                this.releaseCursor(cursor);
                return arrayList;
            }
            while (cursor.moveToNext()) {
                DownloadTask resultTask = (DownloadTask)task.clone();
                resultTask.clear();
                resultTask.valueOf(cursor);
                tasks.add(resultTask);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> List<T> queryAllDownload(T task) {
        Cursor cursor = null;
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            String[] selectionArgs = new String[]{DownloadState.INITIAL.name(), DownloadState.WAITING.name(), DownloadState.DOWNLOADING.name(), DownloadState.PAUSE.name(), DownloadState.FAILED.name()};
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "downloadState in (?,?,?,?,?)", selectionArgs, null, null, "startTime desc");
            if (cursor == null) {
                ArrayList<DownloadTask> arrayList = tasks;
                this.releaseCursor(cursor);
                return arrayList;
            }
            while (cursor.moveToNext()) {
                DownloadTask resultTask = (DownloadTask)task.clone();
                resultTask.clear();
                resultTask.valueOf(cursor);
                tasks.add(resultTask);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> List<T> queryInstallAll(T task) {
        Cursor cursor = null;
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            String[] selectionArgs = new String[]{DownloadState.INSTALLED.name(), DownloadState.INSTALLING.name(), DownloadState.FINISHED.name()};
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "downloadState in (?,?,?)", selectionArgs, null, null, "startTime desc");
            if (cursor == null) {
                ArrayList<DownloadTask> arrayList = tasks;
                this.releaseCursor(cursor);
                return arrayList;
            }
            while (cursor.moveToNext()) {
                DownloadTask resultTask = (DownloadTask)task.clone();
                resultTask.clear();
                resultTask.valueOf(cursor);
                tasks.add(resultTask);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> T queryByUrl(T task) {
        Cursor cursor = null;
        DownloadTask result = null;
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "url=?", new String[]{task.url}, null, null, null);
            result = (DownloadTask)task.clone();
            result.clear();
            if (cursor != null && cursor.moveToNext()) {
                result.valueOf(cursor);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> T queryByAppId(T task, int appId) {
        Cursor cursor = null;
        DownloadTask result = null;
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            String appIdStr = String.valueOf(appId);
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "app_id=?", new String[]{appIdStr}, null, null, null);
            result = (DownloadTask)task.clone();
            result.clear();
            if (cursor != null && cursor.moveToNext()) {
                result.valueOf(cursor);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> T queryByPkgName(T task, String pkgName) {
        Cursor cursor = null;
        DownloadTask result = null;
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "pkgName=?", new String[]{pkgName}, null, null, null);
            result = (DownloadTask)task.clone();
            result.clear();
            if (cursor != null && cursor.moveToNext()) {
                result.valueOf(cursor);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DownloadTask> List<T> queryByState(T task, DownloadState state) {
        Cursor cursor = null;
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>();
        this.mDataBase = this.mDownloadHelper.getReadableDatabase();
        try {
            List<String> columnList = task.columns();
            cursor = this.mDataBase.query(task.getTableName(), columnList.toArray(new String[columnList.size()]), "downloadState=?", new String[]{state.name()}, null, null, null);
            if (cursor == null) {
                ArrayList<DownloadTask> arrayList = tasks;
                this.releaseCursor(cursor);
                return arrayList;
            }
            while (cursor.moveToNext()) {
                DownloadTask resultTask = (DownloadTask)task.clone();
                resultTask.clear();
                resultTask.valueOf(cursor);
                tasks.add(resultTask);
            }
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u6570\u636e\u5e93\u67e5\u4e0b\u5931\u8d25\uff0c error:" + e.getMessage());
        }
        finally {
            this.releaseCursor(cursor);
        }
        return tasks;
    }

    @Override
    public int delete(DownloadTask downloadTask) {
        try {
            this.mDataBase = this.mDownloadHelper.getWritableDatabase();
            return this.mDataBase.delete(downloadTask.getTableName(), "url=?", new String[]{downloadTask.url});
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "\u5220\u9664\u52a0\u8f7d\u5931\u8d25" + e.getLocalizedMessage());
            return -1;
        }
    }

    private void releaseCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", e.getLocalizedMessage());
        }
    }

    public void closeDB() {
        try {
            if (this.mDataBase != null) {
                this.mDataBase.close();
            }
        }
        catch (Exception e) {
            CS.log.e("TMS_DOWNLOAD", "close database exception:" + e.getLocalizedMessage());
        }
    }
}

