/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.SparseArray;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppDownloadTaskData;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.manager.PhoneInfoManager;
import com.transsion.appupdate.media.BaseMedia;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.bean.CreativeRequestJson;
import com.transsion.appupdate.reportBean.CIDGetAction;
import com.transsion.appupdate.reportBean.SyncAction;
import com.transsion.appupdate.service.DataSyncService;
import com.transsion.appupdate.service.ImageCacheJobService;
import com.transsion.appupdate.utils.DataSyncUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.CreativeIndex;
import com.transsion.common.bean.CreativeInfo;
import com.transsion.common.bean.CreativeResBean;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.bean.SdkAppID;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class CreativeMedia
extends BaseMedia {
    private static CreativeMedia configMedia = null;

    public static CreativeMedia getInstance() {
        if (null == configMedia) {
            configMedia = new CreativeMedia();
        }
        return configMedia;
    }

    public void syncData(final IMediaCallback creativeCallback) {
        long lastTime = SpUtil.getSP().getLong("CREATIVE_LAST_TIME", 0L);
        long updateTime = (long)ConfigInfoManager.getInstance().getReqCreativeServerInterval() * 1000L;
        CS.log.d("TMS_MEDIA", "CreativeMedia -> updateTime: " + updateTime + " / intervalTime : " + Math.abs(System.currentTimeMillis() - lastTime));
        if (Math.abs(System.currentTimeMillis() - lastTime) > updateTime) {
            CreativeRequestJson json = new CreativeRequestJson();
            json.setRegisterTime(SpUtil.getSP().getLong("CREATIVE_REGISTER_TIME", 0L));
            json.setPhoneInfo(PhoneInfoManager.getInstance().getPhoneInfo());
            json.setCacheCreativeIDs(DBManager.getInstance().getAllCachedCreativeIndex());
            json.setDelCreativeIDs(DBManager.getInstance().getDeleteCreativeList(200));
            List<SdkAppConfig> sdkAppConfigList = DBManager.getInstance().getAllSdkAppConfig();
            if (null != sdkAppConfigList && sdkAppConfigList.size() > 0) {
                ArrayList<SdkAppID> sdkAppIDList = new ArrayList<SdkAppID>();
                for (SdkAppConfig sdkAppConfig : sdkAppConfigList) {
                    sdkAppIDList.add(sdkAppConfig.getSdkAppID());
                }
                json.setSdkAppIDs(sdkAppIDList);
            }
            String jsonData = Tson.toJson((Object)json);
            CS.log.d("TMS_MEDIA", "CreativeMedia request: jsonData->" + jsonData);
            HttpTool.getTool().getCreative(jsonData, (HttpCallbackImpl)new StringCallback(){

                public void onFailure(int i, String s, Throwable throwable) {
                    CS.log.d("TMS_MEDIA", "CreativeMedia onFailure:" + s);
                    if (null != creativeCallback) {
                        creativeCallback.onRequestFailed(s);
                    }
                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(2, -1).getBundle());
                }

                public void onSuccess(int i, String s) {
                    block5: {
                        CS.log.d("TMS_MEDIA", "CreativeMedia onCallbackSuccess: s->" + s);
                        if (!TextUtils.isEmpty((CharSequence)s)) {
                            try {
                                JSONObject response = new JSONObject(s);
                                String code = response.optString("code");
                                if ("200".equals(code)) {
                                    String data = response.optString("data");
                                    CreativeMedia.this.parseDataByTask(data, creativeCallback);
                                    SpUtil.getSP().putLong("CREATIVE_LAST_TIME", System.currentTimeMillis());
                                } else {
                                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(2, -2).getBundle());
                                }
                            }
                            catch (Exception e) {
                                CS.log.v("TMS_MEDIA", "CreativeMedia Error:" + e.toString());
                                Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(2, -3).getBundle());
                                if (null == creativeCallback) break block5;
                                creativeCallback.onRequestFailed(s);
                            }
                        }
                    }
                }
            });
        }
    }

    private void reSyncUpdate(final IMediaCallback callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                CreativeMedia.this.syncData(callback);
            }
        });
    }

    @Override
    void parseData(String jsonData, IMediaCallback creativeCallback) {
        try {
            if (!TextUtils.isEmpty((CharSequence)jsonData)) {
                CreativeResBean creativeRes = (CreativeResBean)Tson.fromJson((String)jsonData, CreativeResBean.class);
                if (creativeRes != null) {
                    List delCreativeIndexList;
                    CS.log.v("TMS_MEDIA", "CreativeMedia parseData success  ---------------------------");
                    if (creativeRes.getRegisterTime() > 0L && SpUtil.getSP().getLong("CREATIVE_REGISTER_TIME", 0L) <= 0L) {
                        SpUtil.getSP().putLong("CREATIVE_REGISTER_TIME", creativeRes.getRegisterTime());
                        SpUtil.getSP().putLong("CREATIVE_LAST_TIME", 0L);
                        this.reSyncUpdate(creativeCallback);
                        return;
                    }
                    ArrayList<Bundle> trackCreativeList = new ArrayList<Bundle>();
                    ArrayList<AppDownLoadTask> newTaskList = new ArrayList<AppDownLoadTask>();
                    List appDetailInfoList = creativeRes.getAppDetailInfos();
                    if (null != appDetailInfoList && appDetailInfoList.size() > 0) {
                        if (CS.DEBUG_LOG) {
                            for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                                if (appDetailInfo == null) continue;
                                CS.log.v("TMS_MEDIA", "AppID : " + appDetailInfo.getAppId() + "  DATA : \n" + Tson.toJson((Object)appDetailInfo));
                            }
                        }
                        this.checkEffectiveAppDetailInfo(appDetailInfoList);
                        for (AppDetailInfo info : appDetailInfoList) {
                            AppDownLoadTask task = new AppDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), info.getIcon().getUrl(), info.getTitle(), info.getAppId(), true, info.getVersionName(), info.getVersionCode(), 1, info.getDescription(), this.getImgUrl(info));
                            newTaskList.add(task);
                        }
                        DBManager.getInstance().saveOrUpdateAppDetailList(appDetailInfoList, 0L);
                    }
                    List creativeInfoList = creativeRes.getCreativeInfos();
                    ArrayList<CreativeInfo> effectiveCreativeInfoList = new ArrayList<CreativeInfo>();
                    if (null != creativeInfoList && creativeInfoList.size() > 0) {
                        List<Integer> dbAppIdList = DBManager.getInstance().getAllAppDetailInfoId();
                        for (CreativeInfo creativeInfo : creativeInfoList) {
                            if (creativeInfo == null || creativeInfo.getCreativeIndex() == null) continue;
                            CIDGetAction cidGetAction = new CIDGetAction(creativeInfo.getCreativeIndex().getCreativeID(), creativeInfo.getCreativeIndex().getCreativeVersion(), 1);
                            trackCreativeList.add(cidGetAction.getBundle());
                            if (CS.DEBUG_LOG) {
                                CS.log.v("TMS_MEDIA", "ID : " + creativeInfo.getCreativeIndex().getCreativeID() + "version : " + creativeInfo.getCreativeIndex().getCreativeVersion() + "  TYPE : " + creativeInfo.getCreativeType() + "  TITLE : " + creativeInfo.getTitle() + "  DATA : \n" + Tson.toJson((Object)creativeInfo));
                            }
                            if (creativeInfo.getCreativeType() == 1) {
                                if (dbAppIdList == null) {
                                    CS.log.v("TMS_MEDIA", "LOCAL save no app detail");
                                    continue;
                                }
                                if (!dbAppIdList.contains(creativeInfo.getAppId())) {
                                    CS.log.v("TMS_MEDIA", "INVALID creative id : " + creativeInfo.getCreativeIndex().getCreativeID());
                                    continue;
                                }
                            }
                            effectiveCreativeInfoList.add(creativeInfo);
                        }
                        DBManager.getInstance().saveOrUpdateCreativeList(effectiveCreativeInfoList);
                    }
                    if (null != (delCreativeIndexList = creativeRes.getInvalidCreatives()) && delCreativeIndexList.size() > 0) {
                        CS.log.v("TMS_MEDIA", "  InvalidCreativeID : \n" + Tson.toJson((Object)delCreativeIndexList));
                        List<ImgInfo> imgInfoList = DBManager.getInstance().getImgInfoByCreativeIds(delCreativeIndexList);
                        if (imgInfoList != null && imgInfoList.size() > 0) {
                            for (ImgInfo imgInfo : imgInfoList) {
                                boolean isSuccess;
                                String imgName;
                                File folder;
                                File img;
                                int index;
                                if (imgInfo == null || TextUtils.isEmpty((CharSequence)imgInfo.getCachedFilePath()) || (index = imgInfo.getCachedFilePath().lastIndexOf("/")) <= 0 || !(img = new File(folder = new File(CoreUtil.getContext().getFilesDir(), "download"), imgName = imgInfo.getCachedFilePath().substring(index + 1))).exists() || !(isSuccess = img.delete())) continue;
                                CS.log.d("TMS_MEDIA", "\u5220\u9664\u56fe\u7247:" + imgName);
                            }
                        }
                        DBManager.getInstance().deleteCreativeByIds(delCreativeIndexList);
                        for (CreativeIndex creativeIndex : delCreativeIndexList) {
                            CIDGetAction cidGetAction = new CIDGetAction(creativeIndex.getCreativeID(), creativeIndex.getCreativeVersion(), 2);
                            trackCreativeList.add(cidGetAction.getBundle());
                        }
                    }
                    if (creativeRes.getSdkAppConfigs() != null && creativeRes.getSdkAppConfigs().size() > 0) {
                        CS.log.v("TMS_MEDIA", "  SdkAppConfig : " + Tson.toJson((Object)creativeRes.getSdkAppConfigs()));
                        DBManager.getInstance().updateAllSdkAppConfig(creativeRes.getSdkAppConfigs());
                    }
                    this.saveNewTaskList(newTaskList);
                    if (null != creativeCallback) {
                        creativeCallback.onRequestSuccess(null);
                    }
                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(2, 0).getBundle());
                    if (trackCreativeList.size() > 0) {
                        Tracker.trackList(Tracker.TID.TMS_CREATIVE_GET, trackCreativeList);
                    }
                }
            } else if (null != creativeCallback) {
                creativeCallback.onRequestFailed("DATA IS NULL");
            }
            ImageCacheJobService.startJob(CoreUtil.getContext());
        }
        catch (Exception e) {
            CS.log.v("TMS_MEDIA", "CreativeMedia parseData Exception ->  " + e.toString());
            Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(2, -3).getBundle());
        }
    }

    private void checkEffectiveAppDetailInfo(List<AppDetailInfo> serverApps) {
        if (serverApps == null || 0 == serverApps.size()) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (AppDetailInfo detail : serverApps) {
            if (detail == null) continue;
            idList.add(String.valueOf(detail.getAppId()));
        }
        List<AppDetailInfo> dbAppList = DBManager.getInstance().getAppDetailListByAppIdList(idList);
        SparseArray dbApps = new SparseArray();
        if (dbAppList != null) {
            for (AppDetailInfo appDetailInfo : dbAppList) {
                dbApps.put(appDetailInfo.getAppId(), (Object)appDetailInfo);
            }
        }
        Iterator<AppDetailInfo> it = serverApps.iterator();
        while (it.hasNext()) {
            AppDetailInfo serverApp = it.next();
            if (serverApp == null) {
                it.remove();
                continue;
            }
            if (serverApp.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)serverApp.getPkgName()) || TextUtils.isEmpty((CharSequence)serverApp.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)serverApp.getMd5()) || TextUtils.isEmpty((CharSequence)serverApp.getTitle()) || serverApp.getIcon() == null || serverApp.getApkScreenshotImgList() == null || serverApp.getApkScreenshotImgList().size() == 0 || serverApp.getImages() == null || serverApp.getImages().size() == 0) {
                CS.log.v("TMS_MEDIA", "INVALID app detail id : " + serverApp.getAppId());
                it.remove();
                continue;
            }
            if (PackageUtil.checkApkExist(CoreUtil.getContext(), serverApp.getPkgName(), serverApp.getVersionCode())) {
                CS.log.v("TMS_MEDIA", "INVALID app detail id : " + serverApp.getAppId() + ", pkg exists");
                it.remove();
                continue;
            }
            AppDetailInfo dbApp = (AppDetailInfo)dbApps.get(serverApp.getAppId());
            if (dbApp == null) continue;
            if (serverApp.getVersionCode() < dbApp.getVersionCode()) {
                CS.log.v("TMS_MEDIA", "INVALID app detail id : " + serverApp.getAppId() + ", database exists high version");
                it.remove();
                continue;
            }
            if (serverApp.getVersionCode() != dbApp.getVersionCode() || serverApp.getDescVersion() > dbApp.getDescVersion()) continue;
            CS.log.v("TMS_MEDIA", "INVALID app detail id : " + serverApp.getAppId() + ", database exists same version");
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewTaskList(List<AppDownLoadTask> newTaskList) {
        if (newTaskList != null && !newTaskList.isEmpty()) {
            ArrayList<AppDownLoadTask> appList = new ArrayList<AppDownLoadTask>(newTaskList);
            String newTaskListJson = DataSyncUtil.getNewTaskListJson("TMS_APP_NEW_TASK_LIST");
            if (!TextUtils.isEmpty((CharSequence)newTaskListJson)) {
                try {
                    AppDownloadTaskData appTaskData = (AppDownloadTaskData)Tson.fromJson((String)newTaskListJson, AppDownloadTaskData.class);
                    if (appTaskData != null && appTaskData.getTaskList() != null && !appTaskData.getTaskList().isEmpty()) {
                        appList.addAll(appTaskData.getTaskList());
                    }
                }
                catch (Exception e) {
                    CS.log.e("TMS_MEDIA", e.getMessage());
                }
                finally {
                    DataSyncUtil.clearNewTaskList("TMS_APP_NEW_TASK_LIST");
                }
            }
            AppDownloadTaskData data = new AppDownloadTaskData();
            data.setTaskList(appList);
            String jsonData = Tson.toJson((Object)data);
            Context context = CoreUtil.getContext();
            Intent intent = new Intent(context, DataSyncService.class);
            intent.putExtra("media", 1);
            intent.putExtra("taskList", jsonData);
            try {
                context.startService(intent);
            }
            catch (Exception e) {
                DataSyncUtil.saveNewTaskList(newTaskList, "TMS_APP_NEW_TASK_LIST");
            }
        }
    }

    private String getImgUrl(AppDetailInfo info) {
        if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
            return null;
        }
        return ((ImgInfo)info.getImages().get(0)).getUrl();
    }
}

