/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.os.Handler;
import android.os.Looper;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.media.AppUpdateMedia;
import com.transsion.appupdate.media.ConfigMedia;
import com.transsion.appupdate.media.CreativeMedia;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.OsLabAppUpdateMedia;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;

public class MediaManager {
    private static MediaManager mediaManager = null;

    public static MediaManager getInstance() {
        if (null == mediaManager) {
            mediaManager = new MediaManager();
        }
        return mediaManager;
    }

    public void syncMedia() {
        if (!NetworkUtil.isConnected(CoreUtil.getContext())) {
            CS.log.v("TMS_MEDIA", "syncMedia() -> NO Network !!!");
            return;
        }
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            CS.log.d("TMS_MEDIA", "syncMedia() -> lack of space");
            return;
        }
        if (ConfigInfoManager.getInstance().isTmsOpen()) {
            ConfigMedia.getInstance().syncData(null);
            CreativeMedia.getInstance().syncData(null);
            AppUpdateMedia.getInstance().syncData(null);
            if (CSLib.OS_LAB) {
                OsLabAppUpdateMedia.getInstance().syncData(null);
            }
        } else {
            ConfigMedia.getInstance().syncData(new IMediaCallback(){

                public void onRequestSuccess(Object callBack) {
                    if (ConfigInfoManager.getInstance().isTmsOpen()) {
                        AppExecutors.getInstance().ui().execute(new Runnable(){

                            @Override
                            public void run() {
                                CreativeMedia.getInstance().syncData(null);
                                AppUpdateMedia.getInstance().syncData(null);
                                if (CSLib.OS_LAB) {
                                    OsLabAppUpdateMedia.getInstance().syncData(null);
                                }
                            }
                        });
                    }
                }

                @Override
                public void onRequestFailed(String msg) {
                }
            });
        }
    }

    public void forceSyncAppUpdate(final IMediaCallback callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (ConfigInfoManager.getInstance().isTmsOpen()) {
                    SpUtil.getSP().putLong("APP_UPDATE_LAST_TIME", 0L);
                    AppUpdateMedia.getInstance().syncData(callback);
                } else {
                    SpUtil.getSP().putLong("CONFIG_LAST_TIME", 0L);
                    ConfigMedia.getInstance().syncData(new IMediaCallback(){

                        public void onRequestSuccess(Object callBack) {
                            if (ConfigInfoManager.getInstance().isTmsOpen()) {
                                SpUtil.getSP().putLong("APP_UPDATE_LAST_TIME", 0L);
                                AppUpdateMedia.getInstance().syncData(callback);
                            } else {
                                callback.onRequestFailed("TMS IS NOT OPEN");
                            }
                        }

                        @Override
                        public void onRequestFailed(String msg) {
                            if (null != callback) {
                                callback.onRequestFailed("TMS IS NOT OPEN");
                            }
                        }
                    });
                }
            }
        });
    }

    public void forceSyncOsLabAppUpdate(final IMediaCallback callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (ConfigInfoManager.getInstance().isTmsOpen()) {
                    SpUtil.getSP().putLong("OS_LAB_APP_UPDATE_LAST_TIME", 0L);
                    OsLabAppUpdateMedia.getInstance().syncData(callback);
                } else {
                    SpUtil.getSP().putLong("CONFIG_LAST_TIME", 0L);
                    ConfigMedia.getInstance().syncData(new IMediaCallback(){

                        public void onRequestSuccess(Object callBack) {
                            if (ConfigInfoManager.getInstance().isTmsOpen()) {
                                SpUtil.getSP().putLong("OS_LAB_APP_UPDATE_LAST_TIME", 0L);
                                OsLabAppUpdateMedia.getInstance().syncData(callback);
                            } else {
                                callback.onRequestFailed("TMS IS NOT OPEN");
                            }
                        }

                        @Override
                        public void onRequestFailed(String msg) {
                            if (null != callback) {
                                callback.onRequestFailed("TMS IS NOT OPEN");
                            }
                        }
                    });
                }
            }
        });
    }
}

