/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.SparseArray;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.DownloadHelper;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppSilentDownLoadTask;
import com.transsion.appupdate.entity.OsLabAppDownloadTaskData;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.manager.PhoneInfoManager;
import com.transsion.appupdate.media.BaseMedia;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.bean.AppUpdateReqBean;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabSyncBean;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.service.OsLabAppSilentJobService;
import com.transsion.appupdate.service.OsLabDataSyncService;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.DataSyncUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.InstallUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.AppInfo;
import com.transsion.common.bean.AppUpdateBean;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.PhoneInfo;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class OsLabAppUpdateMedia
extends BaseMedia {
    private static OsLabAppUpdateMedia configMedia = null;

    public static OsLabAppUpdateMedia getInstance() {
        if (null == configMedia) {
            configMedia = new OsLabAppUpdateMedia();
        }
        return configMedia;
    }

    public void syncData(IMediaCallback appUpdateCallback) {
        long lastTime = SpUtil.getSP().getLong("OS_LAB_APP_UPDATE_LAST_TIME", 0L);
        long updateTime = (long)ConfigInfoManager.getInstance().getReqAppUpdateInterval() * 1000L;
        CS.log.d("TMS_MEDIA", "\u5f00\u59cb\u540c\u6b65appupdate\u6570\u636e\uff0cOsLabAppUpdateMedia -> updateTime: " + updateTime + " / intervalTime : " + Math.abs(System.currentTimeMillis() - lastTime));
        if (Math.abs(System.currentTimeMillis() - lastTime) > updateTime) {
            new AppSyncTask(appUpdateCallback).execute(new String[0]);
        }
    }

    private void syncDataInternal(PhoneInfo phoneInfo, List<Integer> planIdList, List<AppInfo> appInfoList, int checkStep, final IMediaCallback appUpdateCallback) {
        AppUpdateReqBean appUpdateReqBean = new AppUpdateReqBean(phoneInfo, planIdList, appInfoList, checkStep);
        String data = Tson.toJson((Object)appUpdateReqBean);
        CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia req JSON ->" + data);
        HttpTool.getTool().getOSLabApps(data, (HttpCallbackImpl)new StringCallback(){

            public void onFailure(int i, String s, Throwable throwable) {
                CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia : onFailure->" + s);
                if (null != appUpdateCallback) {
                    appUpdateCallback.onRequestFailed(s);
                }
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, 1, s + throwable.getMessage());
                TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_SYNC, osLabTrackBean);
            }

            public void onSuccess(int i, String s) {
                block6: {
                    CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia : onCallbackSuccess->" + (s.length() > 2048 ? Integer.valueOf(2048) : s));
                    if (!TextUtils.isEmpty((CharSequence)s)) {
                        try {
                            JSONObject response = new JSONObject(s);
                            String code = response.optString("code");
                            if ("200".equals(code)) {
                                String data = response.optString("plan");
                                OsLabAppUpdateMedia.this.parseDataByTask(data, appUpdateCallback);
                                SpUtil.getSP().putLong("OS_LAB_APP_UPDATE_LAST_TIME", System.currentTimeMillis());
                                break block6;
                            }
                            OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, 2, code);
                            TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_SYNC, osLabTrackBean);
                        }
                        catch (Exception e) {
                            CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia : syncDataInternal Exception->" + s);
                            OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, 3, e.getMessage());
                            TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_SYNC, osLabTrackBean);
                            if (null != appUpdateCallback) {
                                appUpdateCallback.onRequestFailed(e.toString());
                            }
                            break block6;
                        }
                    }
                    if (null != appUpdateCallback) {
                        appUpdateCallback.onRequestFailed("DATA IS NULL");
                    }
                    OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, 4, "");
                    TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_SYNC, osLabTrackBean);
                }
            }
        });
    }

    @Override
    void parseData(String jsonData, IMediaCallback appUpdateCallback) {
        try {
            if (!TextUtils.isEmpty((CharSequence)jsonData)) {
                AppUpdateBean appUpdateRes = (AppUpdateBean)Tson.fromJson((String)jsonData, AppUpdateBean.class);
                if (appUpdateRes != null) {
                    List<AppDetailInfo> recommendAppList;
                    List<AppDetailInfo> normalAppList;
                    DownloadTask task;
                    List<AppDetailInfo> silentAppList;
                    CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia  parseData  success ================================");
                    CS.log.v("TMS_MEDIA", "OsLabAppUpdateMedia PlanID : " + appUpdateRes.getPlanId());
                    ArrayList<OsLabAppDownLoadTask> newTaskList = new ArrayList<OsLabAppDownLoadTask>();
                    if (null != appUpdateRes.getUninstallAppList() && appUpdateRes.getUninstallAppList().size() > 0) {
                        for (AppInfo appInfo : appUpdateRes.getUninstallAppList()) {
                            if (!PackageUtil.checkApkExist(CoreUtil.getContext(), appInfo.getPkgName(), appInfo.getVersionCode())) continue;
                            InstallUtil.pmuninstall(CoreUtil.getContext(), appInfo.getPkgName());
                        }
                    }
                    ArrayList<AppDetailInfo> appList = new ArrayList<AppDetailInfo>();
                    if (appUpdateRes.getSilentAppList() != null && (silentAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getSilentAppList(), 1)) != null) {
                        for (AppDetailInfo appDetailInfo : appUpdateRes.getSilentAppList()) {
                            task = new OsLabAppSilentDownLoadTask(appDetailInfo.getDownloadUrl(), appDetailInfo.getMd5(), appDetailInfo.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), appDetailInfo.getDownloadUrl()), DownloadState.INITIAL, appDetailInfo.getPkgName(), true, appDetailInfo.getAppId(), appDetailInfo.getVersionName(), appDetailInfo.getVersionCode(), ConfigInfoManager.getInstance().getApkDownloadRetryTimes());
                            DownloadHelper.getInstance().addOSLabSilentDownLoad((OsLabAppSilentDownLoadTask)task);
                            OsLabAppSilentJobService.startJob(CoreUtil.getContext());
                        }
                        appList.addAll(silentAppList);
                    }
                    if (null != (normalAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getUpgradeAppList(), 2)) && normalAppList.size() > 0) {
                        for (AppDetailInfo appDetailInfo : normalAppList) {
                            task = new OsLabAppDownLoadTask(appDetailInfo.getDownloadUrl(), appDetailInfo.getMd5(), appDetailInfo.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), appDetailInfo.getDownloadUrl()), DownloadState.INITIAL, appDetailInfo.getPkgName(), appDetailInfo.getIcon().getUrl(), appDetailInfo.getTitle(), appDetailInfo.getAppId(), true, appDetailInfo.getVersionName(), appDetailInfo.getVersionCode(), 1, appDetailInfo.getDescription(), this.getImgUrl(appDetailInfo));
                            newTaskList.add((OsLabAppDownLoadTask)task);
                        }
                        appList.addAll(normalAppList);
                    }
                    if (null != (recommendAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getRecommendAppList(), 3)) && recommendAppList.size() > 0) {
                        for (AppDetailInfo info : recommendAppList) {
                            OsLabAppDownLoadTask task2 = new OsLabAppDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), info.getIcon().getUrl(), info.getTitle(), info.getAppId(), true, info.getVersionName(), info.getVersionCode(), 2, info.getDescription(), this.getImgUrl(info));
                            newTaskList.add(task2);
                        }
                        appList.addAll(recommendAppList);
                    }
                    DBManager.getInstance().saveOrUpdateOsLabAppDetailList(appList, appUpdateRes.getValidEndTime());
                    List list = SpUtil.getSP().getIntList("OS_LAB_APP_UPDATE_PLAN_LIST", new ArrayList());
                    list.add(appUpdateRes.getPlanId());
                    SpUtil.getSP().putString("OS_LAB_APP_UPDATE_PLAN_LIST", Tson.toJson((Object)list));
                    CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia  parseData  success ================================");
                    if (null != appUpdateCallback) {
                        String newTaskListJson = Tson.toJson(newTaskList);
                        appUpdateCallback.onRequestSuccess(newTaskListJson);
                    } else {
                        this.saveOslabNewTaskList(newTaskList);
                    }
                    int count = 0;
                    if (normalAppList != null && normalAppList.size() > 0) {
                        count = normalAppList.size();
                    }
                    if (recommendAppList != null && recommendAppList.size() > 0) {
                        count += recommendAppList.size();
                    }
                    String activity = "com.transsion.appupdate.oslabui.OsLabActivity";
                    String mPackageName = "com.transsion.plat.appupdate";
                    CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia  count=  " + count);
                    int finalCount = count;
                    DataRepository mRepository = DataRepository.getInstance(CoreUtil.getContext().getApplicationContext());
                    mRepository.loadOsLabRedCount(redCount -> {
                        CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia  redCount=  " + redCount + " finalCount =" + finalCount);
                        AiMessageUtil.setChangeBudge(CoreUtil.getContext(), mPackageName, activity, redCount);
                        if (redCount > 0) {
                            AiMessageUtil.setTipBudge(CoreUtil.getContext(), mPackageName, activity, 1);
                        }
                    });
                    OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, appUpdateRes.getPlanId(), 0, this.ListToJson(appUpdateRes.getSilentAppList()), this.ListToJson(appUpdateRes.getUpgradeAppList()), this.ListToJson(appUpdateRes.getRecommendAppList()));
                    TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_SYNC, osLabTrackBean);
                } else if (null != appUpdateCallback) {
                    appUpdateCallback.onRequestFailed("DATA IS NULL");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String ListToJson(List<AppDetailInfo> infoList) {
        ArrayList<OsLabSyncBean> list = new ArrayList<OsLabSyncBean>();
        if (infoList != null && infoList.size() > 0) {
            for (AppDetailInfo appDetailInfo : infoList) {
                list.add(new OsLabSyncBean(appDetailInfo.getTitle(), appDetailInfo.getPkgName(), appDetailInfo.getVersionCode()));
            }
        }
        return list.size() > 0 ? Tson.toJson(list) : "";
    }

    private List<AppDetailInfo> checkEffectiveAppDetailInfo(List<AppDetailInfo> appDetailInfoList, int appType) {
        ArrayList<AppDetailInfo> replaceAppList = new ArrayList<AppDetailInfo>();
        if (appDetailInfoList == null || 0 == appDetailInfoList.size()) {
            return replaceAppList;
        }
        ArrayList<String> appIdList = new ArrayList<String>();
        Iterator<AppDetailInfo> iterator = appDetailInfoList.iterator();
        while (iterator.hasNext()) {
            AppDetailInfo app = iterator.next();
            if (app == null) {
                iterator.remove();
                continue;
            }
            if (!TextUtils.isEmpty((CharSequence)app.getPkgName())) {
                if (2 == appType && !PackageUtil.checkApkUpdate(CoreUtil.getContext(), app.getPkgName(), app.getVersionCode())) {
                    iterator.remove();
                    continue;
                }
                if (PackageUtil.checkApkExist(CoreUtil.getContext(), app.getPkgName(), app.getVersionCode())) {
                    iterator.remove();
                    continue;
                }
            } else {
                iterator.remove();
                continue;
            }
            appIdList.add(String.valueOf(app.getAppId()));
        }
        if (0 == appIdList.size()) {
            return replaceAppList;
        }
        List<AppDetailInfo> dbAppList = DBManager.getInstance().getOsLabAppDetailListByAppIdList(appIdList);
        SparseArray dbAppMap = null;
        if (dbAppList != null && dbAppList.size() > 0) {
            dbAppMap = new SparseArray();
            for (AppDetailInfo appDetailInfo : dbAppList) {
                dbAppMap.put(appDetailInfo.getAppId(), (Object)appDetailInfo);
            }
        }
        for (AppDetailInfo appDetailInfo : appDetailInfoList) {
            if (dbAppMap != null) {
                AppDetailInfo dbApp = (AppDetailInfo)dbAppMap.get(appDetailInfo.getAppId());
                if (dbApp != null) {
                    if (appDetailInfo.getVersionCode() > dbApp.getVersionCode()) {
                        replaceAppList.add(appDetailInfo);
                        continue;
                    }
                    if (1 == appType || appDetailInfo.getVersionCode() != dbApp.getVersionCode() || appDetailInfo.getDescVersion() <= dbApp.getDescVersion()) continue;
                    replaceAppList.add(appDetailInfo);
                    continue;
                }
                replaceAppList.add(appDetailInfo);
                continue;
            }
            replaceAppList.add(appDetailInfo);
        }
        return replaceAppList;
    }

    private String getImgUrl(AppDetailInfo info) {
        if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
            return null;
        }
        return ((ImgInfo)info.getImages().get(0)).getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOslabNewTaskList(List<OsLabAppDownLoadTask> newTaskList) {
        if (newTaskList != null && !newTaskList.isEmpty()) {
            ArrayList<OsLabAppDownLoadTask> appList = new ArrayList<OsLabAppDownLoadTask>(newTaskList);
            String newTaskListJson = DataSyncUtil.getOslabNewTaskListJson("OSLAB_UPDATE_NEW_TASK_LIST");
            if (!TextUtils.isEmpty((CharSequence)newTaskListJson)) {
                try {
                    OsLabAppDownloadTaskData appTaskData = (OsLabAppDownloadTaskData)Tson.fromJson((String)newTaskListJson, OsLabAppDownloadTaskData.class);
                    if (appTaskData != null && appTaskData.getTaskList() != null && !appTaskData.getTaskList().isEmpty()) {
                        appList.addAll(appTaskData.getTaskList());
                    }
                }
                catch (Exception e) {
                    CS.log.e("TMS_MEDIA", e.getMessage());
                }
                finally {
                    DataSyncUtil.clearOslabNewTaskList("OSLAB_UPDATE_NEW_TASK_LIST");
                }
            }
            OsLabAppDownloadTaskData data = new OsLabAppDownloadTaskData();
            data.setTaskList(appList);
            String jsonData = Tson.toJson((Object)data);
            Context context = CoreUtil.getContext();
            Intent intent = new Intent(context, OsLabDataSyncService.class);
            intent.putExtra("oslab_media", 1);
            intent.putExtra("oslab_taskList", jsonData);
            try {
                context.startService(intent);
            }
            catch (Exception e) {
                DataSyncUtil.saveOslabNewTaskList(newTaskList, "OSLAB_UPDATE_NEW_TASK_LIST");
            }
        }
    }

    private static class AppSyncTask
    extends AsyncTask<String, Integer, List<AppInfo>> {
        IMediaCallback iMediaCallback = null;

        AppSyncTask(IMediaCallback callback) {
            this.iMediaCallback = callback;
        }

        protected List<AppInfo> doInBackground(String ... params) {
            if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
                return null;
            }
            List<AppInfo> appInfoList = PackageUtil.initAppList(CoreUtil.getContext());
            if (null != appInfoList && appInfoList.size() > 0) {
                return appInfoList;
            }
            return null;
        }

        protected void onPostExecute(List<AppInfo> appInfoList) {
            if (null != configMedia) {
                PhoneInfo phoneInfo = PhoneInfoManager.getInstance().getPhoneInfo();
                List planIDList = SpUtil.getSP().getIntList("OS_LAB_APP_UPDATE_PLAN_LIST", null);
                configMedia.syncDataInternal(phoneInfo, planIDList, appInfoList, 0, this.iMediaCallback);
            }
        }
    }
}

