/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.transsion.appupdate.R;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.oslabui.OsLabAppEditActivity;
import com.transsion.appupdate.oslabui.OsLabAppUpdateAdapter;
import com.transsion.appupdate.oslabui.OsLabAppUpdatePresenter;
import com.transsion.appupdate.oslabui.OsLabContract;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.ui.main.AlertMobileFragment;
import com.transsion.appupdate.utils.ButtonUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.TimeUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.utils.ToastUtil;
import com.transsion.transsion_gdpr.GdprUtil;
import com.transsion.widgetslibs.dialog.PromptDialog;
import java.util.ArrayList;
import java.util.Locale;

public class OsLabActivity
extends Activity
implements OsLabContract.View {
    public static final String INTENT_PARAM_ENTER_TYPE = "enterType";
    public static final String INTENT_PARAM_ENTER_TYPE_NOTIFICATION = "notification";
    private LinearLayout mContainerView;
    private View mLoadingView;
    private ProgressBar hasContentLoading;
    private View mBlankView;
    private RecyclerView mRecyclerView;
    private TextView mTextBlank;
    private ImageView mImgBlank;
    private ImageButton mBtnOverflow;
    private PopupMenu mPopupMenu;
    private OsLabAppUpdateAdapter mAdapter;
    private OsLabAppUpdatePresenter mPresenter;
    private PromptDialog mPrivacyPolicyDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.checkLeftStorage();
        this.setContentView(R.layout.activity_oslabapp_update);
        this.initView();
        this.initData();
        this.checkPrivacyPolicy();
        this.recordEnterTime();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.checkPrivacyPolicy();
    }

    private void checkLeftStorage() {
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            CS.log.d("TMS_APP", "oslab checkLeftStorage() -> lack of space");
            Toast.makeText((Context)this, (int)R.string.lack_space, (int)1).show();
            this.finish();
        }
    }

    private void setLightNavBar() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setSystemUiVisibility(this.getWindow().getDecorView().getSystemUiVisibility() | 0x10);
        }
    }

    private void initView() {
        this.initToolbar();
        this.mContainerView = (LinearLayout)this.findViewById(R.id.linear_container);
        this.mLoadingView = this.findViewById(R.id.frame_loading);
        this.hasContentLoading = (ProgressBar)this.findViewById(R.id.hasContent_loading);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
    }

    private void initToolbar() {
        TextView textTitle = (TextView)this.findViewById(R.id.text_title);
        textTitle.setSingleLine(true);
        textTitle.setEllipsize(TextUtils.TruncateAt.END);
        if (TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
            textTitle.setGravity(5);
        }
        this.findViewById(R.id.btn_back).setOnClickListener(v -> this.finish());
        this.mBtnOverflow = (ImageButton)this.findViewById(R.id.btn_overflow);
        this.mBtnOverflow.setOnClickListener(v -> this.popupMenu());
    }

    private void initData() {
        try {
            this.mPresenter = new OsLabAppUpdatePresenter(this);
            new Handler().post(() -> {
                this.mPresenter.loadData();
                Intent intent = this.getIntent();
                if (intent != null) {
                    Uri data = intent.getData();
                    if (data != null) {
                        this.mPresenter.trackAppEvent(1);
                    } else {
                        this.mPresenter.trackAppEvent(0);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkPrivacyPolicy() {
        if (!PrivacyPolicyUtil.isUserPrivacyPolicyAgreed()) {
            this.showOSPrivacyPolicyDialog();
        }
    }

    private void showPrivacyPolicyDialog() {
        if (this.mPrivacyPolicyDialog == null) {
            this.mPrivacyPolicyDialog = new PromptDialog.Builder((Context)this).setView(R.layout.dialog_privacy_policy).create();
            this.mPrivacyPolicyDialog.show();
            Window dialogWindow = this.mPrivacyPolicyDialog.getWindow();
            if (dialogWindow != null) {
                TextView tvContent;
                View ivClose;
                View btnAccept = dialogWindow.findViewById(R.id.btn_privacy_policy_accept);
                if (btnAccept != null) {
                    btnAccept.setOnClickListener(v -> {
                        PrivacyPolicyUtil.userAgreePrivacyPolicy();
                        TrackerOsLab.enableTrackData();
                        if (this.mPrivacyPolicyDialog != null) {
                            this.mPrivacyPolicyDialog.dismiss();
                        }
                        CS.log.d("TMS_APP", "dialog press accept");
                    });
                }
                if ((ivClose = dialogWindow.findViewById(R.id.iv_privacy_policy_close)) != null) {
                    ivClose.setOnClickListener(v -> {
                        if (this.mPrivacyPolicyDialog != null) {
                            this.mPrivacyPolicyDialog.dismiss();
                        }
                    });
                }
                if ((tvContent = (TextView)dialogWindow.findViewById(R.id.tv_privacy_policy_content)) != null) {
                    tvContent.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.dialog_privacy_policy_content)));
                    tvContent.setMovementMethod(LinkMovementMethod.getInstance());
                }
            }
        } else {
            this.mPrivacyPolicyDialog.show();
        }
    }

    private void showOSPrivacyPolicyDialog() {
        GdprUtil.wantToShowGdpr((FragmentManager)this.getFragmentManager(), (GdprUtil.DialogCallback)new GdprUtil.DialogCallback(){

            public void onNegativeCallback() {
                CS.log.d("TMS_APP", "OSLab showOSPrivacyPolicyDialog() -> cancel");
            }

            public void onPossitiveCallback() {
                PrivacyPolicyUtil.userAgreePrivacyPolicy();
                TrackerOsLab.enableTrackData();
                CS.log.d("TMS_APP", "OSLab showOSPrivacyPolicyDialog() -> accept");
            }
        });
    }

    private void recordEnterTime() {
        SpUtil.getSP().putLong("LAST_ENTER_APP_UPDATE_TIME", System.currentTimeMillis());
    }

    private void popupMenu() {
        if (this.mPopupMenu == null) {
            this.mPopupMenu = new PopupMenu((Context)this, (View)this.mBtnOverflow, 0, 0, R.style.PopupMenuStyle);
            this.mPopupMenu.inflate(R.menu.menu);
            this.mPopupMenu.setOnMenuItemClickListener(item -> {
                if (item.getItemId() == R.id.menu_edit) {
                    this.mPresenter.pauseAll();
                    this.startActivityForResult(new Intent((Context)this, OsLabAppEditActivity.class), 161);
                    this.mPresenter.trackAppListEvent(TrackerOsLab.TID.TMS_OSLAB_LIST_EDIT_CLICK, null);
                    return true;
                }
                return false;
            });
        }
        if (this.mPresenter.isEditable()) {
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setEnabled(true);
        } else {
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setEnabled(false);
        }
        this.mPopupMenu.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 161) {
            this.mPresenter.loadData();
        }
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void showLoadingView() {
        if (this.mLoadingView.getVisibility() == 8) {
            this.mLoadingView.setVisibility(0);
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setVisibility(8);
        }
        if (this.mBlankView != null) {
            this.mBlankView.setVisibility(8);
        }
        this.mBtnOverflow.setEnabled(false);
    }

    @Override
    public void showBlankView(boolean isError) {
        this.mBtnOverflow.setEnabled(true);
        if (this.mLoadingView.getVisibility() == 0) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.hasContentLoading.getVisibility() == 0) {
            this.hasContentLoading.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() == 0) {
            this.mRecyclerView.setVisibility(8);
        }
        if (this.mBlankView == null) {
            this.mBlankView = this.getLayoutInflater().inflate(R.layout.oslab_blank_view_layout, (ViewGroup)this.mContainerView, false);
            this.mContainerView.addView(this.mBlankView);
            this.mTextBlank = (TextView)this.findViewById(R.id.text_blank);
            this.mImgBlank = (ImageView)this.findViewById(R.id.img_blank);
        } else {
            this.mBlankView.setVisibility(0);
        }
        if (isError) {
            if (StorageUtils.isExternalStorageMounted() && StorageUtils.getUsagePercent() < 10L) {
                this.mTextBlank.setText(R.string.lack_space);
                this.mImgBlank.setImageResource(R.drawable.ic_no_storage_vector);
            } else {
                this.mTextBlank.setText(R.string.network_error);
                this.mImgBlank.setImageResource(R.drawable.ic_no_network_vector);
            }
        } else if (NetworkUtil.isConnected(this.getApplicationContext())) {
            this.mTextBlank.setText(R.string.lab_nofeatures);
            this.mImgBlank.setImageResource(R.drawable.ic_no_update_vector);
        } else {
            this.mTextBlank.setText(R.string.no_network);
            this.mImgBlank.setImageResource(R.drawable.ic_no_network_vector);
        }
    }

    @Override
    public void showListView(ArrayList<ListItem> list) {
        this.mBtnOverflow.setEnabled(true);
        if (this.mLoadingView.getVisibility() == 0) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.hasContentLoading.getVisibility() == 0) {
            this.hasContentLoading.setVisibility(8);
        }
        if (this.mBlankView != null && this.mBlankView.getVisibility() == 0) {
            this.mBlankView.setVisibility(8);
        }
        this.mRecyclerView.setVisibility(0);
        if (this.mAdapter == null) {
            this.mAdapter = new OsLabAppUpdateAdapter(list, this.getLayoutInflater(), this::itemDownloadClick);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        } else {
            this.mAdapter.updateList(list);
        }
        int pkn = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof AppItem)) continue;
            this.mPresenter.trackAppListEvent(TrackerOsLab.TID.TMS_OSLAB_ITEM_SHOW, (AppItem)list.get(i));
            ++pkn;
        }
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200009, -1);
        osLabTrackBean.setPkn(pkn);
        osLabTrackBean.setPageId("ol_main");
        TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_ITEM_SUM, osLabTrackBean);
    }

    @Override
    public void showListViewPreload(ArrayList<ListItem> list) {
        this.mBtnOverflow.setEnabled(true);
        if (this.mLoadingView.getVisibility() == 0) {
            this.mLoadingView.setVisibility(8);
        }
        this.hasContentLoading.setVisibility(0);
        this.mRecyclerView.setVisibility(0);
        if (this.mAdapter == null) {
            this.mAdapter = new OsLabAppUpdateAdapter(list, this.getLayoutInflater(), this::itemDownloadClick);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        } else {
            this.mAdapter.updateList(list);
        }
    }

    private void itemDownloadClick(int pos, AppItem item) {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            if (NetworkUtil.isMobileData(this.getApplicationContext()) && (UpdateConstants.STATE_INITIAL.equals(item.state) || UpdateConstants.STATE_PAUSED.equals(item.state) || UpdateConstants.STATE_FAILED.equals(item.state))) {
                this.showAlertMobileDialog(() -> this.mPresenter.requestDownload(item));
            } else {
                this.mPresenter.requestDownload(item);
            }
        } else {
            ToastUtil.showToast((int)R.string.no_network);
        }
    }

    private void updateAllAfterCheckNet() {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            if (NetworkUtil.isMobileData(this.getApplicationContext())) {
                if (this.mPresenter.canUpdateAll()) {
                    this.showAlertMobileDialog(() -> this.mPresenter.requestAllDownload());
                }
            } else {
                this.mPresenter.requestAllDownload();
            }
        } else {
            ToastUtil.showToast((int)R.string.no_network);
        }
    }

    private void showAlertMobileDialog(AlertMobileFragment.OnPositiveBtnListener listener) {
        if (TimeUtil.isToday()) {
            if (listener != null) {
                listener.onOnPositiveBtnClick();
            }
        } else {
            AlertMobileFragment amf = new AlertMobileFragment();
            amf.setOnPositiveBtnListener(listener);
            amf.show(this.getFragmentManager(), "AlertMobileFragment");
        }
    }

    @Override
    public void notifyItemChanged(int position, int type) {
        this.mAdapter.notifyItemChanged(position, type);
    }

    @Override
    public void notifyItemRemove(int position) {
        this.mAdapter.notifyOsAppRemove(position);
    }

    @Override
    public void notifyItemAdd(int position, ListItem item) {
        this.mAdapter.notifyOsAppAdd(position, item);
    }

    @Override
    public void updateList(ArrayList<ListItem> list) {
        this.mAdapter.updateList(list);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof AppItem)) continue;
            this.mPresenter.trackAppListEvent(TrackerOsLab.TID.TMS_OSLAB_ITEM_SHOW, (AppItem)list.get(i));
        }
    }

    protected void onDestroy() {
        this.mPresenter.onDestroy();
        super.onDestroy();
        if (this.mPrivacyPolicyDialog != null) {
            this.mPrivacyPolicyDialog.dismiss();
            this.mPrivacyPolicyDialog = null;
        }
        StorageUtils.fixInputMethodManagerLeak((Context)this);
    }

    protected void onResume() {
        super.onResume();
        this.mPresenter.removeUninstallApp();
    }

    public void onLowMemory() {
        Glide.get((Context)this.getApplicationContext()).clearMemory();
    }

    public void onTrimMemory(int level) {
        if (level == 20) {
            Glide.get((Context)this.getApplicationContext()).clearMemory();
        }
        Glide.get((Context)this.getApplicationContext()).trimMemory(level);
    }
}

