/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.CheckBox;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.oslabui.OsLabAppEditAdapter;
import com.transsion.appupdate.oslabui.OsLabDeleteFragment;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.widgetslibs.widgets.FootOptBar;
import java.util.ArrayList;

public class OsLabAppEditActivity
extends Activity {
    private TextView mCountView;
    private CheckBox mCheckSelect;
    private RecyclerView mRecyclerEdit;
    private OsLabAppEditAdapter mAdapter;
    private FootOptBar mFootOptBar;
    private OsLabDeleteFragment mDeleteFragment;
    private long psts;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.oslab_activity_app_edit);
        this.mCountView = (TextView)this.findViewById(R.id.text_count);
        this.findViewById(R.id.btn_back).setOnClickListener(v -> {
            this.setResult(0);
            this.finish();
        });
        this.mCheckSelect = (CheckBox)this.findViewById(R.id.check_select);
        this.mCheckSelect.setOnClickListener(v -> {
            if (this.mAdapter != null) {
                int size;
                int checkedCount = this.mAdapter.checkedCount();
                this.mAdapter.checkAll(checkedCount < (size = this.mAdapter.getItemCount()));
                this.updateView();
            }
        });
        this.mRecyclerEdit = (RecyclerView)this.findViewById(R.id.recycler_edit);
        this.mRecyclerEdit.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mFootOptBar = (FootOptBar)this.findViewById(R.id.foot_opt_bar);
        this.mFootOptBar.addItemViews(new int[]{R.drawable.ic_oslab_delete}, new int[]{R.string.delete});
        this.mFootOptBar.changeItemEnable(0, false);
        this.mFootOptBar.setOnFootItemClickListener(index -> this.showDeleteDialog());
        DataRepository.getInstance((Context)this).loadPausedOsLabAppItems(this::updateData);
        this.psts = System.currentTimeMillis();
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(this.psts, 0L, -1);
        osLabTrackBean.setPageId("ol_edit");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_EDIT_PV, osLabTrackBean);
    }

    private void setLightNavBar() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setSystemUiVisibility(this.getWindow().getDecorView().getSystemUiVisibility() | 0x10);
        }
    }

    private void updateData(ArrayList<AppItem> list) {
        this.mAdapter = new OsLabAppEditAdapter(this.getLayoutInflater(), list);
        this.mRecyclerEdit.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnItemCheckListener(this::updateView);
        this.updateView();
    }

    private void updateView() {
        int checkedCount = this.mAdapter.checkedCount();
        int size = this.mAdapter.getItemCount();
        String title = checkedCount + "/" + size;
        this.mCountView.setText((CharSequence)title);
        this.mCheckSelect.setChecked(size > 0 && checkedCount == size);
        this.mFootOptBar.changeItemEnable(0, checkedCount > 0);
    }

    private void showDeleteDialog() {
        if (this.mDeleteFragment == null) {
            this.mDeleteFragment = new OsLabDeleteFragment();
            this.mDeleteFragment.setOnDeleteListener(this::deleteFiles);
        }
        if (!this.mDeleteFragment.isAdded()) {
            this.mDeleteFragment.show(this.getFragmentManager(), "OsLabDeleteFragment");
        }
    }

    private void deleteFiles() {
        this.mFootOptBar.changeItemEnable(0, false);
        ArrayList<Boolean> checkList = this.mAdapter.getCheckList();
        ArrayList<AppItem> list = this.mAdapter.getList();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> appIds = new ArrayList<String>();
        for (int i = checkList.size() - 1; i >= 0; --i) {
            if (!checkList.get(i).booleanValue()) continue;
            AppItem appItem = list.get(i);
            OsLabTrackBean osLabTrackBean = new OsLabTrackBean(appItem.pkgName, appItem.appVersionCode, appItem.type, appItem.state);
            osLabTrackBean.setPageId("ol_edit");
            TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_LIST_DELETE_CLICK, osLabTrackBean);
            urls.add(list.get((int)i).apkUrl);
            appIds.add(String.valueOf(list.get((int)i).appId));
            list.remove(i);
            checkList.remove(i);
        }
        DataRepository.getInstance((Context)this).oslabDeleteDownloadTasks(urls, isOk -> {
            if (list.size() == 0) {
                this.setResult(0);
                this.finish();
            }
        });
        this.mAdapter.notifyDataSetChanged();
        this.updateView();
    }

    protected void onDestroy() {
        this.mDeleteFragment = null;
        super.onDestroy();
        OsLabTrackBean osLabTrackBean1 = new OsLabTrackBean(this.psts, System.currentTimeMillis(), -1);
        osLabTrackBean1.setPageId("ol_edit");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_EDIT_PV, osLabTrackBean1);
    }
}

