/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.application.GlideApp;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.utils.StorageUtils;
import java.util.ArrayList;
import java.util.List;

class OsLabAppEditAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private LayoutInflater mInflater;
    private ArrayList<AppItem> mList;
    private ArrayList<Boolean> mCheckList;
    private OnItemCheckListener mListener;

    public OsLabAppEditAdapter(LayoutInflater inflater, ArrayList<AppItem> list) {
        this.mInflater = inflater;
        this.mList = list;
        this.mCheckList = new ArrayList();
        this.updateCheckList();
    }

    private void updateCheckList() {
        this.mCheckList.clear();
        int size = this.mList.size();
        for (int i = 0; i < size; ++i) {
            this.mCheckList.add(false);
        }
    }

    public int checkedCount() {
        int count = 0;
        int size = this.mCheckList.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mCheckList.get(i).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<Boolean> getCheckList() {
        return this.mCheckList;
    }

    public ArrayList<AppItem> getList() {
        return this.mList;
    }

    public void checkAll(boolean checked) {
        int size = this.mCheckList.size();
        for (int i = 0; i < size; ++i) {
            this.mCheckList.set(i, checked);
            this.notifyItemChanged(i, 0);
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(this.mInflater.inflate(R.layout.oslab_app_edit_item_layout, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position, List<Object> payloads) {
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            holder.updateCheck(this.mCheckList.get(position));
        }
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.bindView(this.mList.get(position), this.mCheckList.get(position), v -> {
            this.mCheckList.set(position, this.mCheckList.get(position) == false);
            this.notifyItemChanged(position, 0);
            if (this.mListener != null) {
                this.mListener.onItemChecked();
            }
        });
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public void setOnItemCheckListener(OnItemCheckListener l) {
        this.mListener = l;
    }

    public static interface OnItemCheckListener {
        public void onItemChecked();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIconView;
        private TextView mNameView;
        private ProgressBar mProgressBar;
        private TextView mDetailView;
        private CheckBox mCheckItem;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mIconView = (ImageView)itemView.findViewById(R.id.img_app_icon);
            this.mNameView = (TextView)itemView.findViewById(R.id.text_app_name);
            this.mProgressBar = (ProgressBar)itemView.findViewById(R.id.progress_app_bar);
            this.mProgressBar.setMax(100);
            this.mDetailView = (TextView)itemView.findViewById(R.id.text_app_detail);
            this.mCheckItem = (CheckBox)itemView.findViewById(R.id.check_app_item);
        }

        public void bindView(AppItem item, boolean isChecked, View.OnClickListener listener) {
            this.mNameView.setText((CharSequence)item.appName);
            GlideApp.with(this.itemView.getContext()).load(item.appIconUrl).placeholder(R.drawable.ic_application_vector).error(R.drawable.ic_application_vector).into(this.mIconView);
            String progressInfo = StorageUtils.convertFromByte(item.downloadSize) + "/" + StorageUtils.convertFromByte(item.allSize);
            this.mDetailView.setText((CharSequence)progressInfo);
            this.mProgressBar.setProgress(this.getPercent(item.downloadSize, item.allSize));
            this.mCheckItem.setChecked(isChecked);
            this.itemView.setOnClickListener(listener);
        }

        public void updateCheck(boolean isChecked) {
            this.mCheckItem.setChecked(isChecked);
        }

        private int getPercent(int downloadSize, int allSize) {
            if (allSize != 0) {
                return (int)((long)downloadSize * 100L / (long)allSize);
            }
            return 0;
        }
    }
}

