/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.oslabui.util.AthenaCust;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;

public class TrackerOsLab {
    private static FirebaseAnalytics mFirebaseAnalytics;

    public static void trackClick(TID tid, OsLabTrackBean osLabTrackBean) {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (osLabTrackBean == null) {
            osLabTrackBean = new OsLabTrackBean();
        }
        new AthenaCust(tid.getName(), tid.getTid()).trackClick(osLabTrackBean.getBundle(), null).setPageId(osLabTrackBean.getPageId()).setPageUrl(osLabTrackBean.getPageUrl()).setPrePageUrl(osLabTrackBean.getPrePageUrl()).setSource(osLabTrackBean.getSource()).submit();
        TrackerOsLab.trackFireBase(tid, osLabTrackBean.getBundle());
    }

    public static void trackCommon(TID tid, OsLabTrackBean osLabTrackBean) {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (osLabTrackBean == null) {
            osLabTrackBean = new OsLabTrackBean();
        }
        new AthenaCust(tid.getName(), tid.getTid()).trackCommon(osLabTrackBean.getBundle(), null).setPageId(osLabTrackBean.getPageId()).setPageUrl(osLabTrackBean.getPageUrl()).setPrePageUrl(osLabTrackBean.getPrePageUrl()).setSource(osLabTrackBean.getSource()).submit();
        TrackerOsLab.trackFireBase(tid, osLabTrackBean.getBundle());
    }

    public static void trackPV(TID tid, OsLabTrackBean osLabTrackBean) {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (osLabTrackBean == null) {
            osLabTrackBean = new OsLabTrackBean();
        }
        new AthenaCust(tid.getName(), tid.getTid()).trackPV(osLabTrackBean.getPsts(), osLabTrackBean.getPets(), 0, osLabTrackBean.getBundle()).setPageId(osLabTrackBean.getPageId()).setPageUrl(osLabTrackBean.getPageUrl()).setPrePageUrl(osLabTrackBean.getPrePageUrl()).setSource(osLabTrackBean.getSource()).submit();
    }

    @SuppressLint(value={"MissingPermission"})
    private static void trackFireBase(TID tid, Bundle bundle) {
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        mFirebaseAnalytics.logEvent(tid.name, bundle);
    }

    @SuppressLint(value={"MissingPermission"})
    public static void enableTrackData() {
        AthenaAnalytics.enable((boolean)true);
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        mFirebaseAnalytics.setAnalyticsCollectionEnabled(true);
    }

    public static enum TID {
        TMS_OSLAB_ENTER("ol_null_op_ep", 10487001),
        TMS_OSLAB_SYNC("ol_null_rq_ep", 10487001),
        TMS_OSLAB_LIST_CLICK_DOWNLOAD("ol_main_dc_cl", 10488001),
        TMS_OSLAB_CLICKDOWNLOAD_DETAIL("ol_carddetail_dc_cl", 10488001),
        TMS_OSLAB_DOWNLOAD_STATUS("ol_null_dr_ep", 10487001),
        TMS_OSLAB_INSTALL_STATUS("ol_null_ir_ep", 10487001),
        TMS_OSLAB_ITEM_SHOW("ol_null_cs_ep", 10487001),
        TMS_OSLAB_LIST_EDIT_CLICK("ol_main_ec_cl", 10488001),
        TMS_OSLAB_LIST_DELETE_CLICK("ol_edit_dc_cl", 10488001),
        TMS_OSLAB_OPEN_APP_LIST("ol_main_oc_cl", 10488001),
        TMS_OSLAB_OPEN_APP_DETAIL("ol_carddetail_oc_cl", 10488001),
        TMS_OSLAB_ITEM_SUM("ol_main_cs_ep", 10487001),
        TMS_OSLAB_LIKE_DISLIKE_CLICK("like_dislike_cl", 10487001),
        TMS_OSLAB_FEEDBACK_CLICK("feedback_cl", 10488001),
        TMS_OSLAB_MAIN_PV("ol_main_pv", 10489001),
        TMS_OSLAB_DETAIL_PV("ol_carddetail_pv", 10489001),
        TMS_OSLAB_EDIT_PV("ol_edit_pv", 10489001);

        private final String name;
        private final int tid;

        private TID(String name, int tid) {
            this.name = name;
            this.tid = tid;
        }

        public String getName() {
            return this.name;
        }

        public int getTid() {
            return this.tid;
        }
    }
}

