/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.api_test;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadTaskManager;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import java.util.List;

public class OsLabAppListAdapterOnlyTest
extends RecyclerView.Adapter<OsLabAppViewHolder> {
    private Context mContext;
    private List<OsLabAppDownLoadTask> osLabAppDownLoadTaskList;
    DownloadTaskManager downloadTaskManager;

    public OsLabAppListAdapterOnlyTest(Context context, List<OsLabAppDownLoadTask> osLabAppDownLoadTaskList) {
        this.mContext = context;
        this.osLabAppDownLoadTaskList = osLabAppDownLoadTaskList;
        this.downloadTaskManager = AppDownloadTaskManager.getInstance(context.getApplicationContext());
    }

    @NonNull
    public OsLabAppViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View creativeView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_lab_app_item, parent, false);
        return new OsLabAppViewHolder(creativeView);
    }

    public void onBindViewHolder(@NonNull OsLabAppViewHolder holder, int position) {
        final OsLabAppDownLoadTask osLabAppDownLoadTask = this.osLabAppDownLoadTaskList.get(position);
        holder.mAppName.setText((CharSequence)(osLabAppDownLoadTask.title + " / " + osLabAppDownLoadTask.pkgName));
        holder.mAppStatus.setText((CharSequence)(osLabAppDownLoadTask.downloadState.toString() + " : \n" + osLabAppDownLoadTask.finishedSize + " / " + osLabAppDownLoadTask.totalSize));
        holder.mBtnStart.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OsLabAppListAdapterOnlyTest.this.downloadTaskManager.startDownload(osLabAppDownLoadTask);
            }
        });
        holder.mBtnStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OsLabAppListAdapterOnlyTest.this.downloadTaskManager.pauseDownloadTask(osLabAppDownLoadTask);
            }
        });
    }

    public int getItemCount() {
        if (this.osLabAppDownLoadTaskList != null) {
            return this.osLabAppDownLoadTaskList.size();
        }
        return 0;
    }

    class OsLabAppViewHolder
    extends RecyclerView.ViewHolder {
        TextView mAppName;
        TextView mAppStatus;
        Button mBtnStart;
        Button mBtnStop;

        private void assignViews(View itemView) {
            this.mAppName = (TextView)itemView.findViewById(R.id.app_name);
            this.mAppStatus = (TextView)itemView.findViewById(R.id.app_status);
            this.mBtnStart = (Button)itemView.findViewById(R.id.btn_start);
            this.mBtnStop = (Button)itemView.findViewById(R.id.btn_stop);
        }

        OsLabAppViewHolder(View itemView) {
            super(itemView);
            this.assignViews(itemView);
        }
    }
}

