/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.transsion.appupdate.R;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.utils.MeasureUtil;
import java.util.Locale;

public class OsLabDownloadProgressBar
extends ProgressBar {
    private Context mContext;
    private Paint mPaint;
    private PorterDuffXfermode mPorterDuffXfermode;
    private float mProgress;
    private DownloadState mState;
    private int mApkType = 2;
    private static final float TEXT_SIZE_SP = 12.0f;
    private static final float ICON_TEXT_SPACING_DP = 5.0f;
    private Bitmap mTmpBitmap;

    public OsLabDownloadProgressBar(Context context) {
        super(context, null, 16842872);
        this.mContext = context;
        this.init();
    }

    public OsLabDownloadProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public synchronized void setDownloadState(DownloadState state) {
        this.mState = state;
        this.invalidate();
    }

    public synchronized void setDownloadState(DownloadState state, int apkType) {
        this.mState = state;
        this.mApkType = apkType;
        this.invalidate();
    }

    public synchronized void setDownloadProgress(int progress) {
        super.setProgress(progress);
        this.mProgress = progress;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.mState) {
            case WAITING: 
            case DOWNLOADING: 
            case PAUSE: 
            case FAILED: {
                this.drawIconAndText(canvas, this.mState, false, this.mApkType);
                break;
            }
            case INITIAL: 
            case OPENED: 
            case FINISHED: 
            case INSTALLING: 
            case INSTALLED: {
                this.drawIconAndText(canvas, this.mState, true, this.mApkType);
                break;
            }
            default: {
                this.drawIconAndText(canvas, this.mState, false, this.mApkType);
            }
        }
    }

    private void init() {
        this.setIndeterminate(false);
        this.setIndeterminateDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)17301613));
        this.setProgressDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.oslab_shape_download_progress_gradient));
        this.setMax(100);
        this.mPaint = new Paint();
        this.mPaint.setDither(true);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setTextAlign(Paint.Align.LEFT);
        this.mPaint.setTextSize((float)MeasureUtil.sp2px(this.mContext, 12.0f));
        this.mPaint.setFakeBoldText(true);
        this.mPorterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
    }

    private void drawIconAndText(Canvas canvas, DownloadState state, boolean onlyText, int apkType) {
        this.initForState(state);
        String text = this.getText(state, apkType);
        Rect textRect = new Rect();
        this.mPaint.getTextBounds(text, 0, text.length(), textRect);
        if (onlyText) {
            float textX = this.getWidth() / 2 - textRect.centerX();
            float textY = this.getHeight() / 2 - textRect.centerY();
            canvas.drawText(text, textX, textY, this.mPaint);
        } else {
            Bitmap bufferBitmap;
            float textX = (float)(this.getWidth() / 2) - this.getOffsetX(0.0f, textRect.centerX(), 5.0f, true);
            float textY = this.getHeight() / 2 - textRect.centerY();
            canvas.drawText(text, textX, textY, this.mPaint);
            if (state == DownloadState.INITIAL) {
                return;
            }
            if (this.mTmpBitmap != null) {
                bufferBitmap = this.mTmpBitmap;
            } else {
                this.mTmpBitmap = bufferBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            bufferBitmap.eraseColor(0);
            Canvas bufferCanvas = new Canvas(bufferBitmap);
            bufferCanvas.drawText(text, textX, textY, this.mPaint);
            this.mPaint.setXfermode((Xfermode)this.mPorterDuffXfermode);
            this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.download_detail_progress_text));
            RectF rectF = TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1 ? new RectF((float)this.getWidth() * (1.0f - this.mProgress / 100.0f), 0.0f, (float)this.getWidth(), (float)this.getHeight()) : new RectF(0.0f, 0.0f, (float)this.getWidth() * this.mProgress / 100.0f, (float)this.getHeight());
            bufferCanvas.drawRect(rectF, this.mPaint);
            canvas.drawBitmap(bufferBitmap, 0.0f, 0.0f, null);
            this.mPaint.setXfermode(null);
        }
    }

    private void initForState(DownloadState state) {
        switch (state) {
            case WAITING: 
            case DOWNLOADING: 
            case PAUSE: {
                this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.ic_vector_fill_color));
                break;
            }
            case INITIAL: {
                this.setProgress(0);
                this.mProgress = 0.0f;
                this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.ic_vector_fill_color));
                break;
            }
            case FAILED: {
                this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.ic_vector_fill_color));
                break;
            }
            case OPENED: 
            case FINISHED: 
            case INSTALLING: 
            case INSTALLED: {
                this.setProgress(100);
                this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.download_detail_progress_text));
                break;
            }
            default: {
                this.setProgress(0);
                this.mPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.ic_vector_fill_color));
            }
        }
    }

    private String getText(DownloadState state, int apkType) {
        String text;
        switch (state) {
            case INITIAL: {
                if (1 == apkType) {
                    text = this.mContext.getString(R.string.download_state_update);
                    break;
                }
                text = this.mContext.getString(R.string.download_state_download);
                break;
            }
            case WAITING: {
                text = this.mContext.getString(R.string.download_state_stop);
                break;
            }
            case DOWNLOADING: {
                text = this.mContext.getString(R.string.download_state_stop);
                break;
            }
            case PAUSE: {
                if (1 == apkType) {
                    text = this.mContext.getString(R.string.download_state_update);
                    break;
                }
                text = this.mContext.getString(R.string.download_state_download);
                break;
            }
            case FAILED: {
                if (1 == apkType) {
                    text = this.mContext.getString(R.string.download_state_update);
                    break;
                }
                text = this.mContext.getString(R.string.download_state_download);
                break;
            }
            case FINISHED: {
                text = this.mContext.getString(R.string.download_state_installing);
                break;
            }
            case INSTALLING: {
                text = this.mContext.getString(R.string.download_state_installing);
                break;
            }
            case INSTALLED: {
                text = this.mContext.getString(R.string.download_state_open);
                break;
            }
            default: {
                text = this.mContext.getString(R.string.download_state_download);
            }
        }
        return text;
    }

    private float getOffsetX(float iconWidth, float textHalfWidth, float spacing, boolean isText) {
        float totalWidth = iconWidth + (float)MeasureUtil.dip2px(this.mContext, spacing) + textHalfWidth * 2.0f;
        if (isText) {
            return totalWidth / 2.0f - iconWidth - spacing;
        }
        return totalWidth / 2.0f - iconWidth;
    }
}

